/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.MenuArrowDownIcon;

public class JButtonWithMenu
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final String UI_CLASS_ID = "ButtonWithMenuUI";
    private AbstractButton m_pushButton;
    private JButton m_menuButton;

    public JButtonWithMenu(AbstractButton mainButton) {
        this.setOpaque(false);
        this.m_pushButton = mainButton;
        this.m_pushButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JButtonWithMenu.this.getMenuButton().doClick();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JButtonWithMenu.this.getMenuButton().doClick();
                }
            }
        });
        this.add((Component)this.m_pushButton, "Center");
        this.m_menuButton = new JButton();
        IconGroup iconGroup = MenuArrowDownIcon.createMenuArrowDownIconGroup(new Insets(1, 2, 15, 1));
        this.m_menuButton.setIcon(iconGroup.getIcon(IconGroup.IconState.NORMAL));
        this.m_menuButton.setRolloverIcon(iconGroup.getIcon(IconGroup.IconState.ROLLOVER));
        this.m_menuButton.setDisabledIcon(iconGroup.getIcon(IconGroup.IconState.DISABLED));
        this.m_menuButton.setFocusPainted(false);
        this.m_menuButton.setFocusable(false);
        this.m_menuButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.m_menuButton, "East");
        FlowLayoutEx layout = new FlowLayoutEx(0, 0, 0);
        this.setLayout(layout);
        this.updateUI();
    }

    public AbstractButton getPushButton() {
        return this.m_pushButton;
    }

    public JButton getMenuButton() {
        return this.m_menuButton;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.m_pushButton.setEnabled(enable);
    }

    @Override
    public boolean isEnabled() {
        return this.m_pushButton.isEnabled();
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(UI_CLASS_ID) != null) {
            this.setUI(UIManager.getUI(this));
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

