/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;

public class JInternalFrameEx
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private int m_tabIndex = 1;
    private boolean m_resizableY = true;
    public static final String CLIENT_PROP_N_RESIZE_ENABLED = "swingScout.resizeNEnabled";
    public static final String CLIENT_PROP_W_RESIZE_ENABLED = "swingScout.resizeWEnabled";
    public static final String CLIENT_PROP_E_RESIZE_ENABLED = "swingScout.resizeEEnabled";
    public static final String CLIENT_PROP_S_RESIZE_ENABLED = "swingScout.resizeSEnabled";
    private boolean m_selectedEnabled = true;

    public JInternalFrameEx(String title, String name, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, true, closable, maximizable, iconifiable);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setCursor(Cursor.getDefaultCursor());
        contentPane.setLayout(new BorderLayoutEx());
        this.setName(name);
    }

    public int getTabIndex() {
        return this.m_tabIndex;
    }

    public void setTabIndex(int i) {
        this.m_tabIndex = i;
    }

    public boolean isResizableY() {
        return this.m_resizableY;
    }

    public void setResizableY(boolean b) {
        this.m_resizableY = b;
    }

    @Override
    public void setCursor(Cursor c) {
        if (c != null) {
            switch (c.getType()) {
                case 0: {
                    c = null;
                    break;
                }
                case 8: {
                    if (this.getClientProperty(CLIENT_PROP_N_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 6: {
                    if (this.getClientProperty(CLIENT_PROP_N_RESIZE_ENABLED) == Boolean.TRUE && this.getClientProperty(CLIENT_PROP_W_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 10: {
                    if (this.getClientProperty(CLIENT_PROP_W_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 4: {
                    if (this.getClientProperty(CLIENT_PROP_S_RESIZE_ENABLED) == Boolean.TRUE && this.getClientProperty(CLIENT_PROP_W_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 9: {
                    if (this.getClientProperty(CLIENT_PROP_S_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 5: {
                    if (this.getClientProperty(CLIENT_PROP_S_RESIZE_ENABLED) == Boolean.TRUE && this.getClientProperty(CLIENT_PROP_E_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 11: {
                    if (this.getClientProperty(CLIENT_PROP_E_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                    break;
                }
                case 7: {
                    if (this.getClientProperty(CLIENT_PROP_N_RESIZE_ENABLED) == Boolean.TRUE && this.getClientProperty(CLIENT_PROP_E_RESIZE_ENABLED) == Boolean.TRUE) break;
                    c = null;
                }
            }
        }
        super.setCursor(c);
    }

    @Override
    public void setVisible(boolean aFlag) {
        try {
            this.m_selectedEnabled = false;
            super.setVisible(aFlag);
        }
        finally {
            this.m_selectedEnabled = true;
        }
    }

    @Override
    public void setSelected(boolean selected) throws PropertyVetoException {
        if (!this.m_selectedEnabled) {
            return;
        }
        if (selected != this.isSelected) {
            super.setSelected(selected);
        }
    }

    @Override
    public JDesktopPane getDesktopPane() {
        Container p = this.getParent();
        while (p != null && !(p instanceof JDesktopPane)) {
            p = p.getParent();
        }
        if (p == null) {
            if (this.getDesktopIcon() != null) {
                p = this.getDesktopIcon().getParent();
            }
            while (p != null && !(p instanceof JDesktopPane)) {
                p = p.getParent();
            }
        }
        return (JDesktopPane)p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize() {
        Dimension d;
        if (!this.isIcon() && this.getLayout() instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 lm = (LayoutManager2)this.getLayout();
                d = lm.minimumLayoutSize(this);
                if (!this.isResizableY()) {
                    Dimension pref = lm.preferredLayoutSize(this);
                    d.height = pref.height;
                }
            }
        } else {
            d = super.getMinimumSize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension d;
        if (!this.isIcon() && this.getLayout() instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 lm = (LayoutManager2)this.getLayout();
                d = lm.preferredLayoutSize(this);
            }
        } else {
            d = super.getPreferredSize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMaximumSize() {
        Dimension d;
        if (!this.isIcon() && this.getLayout() instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 lm = (LayoutManager2)this.getLayout();
                d = lm.maximumLayoutSize(this);
                if (!this.isResizableY()) {
                    Dimension pref = lm.preferredLayoutSize(this);
                    d.height = pref.height;
                }
            }
        } else {
            d = super.getMaximumSize();
        }
        return d;
    }

    @Override
    public void restoreSubcomponentFocus() {
        if (this.isIcon()) {
            super.restoreSubcomponentFocus();
        } else {
            Component c = this.getMostRecentFocusOwner();
            if (c != null && c.isShowing() && c.isEnabled()) {
                c.requestFocus();
            } else {
                this.getContentPane().transferFocus();
            }
        }
    }
}

