/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.TextBlockDragAndDrop;
import org.eclipse.scout.rt.ui.swing.UndoableEditObserver;
import org.eclipse.scout.rt.ui.swing.form.fields.OnFieldLabelDecorator;

public class JTextAreaEx
extends JTextArea {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_ENTER_PRESSED = "actionEnterPressed";
    public static final String ACTION_ENTER_RELEASED = "actionEnterReleased";
    private OnFieldLabelDecorator m_onFieldLabelHandler;

    public JTextAreaEx() {
        SwingUtility.installDefaultFocusHandling(this);
        this.setFocusCycleRoot(false);
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        UndoableEditObserver.attach(this);
        TextBlockDragAndDrop.attach(this);
        SwingUtility.installAlternateCopyPaste(this);
        KeyStroke relesedEnter = KeyStroke.getKeyStroke("released ENTER");
        this.getInputMap().put(relesedEnter, ACTION_ENTER_RELEASED);
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.getActionMap().put(ACTION_ENTER_RELEASED, a);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9 && e.isControlDown()) {
            e = new KeyEvent(e.getComponent(), e.getID(), e.getWhen(), 0, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
        }
        super.processKeyEvent(e);
    }

    @Override
    public Color getForeground() {
        if (this.isEditable()) {
            return super.getForeground();
        }
        return this.getDisabledTextColor();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (cursor != null && cursor.getType() == 0) {
            cursor = null;
        }
        super.setCursor(cursor);
    }

    public void setOnFieldLabelHandler(OnFieldLabelDecorator onFieldLabelHandler) {
        this.m_onFieldLabelHandler = onFieldLabelHandler;
        this.repaint();
    }

    public OnFieldLabelDecorator getOnFieldLabelHandler() {
        return this.m_onFieldLabelHandler;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_onFieldLabelHandler != null) {
            this.m_onFieldLabelHandler.paintOnFieldLabel(g, this);
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

