/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.activitymap;

import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.ActivityMapColumnModel;

class JActivityMapHeaderValidator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(JActivityMapHeaderValidator.class);

    JActivityMapHeaderValidator() {
    }

    List<Rectangle> calculateTextSizeRectangles(Object[] columns, ColumnType columnType, ActivityMapColumnModel columnModel, List<Rectangle> textRects, FontMetrics fm, List<String> texts) {
        ArrayList<String> largeTexts = new ArrayList<String>();
        ArrayList<String> mediumTexts = new ArrayList<String>();
        ArrayList<String> smallTexts = new ArrayList<String>();
        this.retrieveColumnTexts(columns, columnType, columnModel, largeTexts, mediumTexts, smallTexts);
        LOG.debug("FontMetrics {0}", (Object)fm);
        LOG.debug("textrects {0}", (Object)textRects.size());
        for (Rectangle rect : textRects) {
            LOG.debug(rect.toString());
        }
        int i = 0;
        while (i < largeTexts.size()) {
            LOG.debug("large {0}, medium {1}, small {2}", new Object[]{largeTexts.get(i), mediumTexts.get(i), smallTexts.get(i)});
            ++i;
        }
        Map<Integer, ValidatedTextData> validatedTextDataMap = this.validateAllTexts(fm, textRects, largeTexts, mediumTexts, smallTexts);
        List<Rectangle> validatedRects = this.mergeTexts(validatedTextDataMap, texts);
        return validatedRects;
    }

    void retrieveColumnTexts(Object[] columns, ColumnType columnType, ActivityMapColumnModel columnModel, List<String> largeTexts, List<String> mediumTexts, List<String> smallTexts) {
        block3: {
            block2: {
                if (columnType != ColumnType.MAJOR) break block2;
                Object[] objectArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    largeTexts.add(columnModel.getMajorColumnText(o, 2));
                    mediumTexts.add(columnModel.getMajorColumnText(o, 1));
                    smallTexts.add(columnModel.getMajorColumnText(o, 0));
                    ++n2;
                }
                break block3;
            }
            if (columnType != ColumnType.MINOR) break block3;
            Object[] objectArray = columns;
            int n = columns.length;
            int n3 = 0;
            while (n3 < n) {
                Object o = objectArray[n3];
                largeTexts.add(columnModel.getMinorColumnText(o, 2));
                mediumTexts.add(columnModel.getMinorColumnText(o, 1));
                smallTexts.add(columnModel.getMinorColumnText(o, 0));
                ++n3;
            }
        }
    }

    Map<Integer, ValidatedTextData> validateAllTexts(FontMetrics fm, List<Rectangle> rects, List<String> largeTexts, List<String> mediumTexts, List<String> smallTexts) {
        HashMap<Integer, ValidatedTextData> validatedTextDataMap = new HashMap<Integer, ValidatedTextData>();
        ValidatedTextData largeTextData = this.validateTexts(fm, largeTexts, rects);
        validatedTextDataMap.put(2, largeTextData);
        if (!largeTextData.doAllTextsFitIntoRectangle()) {
            ValidatedTextData mediumTextData = this.validateTexts(fm, mediumTexts, rects);
            validatedTextDataMap.put(1, mediumTextData);
            if (!mediumTextData.doAllTextsFitIntoRectangle()) {
                ValidatedTextData smallTextData = this.validateTexts(fm, smallTexts, rects);
                validatedTextDataMap.put(0, smallTextData);
            }
        }
        return validatedTextDataMap;
    }

    ValidatedTextData validateTexts(FontMetrics fm, List<String> texts, List<Rectangle> rects) {
        ArrayList<Boolean> textsFit = new ArrayList<Boolean>();
        ArrayList<Rectangle> validatedRects = new ArrayList<Rectangle>();
        validatedRects.addAll(rects);
        int i = 0;
        while (i < validatedRects.size()) {
            boolean isTextTooLarge = false;
            String text = texts.get(i);
            if (text != null && text.length() > 0) {
                int k = i + 1;
                while (k < validatedRects.size() && (texts.get(k) == null || texts.get(k).length() == 0)) {
                    ((Rectangle)validatedRects.get((int)i)).width += ((Rectangle)validatedRects.get((int)k)).width;
                    ((Rectangle)validatedRects.get((int)k)).width = 0;
                    ++k;
                }
                isTextTooLarge = fm.stringWidth(text) > ((Rectangle)validatedRects.get((int)i)).width - 4;
                LOG.debug(String.valueOf(isTextTooLarge) + ", text " + text + ", stringwidth " + fm.stringWidth(text) + " validaterect " + (((Rectangle)validatedRects.get((int)i)).width - 4));
            }
            textsFit.add(!isTextTooLarge);
            ++i;
        }
        return new ValidatedTextData(texts, textsFit, validatedRects);
    }

    List<Rectangle> mergeTexts(Map<Integer, ValidatedTextData> validatedTextDataMap, List<String> texts) {
        ArrayList<Rectangle> validatedRectangles = new ArrayList<Rectangle>();
        ValidatedTextData largeTextData = validatedTextDataMap.get(2);
        ValidatedTextData mediumTextData = validatedTextDataMap.get(1);
        ValidatedTextData smallTextData = validatedTextDataMap.get(0);
        List<String> largeTexts = largeTextData.getTexts();
        int i = 0;
        while (i < largeTexts.size()) {
            if (!this.addTextAndRectangleIfFit(largeTextData, i, texts, validatedRectangles) && !this.addTextAndRectangleIfFit(mediumTextData, i, texts, validatedRectangles)) {
                this.addTextAndRectangle(smallTextData, i, texts, validatedRectangles);
            }
            ++i;
        }
        return validatedRectangles;
    }

    boolean addTextAndRectangleIfFit(ValidatedTextData validatedTextData, int index, List<String> resultTexts, List<Rectangle> resultRectangles) {
        if (validatedTextData != null && validatedTextData.getTextsFit().get(index).booleanValue()) {
            this.addTextAndRectangle(validatedTextData, index, resultTexts, resultRectangles);
            return true;
        }
        return false;
    }

    void addTextAndRectangle(ValidatedTextData validatedTextData, int index, List<String> resultTexts, List<Rectangle> resultRectangles) {
        resultTexts.add(validatedTextData.getTexts().get(index));
        resultRectangles.add(validatedTextData.getValidatedRectangles().get(index));
    }

    static enum ColumnType {
        MAJOR,
        MINOR;

    }

    static class ValidatedTextData {
        private final List<String> m_texts;
        private final List<Boolean> m_textsFit;
        private final List<Rectangle> m_validatedRectangles;

        ValidatedTextData(List<String> texts, List<Boolean> textsFit, List<Rectangle> validatedRectangles) {
            this.m_texts = texts;
            this.m_textsFit = textsFit;
            this.m_validatedRectangles = validatedRectangles;
        }

        List<String> getTexts() {
            return this.m_texts;
        }

        List<Boolean> getTextsFit() {
            return this.m_textsFit;
        }

        List<Rectangle> getValidatedRectangles() {
            return this.m_validatedRectangles;
        }

        boolean doAllTextsFitIntoRectangle() {
            for (Boolean textFit : this.m_textsFit) {
                if (textFit.booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

