/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.FlowLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JHyperlink;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.calendar.AbstractCalendarCell;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewEvent;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarViewListener;
import org.eclipse.scout.rt.ui.swing.ext.calendar.LargeCalendarCell;
import org.eclipse.scout.rt.ui.swing.ext.calendar.LargeCalendarCellBorder;
import org.eclipse.scout.rt.ui.swing.ext.calendar.LargeCalendarLayout;
import org.eclipse.scout.rt.ui.swing.ext.calendar.SmallCalendarCell;
import org.eclipse.scout.rt.ui.swing.ext.calendar.SmallCalendarCellBorder;
import org.eclipse.scout.rt.ui.swing.ext.calendar.SmallCalendarLayout;

public class DateChooser {
    public static final int DISPLAY_MODE_DAY = 1;
    public static final int DISPLAY_MODE_WEEK = 2;
    public static final int DISPLAY_MODE_MONTH = 3;
    public static final int DISPLAY_MODE_WORKWEEK = 4;
    public static final int MIN_CELLPANEL_HEIGHT = 150;
    private int m_displayMode = 3;
    private int m_timelessHeight = 0;
    private boolean m_largeVersion;
    private boolean m_multiSelect = false;
    private final int m_firstDayOfWeek = Calendar.getInstance().getFirstDayOfWeek();
    private int m_workDayCount = 5;
    private EventListenerList m_listenerList;
    private JPanel m_container;
    private JPanel m_headerPanel;
    private JLabel m_monthLabel;
    private JPanel m_daysPanel;
    private JPanel m_cellsPanel;
    private AbstractCalendarCell[][] m_cell;
    private TreeSet<Date> m_selectedDates = new TreeSet();
    private Date m_viewDate;
    private Date m_viewDateStart;
    private Date m_viewDateEnd;
    private HashMap<Date, AbstractCalendarCell> m_dateMap;
    private CalendarModel m_model;
    private JPanel m_controlPanel;
    private JHyperlink m_linkDay;
    private JHyperlink m_linkWorkWeek;
    private JHyperlink m_linkWeek;
    private JHyperlink m_linkMonth;
    private Object m_selectedItem;
    protected Border m_cellBorder;
    private DateChooser m_parentCalendar;
    private DateChooser m_childCalendar;
    private boolean m_calendarUpdating;
    private int m_startHour = 6;
    private int m_endHour = 19;
    private boolean m_useOverflowCells = true;
    private DateFormat m_formatHHMM;
    private boolean m_markOutOfMonthDays;
    private boolean m_markNoonHour = true;

    public DateChooser() {
        this(false);
    }

    public DateChooser(Object[] params) {
        this(false, 3, false, params);
    }

    public DateChooser(boolean largeVersion) {
        this(largeVersion, 3);
    }

    public DateChooser(boolean largeVersion, int displayMode) {
        this(largeVersion, displayMode, false);
    }

    public DateChooser(boolean largeVersion, int displayMode, boolean displayCondensed) {
        this(largeVersion, displayMode, displayCondensed, null);
    }

    public DateChooser(boolean largeVersion, int displayMode, boolean displayCondensed, Object[] params) {
        this.m_listenerList = new EventListenerList();
        this.preConstructorInitialization(params);
        this.initializationByConstructor(largeVersion, displayMode, displayCondensed);
        this.m_formatHHMM = new DateTimeFormatFactory().getHourMinute();
    }

    protected void preConstructorInitialization(Object[] params) {
    }

    private void initializationByConstructor(boolean largeVersion, int displayMode, boolean displayCondensed) {
        this.m_container = new JPanelEx(this.createLayout(largeVersion));
        this.m_container.setBorder(null);
        this.m_viewDate = DateChooser.truncDate(new Date());
        this.m_model = new EmptyCalendarModel();
        this.m_displayMode = displayMode = Math.min(4, Math.max(displayMode, 1));
        this.m_largeVersion = largeVersion;
        this.m_dateMap = new HashMap();
        Color focusColor = UIManager.getColor("Table.focusCellForeground");
        this.m_cellBorder = largeVersion ? new LargeCalendarCellBorder(focusColor) : new SmallCalendarCellBorder(focusColor);
        this.m_headerPanel = this.createHeaderPanel();
        this.m_daysPanel = this.createDaysPanel();
        this.m_cellsPanel = this.createCellsPanel();
        this.m_container.add(this.m_headerPanel);
        this.m_container.add(this.m_daysPanel);
        this.m_container.add(this.m_cellsPanel);
        if (this.m_largeVersion) {
            this.m_controlPanel = this.createControlPanel();
            this.m_container.add(this.m_controlPanel);
            this.updateControlPanelState();
        }
        this.reconfigureLayout();
        this.m_container.addMouseListener(new DateController());
        this.setDate(new Date());
    }

    public JPanel getContainer() {
        return this.m_container;
    }

    protected LayoutManager2 createLayout(boolean largeVersion) {
        if (largeVersion) {
            return new LargeCalendarLayout(this);
        }
        return new SmallCalendarLayout(this);
    }

    protected JPanel createCellsPanel() {
        JPanelEx cellsPanel = new JPanelEx();
        cellsPanel.setBackground(new Color(0xF8F8F8));
        return cellsPanel;
    }

    protected JPanel createDaysPanel() {
        JPanelEx daysPanel = new JPanelEx();
        daysPanel.setLayout(new GridLayout(1, -1));
        if (UIManager.getColor("Calendar.weekDays.foreground") != null) {
            daysPanel.setForeground(UIManager.getColor("Calendar.weekDays.foreground"));
        }
        if (UIManager.getColor("Calendar.weekDays.background") != null) {
            daysPanel.setBackground(UIManager.getColor("Calendar.weekDays.background"));
        }
        daysPanel.setOpaque(false);
        return daysPanel;
    }

    protected JLabel createDayLabel(String text) {
        JLabel label = this.createCenterLabel(text);
        Font f = label.getFont();
        if (f != null) {
            label.setFont(new Font(f.getFamily(), 1, f.getSize()));
        }
        return label;
    }

    protected JPanel createHeaderPanel() {
        JPanelEx headerPanel = new JPanelEx(new FlowLayoutEx(0, 0, 0, 0));
        ((FlowLayoutEx)headerPanel.getLayout()).setFillHorizontal(true);
        JButton b = this.createIconButton(new ArrowIcon(-2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateChooser.this.m_displayMode == 3) {
                    DateChooser.this.prevYear();
                } else if (DateChooser.this.m_displayMode == 2) {
                    DateChooser.this.prevMonth();
                } else if (DateChooser.this.m_displayMode == 4) {
                    DateChooser.this.prevMonth();
                } else {
                    DateChooser.this.prevWeek();
                }
            }
        });
        headerPanel.add(b);
        b = this.createIconButton(new ArrowIcon(-1));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateChooser.this.m_displayMode == 3) {
                    DateChooser.this.prevMonth();
                } else if (DateChooser.this.m_displayMode == 2) {
                    DateChooser.this.prevWeek();
                } else if (DateChooser.this.m_displayMode == 4) {
                    DateChooser.this.prevWeek();
                } else {
                    DateChooser.this.prevDay();
                }
            }
        });
        headerPanel.add(b);
        headerPanel.add(SwingUtility.createGlue(0, 0, true, false));
        this.m_monthLabel = this.createCenterLabel(null);
        this.m_monthLabel.setFont(UIManager.getFont("Calendar.monthYear.font"));
        this.m_monthLabel.setForeground(UIManager.getColor("Calendar.monthYear.foreground"));
        this.m_monthLabel.setOpaque(false);
        headerPanel.add(this.m_monthLabel);
        headerPanel.add(SwingUtility.createGlue(0, 0, true, false));
        b = this.createIconButton(new ArrowIcon(1));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateChooser.this.m_displayMode == 3) {
                    DateChooser.this.nextMonth();
                } else if (DateChooser.this.m_displayMode == 2) {
                    DateChooser.this.nextWeek();
                } else if (DateChooser.this.m_displayMode == 4) {
                    DateChooser.this.nextWeek();
                } else {
                    DateChooser.this.nextDay();
                }
            }
        });
        headerPanel.add(b);
        b = this.createIconButton(new ArrowIcon(2));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DateChooser.this.m_displayMode == 3) {
                    DateChooser.this.nextYear();
                } else if (DateChooser.this.m_displayMode == 2) {
                    DateChooser.this.nextMonth();
                } else if (DateChooser.this.m_displayMode == 4) {
                    DateChooser.this.nextMonth();
                } else {
                    DateChooser.this.nextWeek();
                }
            }
        });
        headerPanel.add(b);
        return headerPanel;
    }

    protected JPanel createControlPanel() {
        JPanelEx controlPanel = new JPanelEx(new FlowLayoutEx(0, 2, 0, 0));
        ((FlowLayoutEx)controlPanel.getLayout()).setFillHorizontal(false);
        this.m_linkDay = new JHyperlink();
        this.m_linkDay.setText(SwingUtility.getNlsText("Day", new String[0]));
        this.m_linkDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.setDisplayMode(1);
            }
        });
        controlPanel.add(this.m_linkDay);
        this.m_linkWorkWeek = new JHyperlink();
        this.m_linkWorkWeek.setText(SwingUtility.getNlsText("WorkWeek", new String[0]));
        this.m_linkWorkWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.setDisplayMode(4);
            }
        });
        controlPanel.add(this.m_linkWorkWeek);
        this.m_linkWeek = new JHyperlink();
        this.m_linkWeek.setText(SwingUtility.getNlsText("Week", new String[0]));
        this.m_linkWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.setDisplayMode(2);
            }
        });
        controlPanel.add(this.m_linkWeek);
        this.m_linkMonth = new JHyperlink();
        this.m_linkMonth.setText(SwingUtility.getNlsText("Month", new String[0]));
        this.m_linkMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooser.this.setDisplayMode(3);
            }
        });
        controlPanel.add(this.m_linkMonth);
        return controlPanel;
    }

    protected JButton createIconButton(Icon icon) {
        JButton button = new JButton(icon);
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.setOpaque(false);
        button.setFocusPainted(false);
        button.setName("Synth.IconButton");
        return button;
    }

    protected JLabel createCenterLabel(String text) {
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(0);
        return label;
    }

    public void setModel(CalendarModel newModel) {
        this.m_model = newModel;
        this.modelChanged();
    }

    public CalendarModel getModel() {
        return this.m_model;
    }

    public void modelChanged() {
        int i = 0;
        while (i < this.m_cell.length) {
            int k = 0;
            while (k < this.m_cell[i].length) {
                this.m_cell[i][k].resetItemCache();
                ++k;
            }
            ++i;
        }
        this.m_container.revalidate();
        this.m_container.repaint();
    }

    public DateChooser getParentCalendar() {
        return this.m_parentCalendar;
    }

    public void setParentCalendar(DateChooser cal) {
        if (this.m_parentCalendar != null) {
            this.m_parentCalendar.m_childCalendar = null;
        }
        this.m_parentCalendar = cal;
        if (cal != null) {
            cal.m_childCalendar = this;
        }
        this.fireParentAndChildCalendarShift();
    }

    public DateChooser getChildCalendar() {
        return this.m_childCalendar;
    }

    public void setChildCalendar(DateChooser cal) {
        if (this.m_childCalendar != null) {
            this.m_childCalendar.m_parentCalendar = null;
        }
        this.m_childCalendar = cal;
        if (cal != null) {
            cal.m_parentCalendar = this;
        }
        this.fireParentAndChildCalendarShift();
    }

    public boolean isCalendarUpdating() {
        return this.m_calendarUpdating;
    }

    public void setSelectedItem(Object item) {
        if (item != this.m_selectedItem) {
            Object oldItem = this.m_selectedItem;
            this.m_selectedItem = item;
            CalendarModel model = this.getModel();
            if (oldItem != null) {
                this.repaintCellRange(model.getFromDate(oldItem), model.getToDate(oldItem));
            }
            if (item != null) {
                this.repaintCellRange(model.getFromDate(item), model.getToDate(item));
            }
            this.fireSelectionChanged();
        }
    }

    public Object getSelectedItem() {
        return this.m_selectedItem;
    }

    public boolean isLargeVersion() {
        return this.m_largeVersion;
    }

    public AbstractCalendarCell createCalendarCell() {
        if (this.m_largeVersion) {
            LargeCalendarCell cell = new LargeCalendarCell(this);
            return cell;
        }
        return new SmallCalendarCell(this);
    }

    public void prevDay() {
        this.shiftViewDate(5, -1);
    }

    public void prevWeek() {
        this.shiftViewDate(3, -1);
    }

    public void prevMonth() {
        this.shiftViewDate(2, -1);
    }

    public void prevYear() {
        this.shiftViewDate(1, -1);
    }

    public void nextDay() {
        this.shiftViewDate(5, 1);
    }

    public void nextWeek() {
        this.shiftViewDate(3, 1);
    }

    public void nextMonth() {
        this.shiftViewDate(2, 1);
    }

    public void nextYear() {
        this.shiftViewDate(1, 1);
    }

    public void setDate(Date d) {
        Date d2 = DateChooser.truncDate(d);
        this.setViewDate(d2);
        this.setSelectedDate(d2);
    }

    public Date getDate() {
        if (this.m_selectedDates.size() > 0) {
            return this.m_selectedDates.first();
        }
        return null;
    }

    public Date[] getSelectedDates() {
        return this.m_selectedDates.toArray(new Date[0]);
    }

    public int getTimelessSectionHeightHint() {
        return this.m_timelessHeight;
    }

    public void updateTimelessSectionHeightHint() {
        if (this.getDisplayMode() != 3) {
            int timelessMaxCount = 0;
            if (this.m_cell.length > 0) {
                AbstractCalendarCell[] abstractCalendarCellArray = this.m_cell[0];
                int n = abstractCalendarCellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCalendarCell cell = abstractCalendarCellArray[n2];
                    if (cell != null) {
                        timelessMaxCount = Math.max(timelessMaxCount, cell.getTimelessItemCount());
                    }
                    ++n2;
                }
            }
            this.m_timelessHeight = Math.min(33 * this.m_cellsPanel.getHeight() / 100, 24 * timelessMaxCount);
        }
    }

    public AbstractCalendarCell getCalendarCellFor(MouseEvent e) {
        Component c = SwingUtilities.getDeepestComponentAt((Component)e.getSource(), e.getX(), e.getY());
        if (c instanceof AbstractCalendarCell) {
            return (AbstractCalendarCell)c;
        }
        c = SwingUtilities.getAncestorOfClass(AbstractCalendarCell.class, c);
        return (AbstractCalendarCell)c;
    }

    public Object getCalendarItemFor(MouseEvent e) {
        AbstractCalendarCell cell = this.getCalendarCellFor(e);
        if (cell != null) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), cell);
            return cell.getItemAt(p);
        }
        return null;
    }

    public void setDisplayMode(int newMode) {
        if (newMode != 3 && newMode != 2 && newMode != 4 && newMode != 1) {
            throw new IllegalArgumentException("illegal display mode: " + newMode);
        }
        int oldMode = this.m_displayMode;
        if (oldMode == newMode) {
            return;
        }
        this.m_displayMode = newMode;
        Date base = this.getDate();
        if (base != null) {
            this.m_viewDate = base;
        }
        this.updateControlPanelState();
        this.reconfigureLayout();
        this.fireSetupChanged();
    }

    protected void updateControlPanelState() {
        this.m_linkDay.setEnabled(this.m_displayMode != 1);
        this.m_linkWorkWeek.setEnabled(this.m_displayMode != 4);
        this.m_linkWeek.setEnabled(this.m_displayMode != 2);
        this.m_linkMonth.setEnabled(this.m_displayMode != 3);
        this.m_linkDay.setBold(!this.m_linkDay.isEnabled());
        this.m_linkWorkWeek.setBold(!this.m_linkWorkWeek.isEnabled());
        this.m_linkWeek.setBold(!this.m_linkWeek.isEnabled());
        this.m_linkMonth.setBold(!this.m_linkMonth.isEnabled());
    }

    public int getDisplayMode() {
        return this.m_displayMode;
    }

    public void setWorkDayCount(int n) {
        if (n < 0 || n > 7) {
            return;
        }
        this.m_workDayCount = n;
        this.updateStates();
        this.m_container.repaint();
    }

    public int getWorkDayCount() {
        return this.m_workDayCount;
    }

    public void addChangeListener(ChangeListener listener) {
        this.m_listenerList.add(ChangeListener.class, (EventListener)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.m_listenerList.remove(ChangeListener.class, (EventListener)listener);
    }

    public void doChanged() {
        this.fireChangedEvent();
    }

    private void fireChangedEvent() {
        EventListener[] a = this.m_listenerList.getListeners(ChangeListener.class);
        if (a != null && a.length > 0) {
            ChangeEvent e = new ChangeEvent(this);
            int i = 0;
            while (i < a.length) {
                ((ChangeListener)a[i]).stateChanged(e);
                ++i;
            }
        }
    }

    public void addCalendarViewListener(CalendarViewListener listener) {
        this.m_listenerList.add(CalendarViewListener.class, (EventListener)listener);
    }

    public void removeCalendarViewListener(CalendarViewListener listener) {
        this.m_listenerList.remove(CalendarViewListener.class, (EventListener)listener);
    }

    protected void fireVisibleRangeChanged() {
        EventListener[] a = this.m_listenerList.getListeners(CalendarViewListener.class);
        if (a != null && a.length > 0) {
            CalendarViewEvent e = new CalendarViewEvent(this, 10);
            int i = 0;
            while (i < a.length) {
                ((CalendarViewListener)a[i]).viewChanged(e);
                ++i;
            }
        }
    }

    protected void fireSetupChanged() {
        EventListener[] a = this.m_listenerList.getListeners(CalendarViewListener.class);
        if (a != null && a.length > 0) {
            CalendarViewEvent e = new CalendarViewEvent(this, 20);
            int i = 0;
            while (i < a.length) {
                ((CalendarViewListener)a[i]).viewChanged(e);
                ++i;
            }
        }
    }

    protected void fireSelectionChanged() {
        EventListener[] a = this.m_listenerList.getListeners(CalendarViewListener.class);
        if (a != null && a.length > 0) {
            CalendarViewEvent e = new CalendarViewEvent(this, 30);
            int i = 0;
            while (i < a.length) {
                ((CalendarViewListener)a[i]).viewChanged(e);
                ++i;
            }
        }
    }

    protected void repaintCellRange(Date a, Date b) {
        if (b == null) {
            b = a;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateChooser.truncDate(a));
        while (cal.getTime().compareTo(b) <= 0) {
            AbstractCalendarCell cell = this.m_dateMap.get(cal.getTime());
            if (cell != null) {
                cell.refresh();
            }
            cal.add(5, 1);
        }
    }

    protected AbstractCalendarCell getCellOn(Date d) {
        Date d2 = DateChooser.truncDate(d);
        return this.m_dateMap.get(d2);
    }

    private void shiftViewDate(int type, int amount) {
        boolean fireNotification = true;
        this.shiftViewDate(type, amount, fireNotification);
    }

    protected void shiftViewDate(int type, int amount, boolean fireNotification) {
        Calendar c = Calendar.getInstance();
        if (this.m_viewDateStart != null && this.m_viewDateEnd != null) {
            c.setTimeInMillis((this.m_viewDateStart.getTime() + this.m_viewDateEnd.getTime()) / 2L);
        } else {
            c.setTimeInMillis(this.m_viewDate.getTime());
        }
        c.add(type, amount);
        this.setViewDate(DateChooser.truncDate(c.getTime()));
        if (fireNotification) {
            this.notifyShiftViewDateListeners(type, amount);
        }
        this.fireParentAndChildCalendarShift();
        this.updateSelections();
    }

    protected void fireParentAndChildCalendarShift() {
        try {
            this.m_calendarUpdating = true;
            if (this.getParentCalendar() != null && !this.getParentCalendar().isCalendarUpdating()) {
                Date prevMonth = new Date(this.getViewDateStart().getTime() - 1296000000L);
                this.getParentCalendar().setViewDate(prevMonth);
            }
            if (this.getChildCalendar() != null && !this.getChildCalendar().isCalendarUpdating()) {
                Date nextMonth = new Date(this.getViewDateEnd().getTime() + 1296000000L);
                this.getChildCalendar().setViewDate(nextMonth);
            }
        }
        finally {
            this.m_calendarUpdating = false;
        }
    }

    protected void notifyShiftViewDateListeners(int type, int amount) {
    }

    public boolean isMultiSelect() {
        return this.m_multiSelect;
    }

    public void setMultiSelect(boolean b) {
        this.m_multiSelect = b;
    }

    public void setSelectedDate(Date d) {
        d = DateChooser.truncDate(d);
        TreeSet<Date> newSet = new TreeSet<Date>();
        if (d != null) {
            newSet.add(d);
        }
        this.setSelectedDatesInternal(newSet);
    }

    private void setSelectedDatesInternal(TreeSet<Date> newSet) {
        if (!newSet.equals(this.m_selectedDates)) {
            this.m_selectedDates = newSet;
            this.updateSelections();
            this.fireSelectionChanged();
            try {
                this.m_calendarUpdating = true;
                if (this.getParentCalendar() != null && !this.getParentCalendar().isCalendarUpdating()) {
                    this.getParentCalendar().setSelectedDates(newSet.toArray(new Date[newSet.size()]));
                }
                if (this.getChildCalendar() != null && !this.getChildCalendar().isCalendarUpdating()) {
                    this.getChildCalendar().setSelectedDates(newSet.toArray(new Date[newSet.size()]));
                }
            }
            finally {
                this.m_calendarUpdating = false;
            }
        }
    }

    public void toggleSelectedDate(Date d) {
        if (d == null) {
            return;
        }
        d = DateChooser.truncDate(d);
        if (this.isMultiSelect()) {
            if (this.m_selectedDates.contains(d)) {
                this.removeSelectedDate(d);
            } else {
                this.addSelectedDate(d);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addSelectedDate(Date d) {
        if (d == null) {
            return;
        }
        d = DateChooser.truncDate(d);
        if (this.isMultiSelect()) {
            TreeSet<Date> newSet = new TreeSet<Date>();
            newSet.addAll(this.m_selectedDates);
            newSet.add(d);
            this.setSelectedDatesInternal(newSet);
            try {
                this.m_calendarUpdating = true;
                if (this.getParentCalendar() != null && !this.getParentCalendar().isCalendarUpdating()) {
                    this.getParentCalendar().addSelectedDate(d);
                }
                if (this.getChildCalendar() == null || this.getChildCalendar().isCalendarUpdating()) return;
                this.getChildCalendar().addSelectedDate(d);
                return;
            }
            finally {
                this.m_calendarUpdating = false;
            }
        } else {
            this.setSelectedDate(d);
        }
    }

    public void removeSelectedDate(Date d) {
        if (d == null) {
            return;
        }
        d = DateChooser.truncDate(d);
        if (this.isMultiSelect()) {
            TreeSet<Date> newSet = new TreeSet<Date>();
            newSet.addAll(this.m_selectedDates);
            newSet.remove(d);
            this.setSelectedDatesInternal(newSet);
            try {
                this.m_calendarUpdating = true;
                if (this.getParentCalendar() != null && !this.getParentCalendar().isCalendarUpdating()) {
                    this.getParentCalendar().removeSelectedDate(d);
                }
                if (this.getChildCalendar() != null && !this.getChildCalendar().isCalendarUpdating()) {
                    this.getChildCalendar().removeSelectedDate(d);
                }
            }
            finally {
                this.m_calendarUpdating = false;
            }
        }
    }

    public void setSelectedDates(Date[] dates) {
        if (this.isMultiSelect()) {
            TreeSet<Date> newSet = new TreeSet<Date>();
            Date[] dateArray = dates;
            int n = dates.length;
            int n2 = 0;
            while (n2 < n) {
                Date d = dateArray[n2];
                if (d != null) {
                    newSet.add(DateChooser.truncDate(d));
                }
                ++n2;
            }
            this.setSelectedDatesInternal(newSet);
        } else if (dates.length > 0) {
            this.setSelectedDate(dates[0]);
        }
    }

    protected final void setViewDate(Date d) {
        Date newDate;
        if (d == null) {
            if (this.m_viewDate != null) {
                return;
            }
            d = new Date();
        }
        if ((newDate = DateChooser.truncDate(d)).compareTo(this.m_viewDateStart) < 0 || newDate.compareTo(this.m_viewDateEnd) >= 0) {
            this.m_viewDate = newDate;
            this.updateStates();
            this.updateSelections();
            this.fireVisibleRangeChanged();
        }
    }

    public Date getViewDate() {
        return this.m_viewDate;
    }

    public Date getViewDateStart() {
        return this.m_viewDateStart;
    }

    public Date getViewDateEnd() {
        return this.m_viewDateEnd;
    }

    private void reconfigureLayout() {
        this.reconfigureCells();
        this.updateStates();
        this.updateSelections();
        this.m_container.revalidate();
        this.m_container.repaint();
    }

    private void reconfigureCells() {
        this.m_daysPanel.removeAll();
        String[] wdStartingMonday = new DateFormatSymbols(Locale.getDefault()).getShortWeekdays();
        String[] wd = new String[7];
        int i = 0;
        while (i < 7) {
            wd[i] = wdStartingMonday[(this.m_firstDayOfWeek - 1 + i) % 7 + 1];
            ++i;
        }
        if (this.m_displayMode == 1) {
            this.m_daysPanel.setVisible(false);
        } else if (this.m_displayMode == 4) {
            this.m_daysPanel.setVisible(true);
            String[] stringArray = new String[]{wdStartingMonday[2], wdStartingMonday[3], wdStartingMonday[4], wdStartingMonday[5], wdStartingMonday[6]};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.m_daysPanel.add(this.createDayLabel(s));
                ++n2;
            }
        } else {
            this.m_daysPanel.setVisible(true);
            i = 0;
            while (i < 7) {
                this.m_daysPanel.add(this.createDayLabel(wd[i]));
                ++i;
            }
        }
        MouseProxyAdapter proxy = new MouseProxyAdapter();
        this.m_cellsPanel.removeAll();
        if (this.m_displayMode == 3) {
            this.m_cell = new AbstractCalendarCell[6][7];
        } else if (this.m_displayMode == 2) {
            this.m_cell = new AbstractCalendarCell[1][7];
        } else if (this.m_displayMode == 4) {
            this.m_cell = new AbstractCalendarCell[1][5];
        }
        if (this.m_displayMode == 1) {
            this.m_cell = new AbstractCalendarCell[1][1];
        }
        this.m_cellsPanel.setLayout(new GridLayout(this.m_cell.length, 1));
        Color gridColor = UIManager.getColor("Calendar.gridColor");
        if (gridColor == null) {
            gridColor = Color.lightGray;
        }
        int y = 0;
        while (y < this.m_cell.length) {
            JPanelEx rowPanel = new JPanelEx(new GridLayout(1, this.m_cell[y].length));
            if (!this.isLargeVersion()) {
                rowPanel.setBorder(new MatteBorder(new Insets(1, 0, 0, 0), gridColor));
            }
            this.m_cellsPanel.add(rowPanel);
            int x = 0;
            while (x < this.m_cell[y].length) {
                this.m_cell[y][x] = this.createCalendarCell();
                this.m_cell[y][x].setBorder(this.m_cellBorder);
                this.m_cell[y][x].addMouseListener(proxy);
                this.m_cell[y][x].setWorkingHours(this.m_startHour, this.m_endHour, this.m_useOverflowCells);
                rowPanel.add(this.m_cell[y][x]);
                ++x;
            }
            ++y;
        }
    }

    private String formatHour(int h) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2000, 1, 1, h, 0, 0);
        String s = this.m_formatHHMM.format(cal.getTime());
        if (s.charAt(1) == ':') {
            s = "0" + s;
        }
        return s;
    }

    private void updateSelections() {
        int y = 0;
        while (y < this.m_cell.length) {
            int x = 0;
            while (x < this.m_cell[y].length) {
                AbstractCalendarCell cell = this.m_cell[y][x];
                if (cell != null) {
                    Date d = cell.getRepresentedDate();
                    if (this.m_selectedDates.size() > 0 && d != null && this.m_selectedDates.contains(d)) {
                        if (!cell.isSelected()) {
                            cell.setSelected(true);
                        }
                        cell.repaint();
                    } else {
                        if (cell.isSelected()) {
                            cell.setSelected(false);
                        }
                        cell.repaint();
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void updateStates() {
        Calendar c = Calendar.getInstance();
        Date vd = this.getViewDate();
        if (vd == null) {
            vd = DateChooser.truncDate(new Date());
        }
        c.setTime(vd);
        int monthNo = c.get(2);
        int weekNo = c.get(3);
        if (this.m_displayMode == 1) {
            SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
            DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
            this.m_monthLabel.setText(String.valueOf(weekDayFmt.format(vd)) + " " + dateFmt.format(vd) + " - " + SwingUtility.getNlsText("Week", new String[0]) + " " + weekNo);
        } else if (this.m_displayMode == 2) {
            c.add(7, -((c.get(7) - this.m_firstDayOfWeek + 7) % 7));
            this.m_monthLabel.setText(String.valueOf(new SimpleDateFormat("MMMMM yyyy", Locale.getDefault()).format(vd)) + " - " + SwingUtility.getNlsText("Week", new String[0]) + " " + weekNo);
        } else if (this.m_displayMode == 4) {
            c.add(7, -((c.get(7) - 2 + 7) % 7));
            this.m_monthLabel.setText(String.valueOf(new SimpleDateFormat("MMMMM yyyy", Locale.getDefault()).format(vd)) + " - " + SwingUtility.getNlsText("Week", new String[0]) + " " + weekNo);
        } else if (this.m_displayMode == 3) {
            c.add(5, -(c.get(5) - 1));
            c.add(7, -((c.get(7) - this.m_firstDayOfWeek + 7) % 7));
            this.m_monthLabel.setText(new SimpleDateFormat("MMMMM yyyy", Locale.getDefault()).format(vd));
        }
        Date newViewDateStart = DateChooser.truncDate(c.getTime());
        c.add(5, this.m_cell.length * this.m_cell[0].length);
        c.setTime(newViewDateStart);
        this.m_dateMap.clear();
        this.m_viewDateStart = newViewDateStart;
        int y = 0;
        while (y < this.m_cell.length) {
            int x = 0;
            while (x < this.m_cell[y].length) {
                boolean isInMonth = c.get(2) == monthNo;
                AbstractCalendarCell cc = this.m_cell[y][x];
                boolean firstCol = this.m_displayMode == 3 ? c.get(7) == this.m_firstDayOfWeek : (this.m_displayMode == 2 ? c.get(7) == this.m_firstDayOfWeek : (this.m_displayMode == 4 ? c.get(7) == 2 : true));
                cc.setRepresentedState(c, isInMonth, firstCol, this.getDisplayMode());
                this.m_dateMap.put(cc.getRepresentedDate(), cc);
                c.add(5, 1);
                ++x;
            }
            ++y;
        }
        this.m_viewDateEnd = DateChooser.truncDate(c.getTime());
    }

    public static Date truncDate(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return new Date(c.getTime().getTime());
    }

    public boolean isWorkDay(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        switch (c.get(7)) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setWorkHours(int startHour, int endHour, boolean useOverflowCells) {
        this.m_startHour = startHour;
        this.m_endHour = endHour;
        this.m_useOverflowCells = useOverflowCells;
        int i = 0;
        while (i < this.m_cell.length) {
            int k = 0;
            while (k < this.m_cell[i].length) {
                this.m_cell[i][k].setWorkingHours(startHour, endHour, useOverflowCells);
                ++k;
            }
            ++i;
        }
        this.reconfigureLayout();
    }

    public void setShowDisplayModeSelectionPanel(boolean visible) {
        if (this.m_controlPanel != null) {
            this.m_controlPanel.setVisible(visible);
        }
    }

    public boolean getMarkNoonHour() {
        return this.m_markNoonHour;
    }

    public void setMarkNoonHour(boolean markNoonHour) {
        this.m_markNoonHour = markNoonHour;
    }

    public void setMarkOutOfMonthDays(boolean markOutOfMonthDays) {
        this.m_markOutOfMonthDays = markOutOfMonthDays;
    }

    public boolean getMarkOutOfMonthDays() {
        return this.m_markOutOfMonthDays;
    }

    public static Date nextDay(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(5, 1);
        Date dNew = new Date(c.getTime().getTime());
        return dNew;
    }

    public JPanel getHeaderPanel() {
        return this.m_headerPanel;
    }

    public JPanel getControlPanel() {
        return this.m_controlPanel;
    }

    public JPanel getDaysPanel() {
        return this.m_daysPanel;
    }

    public JPanel getCellsPanel() {
        return this.m_cellsPanel;
    }

    public JComponent[][] getCells() {
        return this.m_cell;
    }

    private class ArrowIcon
    implements Icon {
        private int m_steps;

        public ArrowIcon(int steps) {
            this.m_steps = steps;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            g.setColor(c.getForeground());
            if (this.m_steps == 2) {
                int i = 0;
                while (i <= 3) {
                    g.drawLine(i, i, i, 6 - i);
                    ++i;
                }
                i = 0;
                while (i <= 3) {
                    g.drawLine(i + 3, i, i + 3, 6 - i);
                    ++i;
                }
            } else if (this.m_steps == 1) {
                int i = 0;
                while (i <= 3) {
                    g.drawLine(i + 1, i, i + 1, 6 - i);
                    ++i;
                }
            } else if (this.m_steps == -1) {
                int i = 0;
                while (i <= 3) {
                    g.drawLine(5 - i, i, 5 - i, 6 - i);
                    ++i;
                }
            } else if (this.m_steps == -2) {
                int i = 0;
                while (i <= 3) {
                    g.drawLine(6 - i, i, 6 - i, 6 - i);
                    ++i;
                }
                i = 0;
                while (i <= 3) {
                    g.drawLine(3 - i, i, 3 - i, 6 - i);
                    ++i;
                }
            }
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 7;
        }
    }

    private class DateController
    extends MouseAdapter {
        private boolean m_pressedInsideThisAdapter;
        private Date m_lastClicked;

        private DateController() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.m_pressedInsideThisAdapter = true;
            AbstractCalendarCell cell = DateChooser.this.getCalendarCellFor(e);
            if (cell != null) {
                cell.requestFocus();
                if (DateChooser.this.isMultiSelect()) {
                    if (e.isShiftDown()) {
                        if (this.m_lastClicked != null) {
                            Date b;
                            Date a = cell.getRepresentedDate();
                            if (a.after(b = this.m_lastClicked)) {
                                Date tmp = a;
                                a = b;
                                b = tmp;
                            }
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(a);
                            while (a.compareTo(b) <= 0) {
                                DateChooser.this.addSelectedDate(a);
                                cal.add(5, 1);
                                a = cal.getTime();
                            }
                        }
                    } else if (e.isControlDown() || e.isMetaDown()) {
                        DateChooser.this.toggleSelectedDate(cell.getRepresentedDate());
                    } else {
                        DateChooser.this.setSelectedDate(cell.getRepresentedDate());
                    }
                } else {
                    DateChooser.this.setSelectedDate(cell.getRepresentedDate());
                }
                this.m_lastClicked = cell.getRepresentedDate();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.m_pressedInsideThisAdapter && e.getButton() == 1 && !e.isMetaDown()) {
                DateChooser.this.fireChangedEvent();
            }
            this.m_pressedInsideThisAdapter = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractCalendarCell cell;
            if (this.m_pressedInsideThisAdapter && (e.getModifiers() & 0x14) != 0 && (cell = DateChooser.this.getCalendarCellFor(e)) != null) {
                if (DateChooser.this.isMultiSelect()) {
                    DateChooser.this.addSelectedDate(cell.getRepresentedDate());
                } else {
                    DateChooser.this.setSelectedDate(cell.getRepresentedDate());
                }
            }
        }
    }

    private class EmptyCalendarModel
    implements CalendarModel {
        private EmptyCalendarModel() {
        }

        @Override
        public Collection<Object> getItemsAt(Date dateTruncatedToDay) {
            return null;
        }

        @Override
        public String getTooltip(Object item, Date d) {
            return null;
        }

        @Override
        public String getLabel(Object item, Date d) {
            return null;
        }

        @Override
        public Date getFromDate(Object item) {
            return null;
        }

        @Override
        public Date getToDate(Object item) {
            return null;
        }

        @Override
        public Color getColor(Object item) {
            return null;
        }

        @Override
        public boolean isFullDay(Object item) {
            return false;
        }

        @Override
        public boolean isDraggable(Object item) {
            return false;
        }

        @Override
        public void moveItem(Object item, Date newDate) {
        }
    }

    private class MouseProxyAdapter
    extends MouseAdapter {
        private MouseProxyAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.fireMouseEvent(this.relocateEvent(e));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.fireMouseEvent(this.relocateEvent(e));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.fireMouseEvent(this.relocateEvent(e));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.fireMouseEvent(this.relocateEvent(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.fireMouseEvent(this.relocateEvent(e));
        }

        private MouseEvent relocateEvent(MouseEvent e) {
            JPanel newSource = DateChooser.this.m_container;
            return SwingUtilities.convertMouseEvent((Component)e.getSource(), e, newSource);
        }

        private void fireMouseEvent(MouseEvent me) {
            DateChooser.this.m_container.dispatchEvent(me);
        }
    }
}

