/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.border.Border;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationMouseEvent;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;

public class JTextFieldWithDecorationIcons
extends JTextFieldEx {
    private static final long serialVersionUID = 1L;
    protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private IDecoration m_decorationIcon;
    private final Cursor m_defaultCursor;
    private final boolean m_backgroundDecoration;
    private Insets m_cachedMargin;
    private Insets m_originalMargin;

    public JTextFieldWithDecorationIcons() {
        this(false);
    }

    public JTextFieldWithDecorationIcons(boolean backgroundDecoration) {
        this.m_backgroundDecoration = backgroundDecoration;
        this.m_defaultCursor = this.getCursor();
        this.registerMouseMotionListener();
    }

    @Override
    public void paint(Graphics g) {
        this.updateTextFieldMargin();
        super.paint(g);
        this.postPaint(g);
    }

    protected void postPaint(Graphics g) {
        if (this.m_decorationIcon != null) {
            Insets borderInsets = EMPTY_INSETS;
            if (this.getBorder() != null) {
                borderInsets = this.getBorder().getBorderInsets(null);
            }
            int decoIconWidth = this.m_decorationIcon.getWidth();
            int x = this.getWidth() - decoIconWidth - borderInsets.right;
            int y = (this.getHeight() - this.m_decorationIcon.getHeight()) / 2;
            this.m_decorationIcon.paint(this, g, x, y);
        }
    }

    public void setDecorationIcon(IDecoration decorationIcon) {
        this.m_decorationIcon = decorationIcon;
        this.repaint();
    }

    public IDecoration getDecorationIcon() {
        return this.m_decorationIcon;
    }

    public boolean isBackgroundDecoration() {
        return this.m_backgroundDecoration;
    }

    private void registerMouseMotionListener() {
        this.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mouseExited(MouseEvent e) {
                JTextFieldWithDecorationIcons.this.handleDecorationMouseExit(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix != null && this.fix.mouseClicked()) {
                    return;
                }
                if (JTextFieldWithDecorationIcons.this.getRegion(e.getPoint()) == Region.Decoration) {
                    JTextFieldWithDecorationIcons.this.getDecorationIcon().handleMouseChlicked(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTextFieldWithDecorationIcons.this.handleDecorationMouseMoved(e);
            }
        });
    }

    protected void handleDecorationMouseExit(MouseEvent e) {
        if (this.getDecorationIcon() != null) {
            DecorationMouseEvent ex = new DecorationMouseEvent(e);
            this.getDecorationIcon().handleMouseExit(ex);
            this.processChangesFromDecoration(ex);
        }
    }

    protected void handleDecorationMouseMoved(MouseEvent e) {
        if (this.getDecorationIcon() != null) {
            DecorationMouseEvent ex = new DecorationMouseEvent(e);
            this.getDecorationIcon().handleMouseMoved(ex);
            this.processChangesFromDecoration(ex);
        }
    }

    protected void processChangesFromDecoration(DecorationMouseEvent ex) {
        Cursor newCursor = ex.getCursorToApply();
        if (this.getCursor() != newCursor) {
            if (newCursor == null) {
                newCursor = this.m_defaultCursor;
            }
            this.setCursor(newCursor);
        }
        if (ex.isRepaintNeeded()) {
            this.repaint();
        }
    }

    public Region getRegion(Point position) {
        if (this.getDecorationIcon() != null) {
            int xStartDecoration = this.getWidth() - this.getDecorationIcon().getWidth();
            if (this.getBorder() != null) {
                xStartDecoration -= this.getBorder().getBorderInsets(null).right;
            }
            if (position.x >= xStartDecoration) {
                return Region.Decoration;
            }
        }
        return Region.Text;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public void setMargin(Insets m) {
        this.m_originalMargin = m;
        this.updateTextFieldMargin();
    }

    protected void updateTextFieldMargin() {
        if (!this.isBackgroundDecoration()) {
            if (this.m_originalMargin == null) {
                this.m_originalMargin = this.getMargin();
                if (this.m_originalMargin == null) {
                    this.m_originalMargin = EMPTY_INSETS;
                }
            }
            Insets borderInsets = EMPTY_INSETS;
            if (this.getBorder() != null) {
                borderInsets = this.getBorder().getBorderInsets(null);
            }
            Insets marginWithDecorationIcon = new Insets(this.m_originalMargin.top, this.m_originalMargin.left, this.m_originalMargin.bottom, borderInsets.right + this.m_originalMargin.right);
            if (this.getDecorationIcon() != null) {
                marginWithDecorationIcon.right += this.getDecorationIcon().getWidth();
            }
            if (!CompareUtility.equals((Object)marginWithDecorationIcon, (Object)this.m_cachedMargin)) {
                this.m_cachedMargin = marginWithDecorationIcon;
                super.setMargin(this.m_cachedMargin);
            }
        }
    }

    public static enum Region {
        Text,
        Decoration;

    }
}

