/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.job;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swing.ext.job.MonitorProperties;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressProvider;

public class SwingProgressHandler {
    private static SwingProgressHandler instance;
    private final EventListenerList m_listenerList = new EventListenerList();
    private boolean m_jobRunning;
    private MonitorProperties m_monitorProps;

    public static synchronized void install() {
        if (instance == null) {
            instance = new SwingProgressHandler();
        }
    }

    public static synchronized void uninstall() {
        SwingProgressHandler oldHandler = instance;
        instance = null;
        if (oldHandler != null) {
            oldHandler.dispose();
        }
    }

    public static SwingProgressHandler getInstance() {
        return instance;
    }

    protected SwingProgressHandler() {
        SwingProgressProvider p = new SwingProgressProvider();
        Job.getJobManager().setProgressProvider((ProgressProvider)p);
        p.addPropertyChangeListener("monitorProps", new PropertyChangeListener(){

            @Override
            public synchronized void propertyChange(final PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingProgressHandler.this.propertyChangeInSwing((MonitorProperties)evt.getNewValue());
                    }
                });
            }
        });
    }

    private void dispose() {
        Job.getJobManager().setProgressProvider(null);
    }

    private void propertyChangeInSwing(MonitorProperties monitorProps) {
        if (monitorProps == null) {
            this.m_jobRunning = false;
            this.m_monitorProps = MonitorProperties.NULL_INSTANCE;
        } else {
            this.m_jobRunning = true;
            this.m_monitorProps = monitorProps;
        }
        this.fireStateChanged();
    }

    public void addStateChangeListener(IStateChangeListener listener) {
        this.m_listenerList.add(IStateChangeListener.class, (EventListener)listener);
    }

    public void removeStateChangeListener(IStateChangeListener listener) {
        this.m_listenerList.remove(IStateChangeListener.class, (EventListener)listener);
    }

    private void fireStateChanged() {
        IStateChangeListener[] listeners = (IStateChangeListener[])this.m_listenerList.getListeners(IStateChangeListener.class);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        IStateChangeListener[] iStateChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IStateChangeListener listener = iStateChangeListenerArray[n2];
            listener.stateChanged(this);
            ++n2;
        }
    }

    public boolean isJobRunning() {
        return this.m_jobRunning;
    }

    public double getJobWorked() {
        return this.m_monitorProps.getWorked();
    }

    public String getJobTaskName() {
        return this.m_monitorProps.getTaskName();
    }

    public String getJobSubTaskName() {
        return this.m_monitorProps.getSubTaskName();
    }

    public String getJobFullName() {
        return StringUtility.concatenateTokens((String[])new String[]{this.getJobTaskName(), " - ", this.getJobSubTaskName()});
    }

    public static class CancelJobsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent a) {
            Job[] jobs = Job.getJobManager().find(null);
            if (jobs != null) {
                Job[] jobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job j = jobArray[n2];
                    if (!j.isSystem() && j.getState() == 4) {
                        try {
                            j.cancel();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public static interface IStateChangeListener
    extends EventListener {
        public void stateChanged(SwingProgressHandler var1);
    }
}

