/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.extension.app.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.extension.app.ISwingApplicationExtension;
import org.eclipse.scout.rt.ui.swing.extension.app.internal.ISwingApplicationExtensions;

public class SwingApplicationExtensions
implements ISwingApplicationExtensions {
    public static final String EXTENSION_POINT = "org.eclipse.scout.rt.ui.swing.appextensions";
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingApplicationExtensions.class);
    private Map<String, ISwingApplicationExtension> m_swingAppExtensionsMap = new HashMap<String, ISwingApplicationExtension>();
    private ISwingApplicationExtension m_activeSwingAppExtension;

    @Override
    public void start() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xp = registry.getExtensionPoint(EXTENSION_POINT);
        int greatestRanking = 0;
        IExtension[] iExtensionArray = xp.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    String extensionId;
                    ISwingApplicationExtension swingAppExtension = (ISwingApplicationExtension)element.createExecutableExtension("class");
                    int ranking = 0;
                    String rankingString = element.getAttribute("ranking");
                    if (rankingString != null) {
                        ranking = Integer.parseInt(rankingString);
                    }
                    if (ranking >= greatestRanking) {
                        greatestRanking = ranking;
                        this.m_activeSwingAppExtension = swingAppExtension;
                    }
                    if (this.m_swingAppExtensionsMap.containsKey(extensionId = swingAppExtension.getExtensionId())) {
                        LOG.error("Already registred a swing application extension with extensionId=" + extensionId + ". ExtensionId must be unique");
                    } else {
                        swingAppExtension.start();
                        this.m_swingAppExtensionsMap.put(extensionId, swingAppExtension);
                        LOG.debug("Added swing application extension " + swingAppExtension);
                    }
                }
                catch (CoreException e) {
                    LOG.error("failed to create swing application extension instance. element=" + element, (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.m_swingAppExtensionsMap.isEmpty()) {
            throw new IllegalStateException("no swing application extension contributed! at least one extension is required");
        }
    }

    @Override
    public ISwingEnvironment getEnvironment() {
        return this.m_activeSwingAppExtension.getEnvironment();
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_activeSwingAppExtension.getClientSession();
    }

    @Override
    public void showGUI() {
        for (ISwingApplicationExtension ext : this.m_swingAppExtensionsMap.values()) {
            ext.getEnvironment().showGUI(ext.getClientSession());
        }
    }

    @Override
    public boolean startUpSuccessful() {
        return true;
    }

    @Override
    public Throwable getStartUpError() {
        return null;
    }

    @Override
    public void stop() {
        for (ISwingApplicationExtension ext : this.m_swingAppExtensionsMap.values()) {
            ext.getClientSession().stopSession();
        }
    }
}

