/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.ISwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.ISwingScoutForm;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swing.form.fields.groupbox.ISwingScoutGroupBox;
import org.eclipse.scout.rt.ui.swing.window.ISwingScoutView;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;

public class SwingScoutForm
extends SwingScoutComposite<IForm>
implements ISwingScoutForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutForm.class);
    private ISwingScoutGroupBox m_mainBoxComposite;
    private FormListener m_scoutFormListener;
    private SwingScoutViewListener m_swingScoutViewListener;
    private final ISwingScoutView m_viewComposite;
    private WeakHashMap<FormEvent, Object> m_consumedScoutFormEvents = new WeakHashMap();

    public SwingScoutForm(ISwingEnvironment env, IForm scoutForm) {
        this(env, null, scoutForm);
    }

    public SwingScoutForm(ISwingEnvironment env, ISwingScoutView targetViewComposite, IForm scoutForm) {
        this.m_viewComposite = targetViewComposite;
    }

    @Override
    protected void initializeSwing() {
        IGroupBox rootGroupBox = this.getScoutForm().getRootGroupBox();
        JComponent parent = null;
        if (this.m_viewComposite != null) {
            parent = this.m_viewComposite.getSwingContentPane();
        }
        this.m_mainBoxComposite = (ISwingScoutGroupBox)this.getSwingEnvironment().createFormField(parent, (IFormField)rootGroupBox);
        this.m_mainBoxComposite.createField(this.getScoutForm().getRootGroupBox(), this.getSwingEnvironment());
        JComponent swingContainer = this.m_mainBoxComposite.getSwingContainer();
        this.setSwingField(swingContainer);
        if (this.m_viewComposite != null) {
            this.m_viewComposite.getSwingContentPane().removeAll();
            Component rootPanel = this.decorateFormPane(this.getSwingFormPane());
            this.m_viewComposite.getSwingContentPane().add("Center", rootPanel);
            this.attachSwingView();
        }
    }

    protected Component decorateFormPane(JComponent formPane) {
        JPanelEx wrapperPanel = new JPanelEx(new LogicalGridLayout(this.getSwingEnvironment(), 0, 0));
        wrapperPanel.setName(String.valueOf(this.getScoutForm().getClass().getSimpleName()) + ".optimalSizePanel");
        SwingScoutFormFieldGridData layoutData = new SwingScoutFormFieldGridData((IFormField)this.getScoutForm().getRootGroupBox());
        this.getSwingFormPane().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, layoutData);
        wrapperPanel.add(formPane);
        return wrapperPanel;
    }

    @Override
    protected void handleSwingShowing() {
        this.setInitialFocus();
    }

    @Override
    public JComponent getSwingFormPane() {
        return this.getSwingField();
    }

    public IForm getScoutForm() {
        return (IForm)this.getScoutObject();
    }

    @Override
    public void detachSwingView() {
        if (this.m_viewComposite != null) {
            if (this.m_swingScoutViewListener != null) {
                this.m_viewComposite.removeSwingScoutViewListener(this.m_swingScoutViewListener);
                this.m_swingScoutViewListener = null;
            }
            this.m_viewComposite.getSwingContentPane().removeAll();
        }
        this.disconnectFromScout();
    }

    private void attachSwingView() {
        if (this.m_viewComposite != null) {
            IForm scoutForm = this.getScoutForm();
            this.m_viewComposite.setTitle(scoutForm.getTitle());
            this.m_viewComposite.setMaximizeEnabled(scoutForm.isMaximizeEnabled());
            this.m_viewComposite.setMinimizeEnabled(scoutForm.isMinimizeEnabled());
            boolean closable = false;
            for (IFormField f : scoutForm.getAllFields()) {
                if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                    switch (((IButton)f).getSystemType()) {
                        case 1: 
                        case 2: {
                            closable = true;
                        }
                    }
                }
                if (closable) break;
            }
            this.m_viewComposite.setCloseEnabled(closable);
            this.m_viewComposite.setMaximized(scoutForm.isMaximized());
            this.m_viewComposite.setMinimized(scoutForm.isMinimized());
            this.m_swingScoutViewListener = new P_SwingScoutViewListener();
            this.m_viewComposite.addSwingScoutViewListener(this.m_swingScoutViewListener);
            if (this.m_viewComposite.isVisible()) {
                this.m_swingScoutViewListener.viewChanged(new SwingScoutViewEvent(this.m_viewComposite, 10));
                if (this.m_viewComposite.isActive()) {
                    this.m_swingScoutViewListener.viewChanged(new SwingScoutViewEvent(this.m_viewComposite, 20));
                }
            }
        }
    }

    @Override
    public ISwingScoutView getView() {
        return this.m_viewComposite;
    }

    @Override
    protected void attachScout() {
        IEventHistory h;
        super.attachScout();
        if (this.m_scoutFormListener == null) {
            this.m_scoutFormListener = new P_ScoutFormListener();
            this.getScoutForm().addFormListener(this.m_scoutFormListener);
        }
        if ((h = ((IForm)this.getScoutObject()).getEventHistory()) != null) {
            for (FormEvent e : h.getRecentEvents()) {
                switch (e.getType()) {
                    case 4000: 
                    case 6000: 
                    case 6010: {
                        this.handleScoutFormEventInUi(e);
                    }
                }
            }
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutFormListener != null) {
            this.getScoutForm().removeFormListener(this.m_scoutFormListener);
            this.m_scoutFormListener = null;
        }
    }

    @Override
    public void setInitialFocus() {
        IFormField modelField = null;
        IEventHistory h = ((IForm)this.getScoutObject()).getEventHistory();
        if (h != null) {
            for (FormEvent e : h.getRecentEvents()) {
                if (e.getType() != 6020) continue;
                modelField = e.getFormField();
                break;
            }
        }
        if (modelField != null) {
            this.handleRequestFocusFromScout(modelField, true);
        }
    }

    private Component findUiField(IFormField modelField) {
        if (modelField == null) {
            return null;
        }
        for (Component comp : SwingUtility.findChildComponents(this.getSwingContainer(), Component.class)) {
            ISwingScoutComposite composite = SwingScoutFieldComposite.getCompositeOnWidget(comp);
            if (composite == null || composite.getScoutObject() != modelField) continue;
            return composite.getSwingField();
        }
        return null;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("title")) {
            if (this.m_viewComposite != null) {
                this.m_viewComposite.setTitle((String)newValue);
            }
        } else if (name.equals("minimizeEnabled")) {
            if (this.m_viewComposite != null) {
                this.m_viewComposite.setMinimizeEnabled((Boolean)newValue);
            }
        } else if (name.equals("maximizeEnabled")) {
            if (this.m_viewComposite != null) {
                this.m_viewComposite.setMaximizeEnabled((Boolean)newValue);
            }
        } else if (name.equals("minimized")) {
            if (this.m_viewComposite != null) {
                this.m_viewComposite.setMinimized((Boolean)newValue);
            }
        } else if (name.equals("maximized") && this.m_viewComposite != null) {
            this.m_viewComposite.setMaximized((Boolean)newValue);
        }
    }

    protected void handleScoutFormEventInUi(FormEvent e) {
        if (this.m_consumedScoutFormEvents.containsKey(e)) {
            return;
        }
        this.m_consumedScoutFormEvents.put(e, Boolean.TRUE);
        switch (e.getType()) {
            case 4000: {
                this.handlePrintFromScout(e);
                break;
            }
            case 6000: {
                this.handleToFrontFromScout();
                break;
            }
            case 6010: {
                this.handleToBackFromScout();
                break;
            }
            case 6020: {
                this.handleRequestFocusFromScout(e.getFormField(), false);
            }
        }
    }

    protected void handleToFrontFromScout() {
        if (this.getView() == null) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this.getView().getSwingContentPane());
        if (w.isShowing()) {
            w.toFront();
        }
    }

    protected void handleToBackFromScout() {
        if (this.getView() == null) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this.getView().getSwingContentPane());
        if (w.isShowing()) {
            w.toBack();
        }
    }

    protected void handlePrintFromScout(FormEvent e) {
        WidgetPrinter wp = null;
        try {
            ISwingScoutView view = this.m_viewComposite;
            if (view == null) {
                ISwingScoutForm topForm;
                IForm tmp = this.getScoutForm();
                IForm outerForm = this.getScoutForm();
                while ((tmp = tmp.getOuterForm()) != null) {
                    outerForm = tmp;
                }
                if (outerForm != this.getScoutForm() && (topForm = this.getSwingEnvironment().getStandaloneFormComposite(outerForm)) != null) {
                    view = topForm.getView();
                }
            }
            if (view != null) {
                if (e.getFormField() != null) {
                    for (JComponent c : SwingUtility.findChildComponents(view.getSwingContentPane(), JComponent.class)) {
                        IPropertyObserver scoutModel = SwingScoutComposite.getScoutModelOnWidget(c);
                        if (scoutModel != e.getFormField()) continue;
                        wp = new WidgetPrinter(c);
                        break;
                    }
                }
                if (wp == null) {
                    Container printComponent = this.getScoutForm().getDisplayHint() == 20 ? view.getSwingContentPane() : SwingUtilities.getWindowAncestor(view.getSwingContentPane());
                    wp = new WidgetPrinter(printComponent);
                }
            }
            if (wp != null) {
                try {
                    wp.print(e.getPrintDevice(), e.getPrintParameters());
                }
                catch (Throwable ex) {
                    LOG.error(null, ex);
                }
            }
        }
        catch (Throwable throwable) {
            File outputFile = null;
            if (wp != null) {
                outputFile = wp.getOutputFile();
            }
            File outputFileFinal = outputFile;
            Runnable r = new Runnable(outputFileFinal){
                private final /* synthetic */ File val$outputFileFinal;
                {
                    this.val$outputFileFinal = file;
                }

                @Override
                public void run() {
                    ((IForm)SwingScoutForm.this.getScoutObject()).getUIFacade().fireFormPrintedFromUI(this.val$outputFileFinal);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(r, 0L);
            throw throwable;
        }
        File outputFile = null;
        if (wp != null) {
            outputFile = wp.getOutputFile();
        }
        File outputFileFinal = outputFile;
        Runnable r = new /* invalid duplicate definition of identical inner class */;
        this.getSwingEnvironment().invokeScoutLater(r, 0L);
    }

    protected void handleRequestFocusFromScout(IFormField modelField, boolean force) {
        if (modelField == null) {
            return;
        }
        final Component comp = this.findUiField(modelField);
        if (comp != null) {
            if (comp.isShowing()) {
                comp.requestFocus();
            } else if (force) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutForm.this.getSwingEnvironment().invokeSwingLater(new Runnable(){

                            @Override
                            public void run() {
                                if (comp.isShowing()) {
                                    comp.requestFocus();
                                }
                            }
                        });
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(r, 0L);
            }
        }
    }

    private class P_ScoutFormListener
    implements FormListener {
        private Object m_structureChangeRunnableLock = new Object();
        private Runnable m_structureChangeRunnable;

        private P_ScoutFormListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void formChanged(final FormEvent e) {
            switch (e.getType()) {
                case 5000: {
                    Object object = this.m_structureChangeRunnableLock;
                    synchronized (object) {
                        if (this.m_structureChangeRunnable == null) {
                            this.m_structureChangeRunnable = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Component c;
                                    Object object = P_ScoutFormListener.this.m_structureChangeRunnableLock;
                                    synchronized (object) {
                                        P_ScoutFormListener.this.m_structureChangeRunnable = null;
                                    }
                                    RootPaneContainer formRoot = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, SwingScoutForm.this.getSwingContainer()));
                                    if (formRoot instanceof JInternalFrame) {
                                        if (!((JInternalFrame)formRoot).isSelected()) {
                                            formRoot = null;
                                        }
                                    } else if (formRoot instanceof Window && !((Window)((Object)formRoot)).isActive()) {
                                        formRoot = null;
                                    }
                                    if (!(formRoot == null || (c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && SwingUtilities.isDescendingFrom(c, formRoot.getRootPane()))) {
                                        SwingScoutForm.this.getSwingContainer().transferFocus();
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(this.m_structureChangeRunnable);
                        }
                        break;
                    }
                }
                case 4000: 
                case 6000: 
                case 6010: 
                case 6020: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutForm.this.handleScoutFormEventInUi(e);
                        }
                    };
                    SwingScoutForm.this.getSwingEnvironment().invokeSwingLater(t);
                }
            }
        }
    }

    private class P_SwingScoutViewListener
    implements SwingScoutViewListener {
        private P_SwingScoutViewListener() {
        }

        @Override
        public void viewChanged(SwingScoutViewEvent e) {
            switch (e.getType()) {
                case 10: {
                    break;
                }
                case 20: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutForm.this.getScoutForm().getUIFacade().fireFormActivatedFromUI();
                        }
                    };
                    SwingScoutForm.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 30: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutForm.this.getScoutForm().getUIFacade().fireFormClosingFromUI();
                        }
                    };
                    SwingScoutForm.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                    break;
                }
                case 40: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutForm.this.getScoutForm().getUIFacade().fireFormKilledFromUI();
                        }
                    };
                    SwingScoutForm.this.getSwingEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
    }
}

