/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.groupbox;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import org.eclipse.scout.commons.StringUtility;

public class TitledGroupBorder
implements Border {
    private static final int SPACE_BEFORE = 12;
    private static final int H_GAP_BEFORE = 3;
    private static final int H_GAP_AFTER = 1;
    private static final int V_GAP = 1;
    private String m_text;
    private Insets m_minInsets;

    public TitledGroupBorder(String text, Insets minInsets) {
        this.m_text = text;
        this.m_minInsets = minInsets;
    }

    public String getText() {
        return this.m_text;
    }

    private Border getBorder() {
        return UIManager.getBorder("TitledBorder.border");
    }

    public Color getTextColor(Component c) {
        Color col = c.isEnabled() ? c.getForeground() : UIManager.getColor("textInactiveText");
        if (col == null) {
            col = UIManager.getColor("TitledBorder.titleColor");
        }
        if (col == null) {
            col = Color.darkGray;
        }
        return col;
    }

    public Font getTextFont() {
        Font f = UIManager.getFont("TitledBorder.font");
        if (f == null) {
            f = UIManager.getFont("Label.font");
        }
        if (f == null) {
            f = new Font("Dialog", 0, 12);
        }
        return f;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        Font backupFont = g.getFont();
        Color backupColor = g.getColor();
        Rectangle backupClip = g.getClipBounds();
        try {
            Font font = c.getFont() instanceof FontUIResource ? this.getTextFont() : c.getFont();
            String text = this.getText();
            if (!StringUtility.hasText((String)text)) {
                text = null;
            }
            Color color = this.getTextColor(c);
            g.setFont(font);
            FontMetrics fm = g.getFontMetrics();
            int descent = fm.getDescent();
            int ascent = fm.getAscent();
            int ascent2 = (ascent + descent) / 2;
            if (text == null) {
                if (border != null) {
                    border.paintBorder(c, g, x, y + ascent2, width, height - ascent2);
                }
            } else {
                int stringWidth = fm.stringWidth(text);
                Rectangle textRect = new Rectangle(x + 12 - 3, y, stringWidth + 3 + 1, ascent + descent + 1);
                if (border != null) {
                    g.setClip(new Rectangle(x, y, textRect.x - x, height).intersection(backupClip));
                    border.paintBorder(c, g, x, y + ascent2, width, height - ascent2);
                    g.setClip(new Rectangle(textRect.x + textRect.width, y, width - (textRect.x - textRect.width), height).intersection(backupClip));
                    border.paintBorder(c, g, x, y + ascent2, width, height - ascent2);
                    g.setClip(new Rectangle(textRect.x, textRect.y + textRect.height, textRect.width, height - textRect.height).intersection(backupClip));
                    border.paintBorder(c, g, x, y + ascent2, width, height - ascent2);
                }
                g.setColor(color);
                g.setClip(textRect.intersection(backupClip));
                g.drawString(text, textRect.x + 3, textRect.y + ascent);
            }
        }
        finally {
            g.setClip(backupClip);
            g.setFont(backupFont);
            g.setColor(backupColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int descent = 0;
        int ascent = 16;
        Border border = this.getBorder();
        Insets insets = new Insets(0, 0, 0, 0);
        if (border != null) {
            Insets i = border.getBorderInsets(c);
            insets.top = i.top;
            insets.right = i.right;
            insets.bottom = i.bottom;
            insets.left = i.left;
        }
        if (c != null && this.getText() != null && !this.getText().equals("")) {
            Font font = this.getTextFont();
            FontMetrics fm = c.getFontMetrics(font);
            if (fm != null) {
                descent = fm.getDescent();
                ascent = fm.getAscent();
            }
            insets.top = Math.max(insets.top, ascent + descent + 1);
        }
        insets.top = Math.max(insets.top, this.m_minInsets.top);
        insets.left = Math.max(insets.left, this.m_minInsets.left);
        insets.bottom = Math.max(insets.bottom, this.m_minInsets.bottom);
        insets.right = Math.max(insets.right, this.m_minInsets.right);
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

