/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.rangebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JPanel;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swing.form.fields.rangebox.ISwingScoutSequenceBox;

public class SwingScoutSequenceBox
extends SwingScoutFieldComposite<ISequenceBox>
implements ISwingScoutSequenceBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutSequenceBox.class);
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setName(String.valueOf(((ISequenceBox)this.getScoutObject()).getClass().getName()) + ".container");
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JPanelEx innerFieldsContainer = new JPanelEx();
        container.add(innerFieldsContainer);
        List scoutFields = ((ISequenceBox)this.getScoutObject()).getFields();
        int visibleCount = 0;
        for (IFormField field : scoutFields) {
            ISwingScoutFormField childSwingScoutField = this.getSwingEnvironment().createFormField(innerFieldsContainer, field);
            JStatusLabelEx childLabel = childSwingScoutField.getSwingLabel();
            if (childLabel != null) {
                childLabel.setFixedSize(0);
                if (this.removeLabelCompletely(childSwingScoutField)) {
                    childLabel.setVisible(false);
                }
                if (childSwingScoutField.getScoutObject() instanceof IFormField) {
                    IFormField childScoutField = (IFormField)childSwingScoutField.getScoutObject();
                    if (childScoutField.isVisible()) {
                        ++visibleCount;
                    }
                    if (visibleCount > 1 && !childLabel.isVisible()) {
                        childLabel.setVisible(true);
                        childLabel.setText("");
                    }
                }
            }
            SwingScoutFormFieldGridData data = new SwingScoutFormFieldGridData(field){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !((ISequenceBox)SwingScoutSequenceBox.this.getScoutObject()).isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            childSwingScoutField.getSwingContainer().putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, data);
            innerFieldsContainer.add(childSwingScoutField.getSwingContainer());
        }
        this.setSwingLabel(label);
        this.setSwingField(innerFieldsContainer);
        this.setSwingContainer(container);
        innerFieldsContainer.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), this.getGridColumnGapInPixel(), 0));
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
        this.setChildMandatoryFromScout();
    }

    protected int getGridColumnGapInPixel() {
        return this.getSwingEnvironment().getFormColumnGap();
    }

    private boolean removeLabelCompletely(ISwingScoutFormField swingScoutFormField) {
        if (swingScoutFormField == null) {
            return false;
        }
        if (!(swingScoutFormField.getScoutObject() instanceof IFormField)) {
            return false;
        }
        IFormField formField = (IFormField)swingScoutFormField.getScoutObject();
        return formField instanceof IBooleanField;
    }

    @Override
    public JPanel getSwingRangeBox() {
        return (JPanel)this.getSwingField();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.getSwingRangeBox().setEnabled(b);
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        IValueField<?> firstVisibleValueField = this.findFirstVisibleValueField((ICompositeField)this.getScoutObject());
        if (firstVisibleValueField != null) {
            inheritedMandatory = firstVisibleValueField.isMandatory();
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        IValueField<?> firstVisibleValueField = this.findFirstVisibleValueField((ICompositeField)this.getScoutObject());
        if (firstVisibleValueField != null) {
            inheritedErrorStatus = firstVisibleValueField.getErrorStatus();
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    protected IValueField<?> findFirstVisibleValueField(ICompositeField parent) {
        for (IFormField field : parent.getFields()) {
            IValueField<?> valueField;
            if (!field.isVisible()) continue;
            if (field instanceof IValueField) {
                return (IValueField)field;
            }
            if (!(field instanceof ICompositeField) || (valueField = this.findFirstVisibleValueField((ICompositeField)field)) == null) continue;
            return valueField;
        }
        return null;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutSequenceBox.this.setChildMandatoryFromScout();
                    }
                };
                SwingScoutSequenceBox.this.getSwingEnvironment().invokeSwingLater(j);
            }
        };
        for (IFormField f : ((ISequenceBox)this.getScoutObject()).getFields()) {
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            f.addPropertyChangeListener("visible", this.m_scoutMandatoryChangeListener);
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                SwingScoutSequenceBox.this.getSwingEnvironment().invokeSwingLater(j);
            }
        };
        for (IFormField f : ((ISequenceBox)this.getScoutObject()).getFields()) {
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutMandatoryChangeListener != null) {
            for (IFormField f : ((ISequenceBox)this.getScoutObject()).getFields()) {
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
                f.removePropertyChangeListener("visible", this.m_scoutMandatoryChangeListener);
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        if (this.m_scoutErrorStatusChangeListener != null) {
            for (IFormField f : ((ISequenceBox)this.getScoutObject()).getFields()) {
                f.removePropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            }
            this.m_scoutErrorStatusChangeListener = null;
        }
        super.detachScout();
    }
}

