/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.services.common.icon;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.icon.IconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;

public class SwingBundleIconProviderService
extends IconProviderService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingBundleIconProviderService.class);
    public static final String EXTENSION_POINT = "org.eclipse.scout.rt.ui.swing.scouticons";
    public static final String FOLDER_NAME = "resources/icons/internal";

    public SwingBundleIconProviderService() {
        this.setHostBundle(Activator.getDefault().getBundle());
        this.setFolderName(FOLDER_NAME);
    }

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.setHostBundle(Activator.getDefault().getBundle());
        this.setFolderName(FOLDER_NAME);
    }

    public IconSpec getIconSpec(String iconName) {
        IconSpec iconSpec = this.getContributedIconSpec(iconName);
        if (iconSpec == null) {
            iconSpec = super.getIconSpec(iconName);
        }
        return iconSpec;
    }

    private IconSpec getContributedIconSpec(String iconName) {
        int index = iconName.lastIndexOf(46);
        if (index > 0) {
            iconName = iconName.substring(0, index);
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xp = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] iExtensionArray = xp.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle bundle;
                URL url;
                IConfigurationElement element = iConfigurationElementArray[n4];
                String elementName = element.getName();
                String resourceName = null;
                if (elementName.equalsIgnoreCase(iconName)) {
                    resourceName = element.getAttribute("icon");
                } else if (iconName.startsWith(elementName)) {
                    String state = iconName.substring(elementName.length());
                    if (state.equalsIgnoreCase("_mouse_over") || state.equalsIgnoreCase("_rollover")) {
                        resourceName = element.getAttribute("icon_hover");
                        if (resourceName == null) {
                            resourceName = element.getAttribute("icon");
                        }
                    } else if (state.equalsIgnoreCase("_active") || state.equalsIgnoreCase("_pressed") || state.equalsIgnoreCase("_selected")) {
                        resourceName = element.getAttribute("icon_selected");
                        if (resourceName == null) {
                            resourceName = element.getAttribute("icon");
                        }
                    } else if (state.equalsIgnoreCase("_disabled") && (resourceName = element.getAttribute("icon_disabled")) == null) {
                        resourceName = element.getAttribute("icon");
                    }
                }
                if (resourceName != null && (url = (bundle = Platform.getBundle((String)element.getContributor().getName())).getResource(resourceName)) != null) {
                    IconSpec iconSpec = new IconSpec();
                    try {
                        byte[] content = IOUtility.getContent((InputStream)url.openStream(), (boolean)true);
                        if (content != null) {
                            iconSpec.setContent(content);
                        }
                        iconSpec.setName(iconName);
                        return iconSpec;
                    }
                    catch (Exception e) {
                        LOG.error("could not read input stream from url '" + url + "'.", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

