/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JToggleButton;
import org.eclipse.scout.rt.ui.swing.ext.JToggleButtonEx;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.HandCursorAdapater;

public class JTabEx
extends JToggleButtonEx {
    private static final long serialVersionUID = 1L;
    public static final String PROP_ACTIVE = "active";
    private boolean m_mouseOver = false;
    private boolean m_active = this.isSelected();

    public JTabEx() {
        this.setModel(new JToggleButton.ToggleButtonModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setPressed(boolean b) {
                if (b && this.isSelected()) {
                    this.fireActionPerformed(new ActionEvent(JTabEx.this, 1001, this.getActionCommand()));
                    return;
                }
                super.setPressed(b);
            }
        });
        this.installMouseAdapter();
        new HandCursorAdapater(this);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean oldActive = JTabEx.this.m_active;
                JTabEx.this.m_active = JTabEx.this.isSelected();
                JTabEx.this.firePropertyChange(JTabEx.PROP_ACTIVE, oldActive, JTabEx.this.m_active);
            }
        });
    }

    public boolean isMouseOver() {
        return this.m_mouseOver;
    }

    protected void setMouseOver(boolean mouseOver) {
        this.m_mouseOver = mouseOver;
        this.repaint();
    }

    protected void installMouseAdapter() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JTabEx.this.setMouseOver(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JTabEx.this.setMouseOver(false);
            }
        });
    }
}

