/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutToolbarAction;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;

public abstract class AbstractSwtScoutAction
extends Action {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutToolbarAction.class);
    private IAction m_scoutAction;
    private ISwtEnvironment m_swtEnvironment;
    private final OptimisticLock m_updateSwtFromScoutLock;
    private boolean m_updateUi = true;
    private boolean m_handleSelectionPending;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;

    public AbstractSwtScoutAction(IAction scoutAction, ISwtEnvironment environment) {
        this(scoutAction, environment, true);
    }

    public AbstractSwtScoutAction(IAction scoutAction, ISwtEnvironment environment, boolean attachScout) {
        super(scoutAction.getText() == null ? " " : scoutAction.getText(), AbstractSwtScoutAction.transformScoutStyle(scoutAction));
        this.m_swtEnvironment = environment;
        this.m_updateSwtFromScoutLock = new OptimisticLock();
        this.m_scoutAction = scoutAction;
        this.setId(this.getScoutObject().getActionId());
        if (attachScout) {
            this.attachScout();
        }
    }

    private static int transformScoutStyle(IAction scoutAction) {
        if (scoutAction.isToggleAction()) {
            return 2;
        }
        return 1;
    }

    protected void attachScout() {
        try {
            this.setUpdateUi(false);
            this.updateEnabledFromScout();
            this.updateIconFromScout();
            this.updateKeystrokeFromScout();
            this.updateSelectedFromScout();
            this.updateTextFromScout();
            this.updateTooltipTextFromScout();
            this.m_scoutAction.addPropertyChangeListener((PropertyChangeListener)new P_ScoutPropertyChangeListener());
        }
        finally {
            this.setUpdateUi(true);
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_swtEnvironment;
    }

    protected IAction getScoutObject() {
        return this.m_scoutAction;
    }

    protected void setUpdateUi(boolean updateUi) {
        if (updateUi != this.m_updateUi) {
            this.m_updateUi = updateUi;
            if (updateUi) {
                this.updateUi();
            }
        }
    }

    protected void updateUiIfNeeded() {
        if (this.isUpdateUi()) {
            this.updateUi();
        }
    }

    protected abstract void updateUi();

    public boolean isUpdateUi() {
        return this.m_updateUi;
    }

    protected void updateEnabledFromScout() {
        this.setEnabled(this.getScoutObject().isEnabled());
        this.updateUiIfNeeded();
    }

    protected void updateIconFromScout() {
        this.setImageDescriptor(this.getEnvironment().getImageDescriptor(this.getScoutObject().getIconId()));
        this.updateUiIfNeeded();
    }

    protected void updateKeystrokeFromScout() {
        String keyStroke = this.getScoutObject().getKeyStroke();
        if (keyStroke != null) {
            int keyCode = SwtUtility.getSwtKeyCode((IKeyStroke)new KeyStroke(keyStroke));
            int stateMask = SwtUtility.getSwtStateMask((IKeyStroke)new KeyStroke(keyStroke));
            this.setAccelerator(stateMask | keyCode);
        } else {
            this.setAccelerator(0);
        }
        this.updateUiIfNeeded();
    }

    protected void updateTextFromScout() {
        this.setText(this.getScoutObject().getText());
        this.updateUiIfNeeded();
    }

    protected void updateTooltipTextFromScout() {
        this.setToolTipText(this.getScoutObject().getTooltipText());
        this.updateUiIfNeeded();
    }

    protected void updateSelectedFromScout() {
        this.setChecked(this.getScoutObject().isSelected());
        this.updateUiIfNeeded();
    }

    protected void updateVisibleFromScout() {
        LOG.warn("set visible on SWT action is not supported");
    }

    public void run() {
        this.handleSwtAction();
    }

    protected void handleSwtAction() {
        try {
            if (this.getUpdateSwtFromScoutLock().acquire()) {
                if (this.getScoutObject().isToggleAction() && this.getScoutObject() instanceof IViewButton && this.getScoutObject().isSelected()) {
                    this.updateSelectedFromScout();
                } else if (SwtUtility.runSwtInputVerifier() && !this.m_handleSelectionPending) {
                    this.m_handleSelectionPending = true;
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractSwtScoutAction.this.getScoutObject().getUIFacade().fireActionFromUI();
                            }
                            finally {
                                AbstractSwtScoutAction.this.m_handleSelectionPending = false;
                            }
                        }
                    };
                    this.getEnvironment().invokeScoutLater(t, 0L);
                }
            }
        }
        finally {
            this.getUpdateSwtFromScoutLock().release();
        }
    }

    public OptimisticLock getUpdateSwtFromScoutLock() {
        return this.m_updateSwtFromScoutLock;
    }

    protected void handleScoutPropertyChange(String propertyName, Object newValue) {
        if ("enabled".equals(propertyName)) {
            this.updateEnabledFromScout();
        } else if ("iconId".equals(propertyName)) {
            this.updateIconFromScout();
        } else if ("keystroke".equals(propertyName)) {
            this.updateKeystrokeFromScout();
        } else if ("selected".equals(propertyName)) {
            this.updateSelectedFromScout();
        } else if ("text".equals(propertyName)) {
            this.updateTextFromScout();
        } else if ("tooltipText".equals(propertyName)) {
            this.updateTooltipTextFromScout();
        } else if ("visible".equals(propertyName)) {
            this.updateVisibleFromScout();
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractSwtScoutAction.this.getUpdateSwtFromScoutLock().acquire();
                        AbstractSwtScoutAction.this.handleScoutPropertyChange(evt.getPropertyName(), evt.getNewValue());
                    }
                    finally {
                        AbstractSwtScoutAction.this.getUpdateSwtFromScoutLock().release();
                    }
                }
            };
            AbstractSwtScoutAction.this.getEnvironment().invokeSwtLater(t);
        }
    }
}

