/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.action.menu.ISwtContextMenuMarker;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;

public class SwtContextMenuMarker
implements ISwtContextMenuMarker {
    private final Image m_dropDownIcon;
    private final Control m_owner;
    private boolean m_visible;
    private Rectangle m_dropDownBounds = null;
    private Point m_mouseDownPosition = null;
    private List<SelectionListener> m_selectionListeners;
    private int m_position;

    public SwtContextMenuMarker(Control owner, int position) {
        this.m_owner = owner;
        this.m_position = position;
        this.m_selectionListeners = new ArrayList<SelectionListener>();
        this.m_dropDownIcon = Activator.getIcon("dropdownfield_arrowdown_disabled");
        owner.addPaintListener((PaintListener)new P_ContextMenuPaintListener());
        owner.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && SwtContextMenuMarker.this.isPositionInDropDownBounds(e.x, e.y)) {
                    SwtContextMenuMarker.this.m_mouseDownPosition = new Point(e.x, e.y);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && SwtContextMenuMarker.this.m_mouseDownPosition != null && SwtContextMenuMarker.this.isPositionInDropDownBounds(e.x, e.y)) {
                    SwtContextMenuMarker.this.handleMarkerSelected(e);
                }
                SwtContextMenuMarker.this.m_mouseDownPosition = null;
            }
        });
        owner.addMouseMoveListener(new MouseMoveListener(){
            private Cursor m_backupCursor = null;
            private Cursor m_arrowCursor;
            {
                this.m_arrowCursor = SwtContextMenuMarker.this.getOwner().getDisplay().getSystemCursor(0);
            }

            public void mouseMove(MouseEvent e) {
                if (SwtContextMenuMarker.this.isPositionInDropDownBounds(e.x, e.y)) {
                    if (this.m_backupCursor == null) {
                        this.m_backupCursor = SwtContextMenuMarker.this.getOwner().getCursor();
                        SwtContextMenuMarker.this.getOwner().setCursor(this.m_arrowCursor);
                    }
                } else if (this.m_backupCursor != null) {
                    SwtContextMenuMarker.this.getOwner().setCursor(this.m_backupCursor);
                    this.m_backupCursor = null;
                }
            }
        });
    }

    private boolean isPositionInDropDownBounds(int x, int y) {
        return this.m_dropDownBounds != null && x > this.m_dropDownBounds.x - 3 && y > this.m_dropDownBounds.y - 3 && x < this.m_dropDownBounds.x + this.m_dropDownBounds.width + 3 && y < this.m_dropDownBounds.y + this.m_dropDownBounds.height + 6;
    }

    public Control getOwner() {
        return this.m_owner;
    }

    public int getPosition() {
        return this.m_position;
    }

    @Override
    public void setMarkerVisible(boolean visible) {
        this.m_visible = visible;
        this.m_owner.redraw();
    }

    @Override
    public boolean isMarkerVisible() {
        return this.m_visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            this.m_selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            return this.m_selectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMarkerSelected(MouseEvent e) {
        ArrayList listeners = null;
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            listeners = CollectionUtility.arrayList(this.m_selectionListeners);
        }
        Event event = new Event();
        event.button = e.button;
        event.count = e.count;
        event.data = e.data;
        event.doit = true;
        event.display = e.display;
        event.stateMask = e.stateMask;
        event.time = e.time;
        event.widget = e.widget;
        event.x = e.x;
        event.y = e.y;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener l : listeners) {
            l.widgetSelected(selectionEvent);
            if (!selectionEvent.doit) break;
        }
    }

    public static int getMarkerAlignment(int scoutObjectAlignment) {
        if (scoutObjectAlignment > 0) {
            return 16384;
        }
        return 131072;
    }

    private class P_ContextMenuPaintListener
    implements PaintListener {
        private P_ContextMenuPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Rectangle clipping = e.gc.getClipping();
            if (SwtContextMenuMarker.this.m_dropDownBounds != null && SwtContextMenuMarker.this.m_dropDownBounds.intersects(clipping)) {
                SwtContextMenuMarker.this.m_dropDownBounds = null;
                SwtContextMenuMarker.this.getOwner().redraw();
                return;
            }
            if (SwtContextMenuMarker.this.getPosition() == 16384) {
                this.paintTopLeft(e);
            } else {
                this.paintTopRight(e);
            }
        }

        private void paintTopLeft(PaintEvent e) {
            if (SwtContextMenuMarker.this.isMarkerVisible()) {
                Point iconSize = new Point(((SwtContextMenuMarker)SwtContextMenuMarker.this).m_dropDownIcon.getImageData().width, ((SwtContextMenuMarker)SwtContextMenuMarker.this).m_dropDownIcon.getImageData().height);
                Rectangle clientArea = SwtContextMenuMarker.this.getOwner().getBounds();
                if (SwtContextMenuMarker.this.getOwner() instanceof Scrollable) {
                    clientArea = ((Scrollable)SwtContextMenuMarker.this.getOwner()).getClientArea();
                }
                Rectangle iconBounds = new Rectangle(clientArea.x, clientArea.y, iconSize.x, iconSize.y);
                Rectangle clipping = e.gc.getClipping();
                if (clipping.equals((Object)iconBounds)) {
                    e.gc.drawImage(SwtContextMenuMarker.this.m_dropDownIcon, iconBounds.x, iconBounds.y);
                    SwtContextMenuMarker.this.m_dropDownBounds = iconBounds;
                } else {
                    SwtContextMenuMarker.this.getOwner().redraw(iconBounds.x, iconBounds.y, iconBounds.width, iconBounds.height, false);
                }
            }
        }

        private void paintTopRight(PaintEvent e) {
            if (SwtContextMenuMarker.this.isMarkerVisible()) {
                Point iconSize = new Point(((SwtContextMenuMarker)SwtContextMenuMarker.this).m_dropDownIcon.getImageData().width, ((SwtContextMenuMarker)SwtContextMenuMarker.this).m_dropDownIcon.getImageData().height);
                Rectangle clientArea = SwtContextMenuMarker.this.getOwner().getBounds();
                if (SwtContextMenuMarker.this.getOwner() instanceof Scrollable) {
                    clientArea = ((Scrollable)SwtContextMenuMarker.this.getOwner()).getClientArea();
                }
                Rectangle iconBounds = new Rectangle(clientArea.x + clientArea.width - iconSize.x, clientArea.y, iconSize.x, iconSize.y);
                Rectangle clipping = e.gc.getClipping();
                if (clipping.equals((Object)iconBounds)) {
                    e.gc.drawImage(SwtContextMenuMarker.this.m_dropDownIcon, iconBounds.x, iconBounds.y);
                    SwtContextMenuMarker.this.m_dropDownBounds = iconBounds;
                } else {
                    SwtContextMenuMarker.this.getOwner().redraw(iconBounds.x, iconBounds.y, iconBounds.width, iconBounds.height, false);
                }
            }
        }
    }
}

