/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.comp;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class HyperlinkEx
extends Hyperlink {
    private static final int PAINT_FLAGS = 15;
    private static final String ELLIPSIS_TEXT = "...";
    private int align = 16384;
    private static final int INDENT = 3;

    public HyperlinkEx(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
    }

    protected void paintText(GC gc, Rectangle r) {
        Rectangle clientRect = this.getClientArea();
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            try {
                FormUtil.paintWrapText((GC)gc, (String)this.getText(), (Rectangle)r, (boolean)this.isUnderlined());
            }
            catch (Throwable throwable) {}
        } else {
            int ext;
            Point textSize = this.computeTextSize(-1, -1);
            boolean mustShortenText = false;
            if (r.width < textSize.x) {
                mustShortenText = true;
            }
            int textW = Math.min(r.width, textSize.x);
            int textH = textSize.y;
            String text = this.getText();
            if (mustShortenText) {
                text = this.shortenText(gc, this.getText(), r.width);
                if (this.getToolTipText() == null) {
                    super.setToolTipText(this.getText());
                }
            } else {
                super.setToolTipText(this.getToolTipText());
            }
            int posX = clientRect.x + 3;
            if (this.align == 0x1000000) {
                posX = (clientRect.width - textW) / 2;
            }
            if (this.align == 131072) {
                posX = clientRect.width - 3 - textW;
            }
            int extX = posX;
            if (this.align == 0x1000000) {
                ext = gc.textExtent((String)text, (int)15).x;
                extX = posX + Math.max(0, (r.x - ext) / 2);
            }
            if (this.align == 131072) {
                ext = gc.textExtent((String)text, (int)15).x;
                extX = Math.max(posX, clientRect.x + clientRect.width - 3 - ext);
            }
            gc.drawText(text, extX, r.y, true);
            if (this.isUnderlined()) {
                int fontDescent = gc.getFontMetrics().getDescent();
                int extY = r.y + textH - fontDescent + 1;
                gc.drawLine(extX, extY, extX + textW, extY);
            }
        }
    }

    protected String shortenText(GC gc, String text, int linkWidth) {
        if (text == null) {
            return null;
        }
        String s = text;
        String suffix = "";
        int textWidth = gc.textExtent((String)ELLIPSIS_TEXT, (int)15).x;
        int suffixWidth = gc.textExtent((String)suffix, (int)15).x;
        int sLen = s.length();
        while (sLen >= 0) {
            String sSub = text.substring(0, sLen);
            int pos = gc.textExtent((String)sSub, (int)15).x;
            if (pos + textWidth + suffixWidth < linkWidth) {
                text = String.valueOf(sSub) + ELLIPSIS_TEXT + suffix;
                break;
            }
            --sLen;
        }
        return text;
    }

    public int getStyle() {
        int style = super.getStyle();
        switch (this.align) {
            case 131072: {
                style |= 0x20000;
                break;
            }
            case 0x1000000: {
                style |= 0x1000000;
                break;
            }
            case 16384: {
                style |= 0x4000;
            }
        }
        return style;
    }

    public int getAlignment() {
        return this.align;
    }
}

