/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class TableColumnManager {
    private List<IColumn<?>> m_initialColumns;
    private List<IColumn<?>> m_currentOrder;

    public void initialize(List<IColumn<?>> initialColumns) {
        this.m_initialColumns = initialColumns;
        this.m_currentOrder = this.m_initialColumns;
    }

    public List<IColumn<?>> getOrderedColumns(int[] columnOrder) {
        ArrayList result = new ArrayList(columnOrder.length);
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            result.add(this.m_initialColumns.get(index));
            ++n2;
        }
        return result;
    }

    public boolean applyNewOrder(List<IColumn<?>> newOrder) {
        if (CollectionUtility.equalsCollection(newOrder, this.m_currentOrder)) {
            return false;
        }
        this.m_currentOrder = newOrder;
        return true;
    }

    public IColumn<?> getColumnByModelIndex(int modelIndex) {
        return (IColumn)CollectionUtility.getElement(this.m_initialColumns, (int)modelIndex);
    }

    public IColumn<?> getColumnByVisualIndex(int visualIndex) {
        return (IColumn)CollectionUtility.getElement(this.m_currentOrder, (int)(visualIndex - 1));
    }

    public boolean isIconColumn(int columnIndex) {
        return false;
    }
}

