/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.ISwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.FormFieldPopupEvent;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.IFormFieldPopupEventListener;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.SwtScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTableCellEditor {
    private static final String DUMMY_VALUE = "Dummy";
    private final ISwtScoutTable m_tableComposite;
    private final Listener m_rowHeightListener;
    private P_FocusLostListener m_focusLostListener = new P_FocusLostListener();

    public SwtScoutTableCellEditor(ISwtScoutTable tableComposite) {
        this.m_tableComposite = tableComposite;
        this.m_rowHeightListener = new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight());
            }
        };
    }

    public void initialize() {
        TableViewer viewer = this.m_tableComposite.getSwtTableViewer();
        String[] columnPropertyNames = new String[viewer.getTable().getColumnCount()];
        CellEditor[] oldEditors = viewer.getCellEditors();
        CellEditor[] newEditors = new CellEditor[columnPropertyNames.length];
        boolean hasEditors = false;
        int i = 0;
        while (i < columnPropertyNames.length) {
            TableColumn swtCol = viewer.getTable().getColumn(i);
            IColumn scoutCol = (IColumn)swtCol.getData("scoutColumn");
            if (scoutCol != null) {
                columnPropertyNames[i] = "" + scoutCol.getColumnIndex();
                if (scoutCol.isEditable()) {
                    hasEditors = true;
                    newEditors[i] = new P_SwtCellEditor((Composite)viewer.getTable());
                }
            } else {
                columnPropertyNames[i] = "";
            }
            ++i;
        }
        viewer.setCellModifier((ICellModifier)new P_SwtCellModifier());
        viewer.setColumnProperties(columnPropertyNames);
        viewer.setCellEditors(newEditors);
        if (oldEditors != null && oldEditors.length > 0) {
            CellEditor[] cellEditorArray = oldEditors;
            int n = oldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null) {
                    editor.dispose();
                }
                ++n2;
            }
        }
        if (hasEditors) {
            viewer.getTable().addListener(41, this.m_rowHeightListener);
        } else {
            viewer.getTable().removeListener(41, this.m_rowHeightListener);
        }
    }

    protected Control getEditorControl(Composite parent, ITableRow scoutRow, IColumn<?> scoutCol) {
        Composite swtEditorControl = null;
        ISwtScoutComposite<? extends IFormField> editorComposite = this.createEditorComposite(parent, scoutRow, scoutCol);
        if (editorComposite != null) {
            this.decorateEditorComposite(editorComposite, scoutRow, scoutCol);
            swtEditorControl = editorComposite.getSwtContainer();
        }
        return swtEditorControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISwtScoutComposite<? extends IFormField> createEditorComposite(Composite parent, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        IFormField formField;
        final AtomicReference fieldRef = new AtomicReference();
        if (scoutRow != null && scoutCol != null) {
            Runnable t = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    fieldRef.set(((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutCol));
                    AtomicReference atomicReference = fieldRef;
                    synchronized (atomicReference) {
                        fieldRef.notifyAll();
                    }
                }
            };
            AtomicReference atomicReference = fieldRef;
            synchronized (atomicReference) {
                this.m_tableComposite.getEnvironment().invokeScoutLater(t, 2345L);
                try {
                    fieldRef.wait(2345L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if ((formField = (IFormField)fieldRef.get()) == null) {
            return null;
        }
        ISwtScoutComposite<Object> swtScoutFormField = formField instanceof IStringField && ((IStringField)formField).isMultilineText() ? this.createEditorCompositesPopup(parent, formField, scoutRow, scoutCol) : this.m_tableComposite.getEnvironment().createFormField(parent, formField);
        if (swtScoutFormField instanceof IPopupSupport) {
            ((IPopupSupport)((Object)swtScoutFormField)).addPopupEventListener(new IPopupSupport.IPopupSupportListener(){

                @Override
                public void handleEvent(int eventType) {
                    if (eventType == 2) {
                        SwtScoutTableCellEditor.this.getFocusLostListener().suspend();
                    } else if (eventType == 4) {
                        SwtScoutTableCellEditor.this.getFocusLostListener().resume();
                    }
                }
            });
        }
        return swtScoutFormField;
    }

    protected ISwtScoutComposite<? extends IFormField> createEditorCompositesPopup(Composite parent, IFormField formField, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        this.getFocusLostListener().suspend();
        GridData gd = formField.getGridData();
        gd.h = 1;
        gd.w = 0;
        gd.weightY = 1.0;
        gd.weightX = 1.0;
        formField.setGridDataInternal(gd);
        TableColumn swtCol = this.getSwtColumn(scoutCol);
        final P_SwtCellEditor cellEditor = (P_SwtCellEditor)this.m_tableComposite.getSwtTableViewer().getCellEditors()[this.getSwtColumnIndex(swtCol)];
        int prefWidth = gd.widthInPixel;
        int minWidth = swtCol.getWidth();
        int prefHeight = gd.heightInPixel;
        int minHeight = Math.max(105, this.m_tableComposite.getSwtTableViewer().getTable().getItemHeight());
        prefHeight = Math.max(prefHeight, minHeight);
        prefWidth = Math.max(prefWidth, minWidth);
        Composite cellEditorComposite = new Composite(parent, 0);
        final SwtScoutFormFieldPopup formFieldDialog = new SwtScoutFormFieldPopup(cellEditorComposite);
        formFieldDialog.setPrefHeight(prefHeight);
        formFieldDialog.setPrefWidth(prefWidth);
        formFieldDialog.setMinHeight(minHeight);
        formFieldDialog.setMinWidth(minWidth);
        formFieldDialog.createField(parent, formField, this.m_tableComposite.getEnvironment());
        final ICellModifier defaultCellModifier = this.m_tableComposite.getSwtTableViewer().getCellModifier();
        this.m_tableComposite.getSwtTableViewer().setCellModifier((ICellModifier)new P_SwtCellModifier(this){

            @Override
            public void modify(Object element, String property, Object value) {
                formFieldDialog.touch();
                super.modify(element, property, value);
            }
        });
        final IFocusDelegate defaultFocusDelegate = cellEditor.getFocusDelegate();
        cellEditor.setFocusDelegate(new IFocusDelegate(){

            @Override
            public void doSetFocus() {
                ISwtScoutForm swtScoutForm = formFieldDialog.getInnerSwtScoutForm();
                if (swtScoutForm != null) {
                    SwtScoutTableCellEditor.this.requestFocus((Control)swtScoutForm.getSwtContainer());
                }
            }
        });
        final IFormFieldPopupEventListener popupListener = new IFormFieldPopupEventListener(){

            @Override
            public void handleEvent(FormFieldPopupEvent event) {
                if ((event.getType() & 1) > 0) {
                    cellEditor.stopCellEditing();
                } else if ((event.getType() & 2) > 0) {
                    cellEditor.cancelCellEditing();
                }
                if ((event.getType() & 0x10) > 0) {
                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, false);
                } else if ((event.getType() & 8) > 0) {
                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, true);
                }
            }
        };
        formFieldDialog.addEventListener(popupListener);
        cellEditor.addDeactivateListener(new IDeactivateListener(){

            @Override
            public void canceled(ColumnViewerEditorDeactivationEvent event) {
                this.restoreDefault();
                this.closePopup(1);
            }

            @Override
            public void saved(ColumnViewerEditorDeactivationEvent event) {
                this.restoreDefault();
                this.closePopup(2);
            }

            private void restoreDefault() {
                cellEditor.setFocusDelegate(defaultFocusDelegate);
                SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer().setCellModifier(defaultCellModifier);
                cellEditor.removeDeactivateListener(this);
            }

            private void closePopup(int popupEvent) {
                if (formFieldDialog.isClosed()) {
                    return;
                }
                formFieldDialog.removeEventListener(popupListener);
                formFieldDialog.closePopup(popupEvent);
            }
        });
        return formFieldDialog;
    }

    private TableColumn getSwtColumn(IColumn<?> scoutCol) {
        TableColumn[] tableColumnArray = this.m_tableComposite.getSwtTableViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn swtCol = tableColumnArray[n2];
            IColumn candidate = (IColumn)swtCol.getData("scoutColumn");
            if (candidate != null && CompareUtility.equals((Object)candidate.getColumnId(), (Object)scoutCol.getColumnId())) {
                return swtCol;
            }
            ++n2;
        }
        return null;
    }

    private int getSwtColumnIndex(TableColumn swtCol) {
        Table table = this.m_tableComposite.getSwtTableViewer().getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumn(i) == swtCol) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void decorateEditorComposite(ISwtScoutComposite<? extends IFormField> editorComposite, ITableRow scoutRow, IColumn<?> scoutCol) {
    }

    protected void saveEditorFromSwt() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void cancelEditorFromSwt() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void enqueueEditNextTableCell(final ITableRow row, final IColumn<?> col, final boolean forward) {
        if (row == null || col == null) {
            return;
        }
        this.m_tableComposite.getEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment() == null) {
                    return;
                }
                ITable table = (ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject();
                TableUtility.editNextTableCell((ITable)table, (ITableRow)row, (IColumn)col, (boolean)forward, (TableUtility.ITableCellEditorFilter)new TableUtility.ITableCellEditorFilter(){

                    public boolean accept(ITableRow rowx, IColumn<?> colx) {
                        return true;
                    }
                });
            }
        }, 0L);
    }

    protected IColumn<?> getScoutColumn(String property) {
        if (property != null && property.matches("[0-9]+")) {
            int colIndex = Integer.parseInt(property);
            return ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getColumn(colIndex);
        }
        return null;
    }

    protected P_FocusLostListener getFocusLostListener() {
        return this.m_focusLostListener;
    }

    private boolean requestFocus(Control control) {
        if (control == null || control.isDisposed()) {
            return false;
        }
        if (control.setFocus()) {
            return true;
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (this.requestFocus(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static interface IDeactivateListener {
        public void canceled(ColumnViewerEditorDeactivationEvent var1);

        public void saved(ColumnViewerEditorDeactivationEvent var1);
    }

    private static interface IFocusDelegate {
        public void doSetFocus();
    }

    private class P_FocusLostListener
    implements Listener {
        private final Lock m_suspendLock = new ReentrantLock();
        private AtomicInteger m_suspendCounter = new AtomicInteger();

        private P_FocusLostListener() {
        }

        public void uninstall() {
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().getDisplay().removeFilter(15, (Listener)this);
            this.m_suspendCounter.set(0);
        }

        public void install() {
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().getDisplay().addFilter(15, (Listener)this);
            this.m_suspendCounter.set(0);
        }

        public void resume() {
            this.m_suspendLock.lock();
            try {
                if (this.m_suspendCounter.decrementAndGet() < 0) {
                    this.m_suspendCounter.set(0);
                }
            }
            finally {
                this.m_suspendLock.unlock();
            }
        }

        public void suspend() {
            this.m_suspendLock.lock();
            try {
                this.m_suspendCounter.incrementAndGet();
            }
            finally {
                this.m_suspendLock.unlock();
            }
        }

        public boolean isSuspended() {
            return this.m_suspendCounter.get() > 0;
        }

        public void handleEvent(Event event) {
            if (this.isSuspended()) {
                return;
            }
            Widget w = event.widget;
            if (w == null || !(w instanceof Control) || w.isDisposed()) {
                return;
            }
            TableViewer viewer = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer();
            if (!viewer.isCellEditorActive()) {
                return;
            }
            Control candidate = (Control)w;
            Control tableControl = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer().getControl();
            if (!SwtUtility.isAncestorOf(tableControl, candidate)) {
                CellEditor[] cellEditorArray = viewer.getCellEditors();
                int n = cellEditorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CellEditor editor = cellEditorArray[n2];
                    if (editor != null && editor.isActivated() && editor instanceof P_SwtCellEditor) {
                        ((P_SwtCellEditor)editor).stopCellEditing();
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private class P_SwtCellEditor
    extends CellEditor {
        private Composite m_container;
        private Object m_value;
        private ITableRow m_editScoutRow;
        private IColumn<?> m_editScoutCol;
        private IFocusDelegate m_focusDelegate;
        private ConcurrentHashMap<IDeactivateListener, Object> m_deactivateListeners;

        protected P_SwtCellEditor(Composite parent) {
            super(parent);
            this.m_focusDelegate = new P_FocusDelegate();
            this.m_deactivateListeners = new ConcurrentHashMap();
        }

        protected Control createControl(Composite parent) {
            this.m_container = new Composite(parent, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(wHint, hHint);
                }

                public void setBounds(Rectangle rect) {
                    if (P_SwtCellEditor.this.m_editScoutCol instanceof IBooleanColumn) {
                        rect.x = Math.max(0, rect.x - 16);
                        rect.width = Math.max(0, rect.width + 16);
                    }
                    super.setBounds(rect);
                }
            };
            this.m_container.setLayout((Layout)new FillLayout());
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(27){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireCancelEditor();
                }
            });
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(13){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireApplyEditorValue();
                    P_SwtCellEditor.this.deactivate();
                }
            });
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(0x1000050){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireApplyEditorValue();
                    P_SwtCellEditor.this.deactivate();
                }
            });
            return this.m_container;
        }

        protected void doSetFocus() {
            if (this.m_focusDelegate != null) {
                this.m_focusDelegate.doSetFocus();
            }
        }

        protected Object doGetValue() {
            return this.m_value;
        }

        protected void doSetValue(Object value) {
            this.m_value = value;
        }

        public void activate(ColumnViewerEditorActivationEvent e) {
            SwtScoutTableCellEditor.this.getFocusLostListener().install();
            SwtScoutTableCellEditor.this.getFocusLostListener().suspend();
            this.m_editScoutRow = null;
            this.m_editScoutCol = null;
            if (e.getSource() instanceof ViewerCell) {
                ViewerCell cell = (ViewerCell)e.getSource();
                TableViewer viewer = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer();
                TableColumn swtCol = viewer.getTable().getColumn(cell.getColumnIndex());
                IColumn scoutCol = (IColumn)swtCol.getData("scoutColumn");
                ITableRow scoutRow = (ITableRow)cell.getElement();
                if (e.sourceEvent instanceof MouseEvent && scoutCol instanceof IBooleanColumn) {
                    return;
                }
                if (scoutRow != null && scoutCol != null) {
                    this.m_editScoutRow = scoutRow;
                    this.m_editScoutCol = scoutCol;
                    Control control = SwtScoutTableCellEditor.this.getEditorControl(this.m_container, scoutRow, scoutCol);
                }
                this.m_container.layout(true, true);
                this.m_container.setVisible(true);
            }
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent e) {
            SwtScoutTableCellEditor.this.getFocusLostListener().uninstall();
            for (IDeactivateListener listener : this.m_deactivateListeners.keySet()) {
                if (e.eventType == 2) {
                    listener.saved(e);
                    continue;
                }
                listener.canceled(e);
            }
            this.m_editScoutRow = null;
            this.m_editScoutCol = null;
            Control[] controlArray = this.m_container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            super.deactivate(e);
            if (e.eventType == 1) {
                SwtScoutTableCellEditor.this.cancelEditorFromSwt();
            }
        }

        public void stopCellEditing() {
            this.fireApplyEditorValue();
            this.deactivate();
        }

        public void cancelCellEditing() {
            this.fireCancelEditor();
            this.deactivate();
        }

        public IFocusDelegate getFocusDelegate() {
            return this.m_focusDelegate;
        }

        public void setFocusDelegate(IFocusDelegate focusDelegate) {
            this.m_focusDelegate = focusDelegate;
        }

        public void addDeactivateListener(IDeactivateListener listener) {
            this.m_deactivateListeners.put(listener, new Object());
        }

        public void removeDeactivateListener(IDeactivateListener listener) {
            this.m_deactivateListeners.remove(listener);
        }

        private class P_FocusDelegate
        implements IFocusDelegate {
            private P_FocusDelegate() {
            }

            @Override
            public void doSetFocus() {
                P_SwtCellEditor.this.m_container.traverse(16);
                Control focusControl = P_SwtCellEditor.this.m_container.getDisplay().getFocusControl();
                if (focusControl != null && SwtUtility.isAncestorOf((Control)P_SwtCellEditor.this.m_container, focusControl)) {
                    focusControl.addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            switch (e.detail) {
                                case 2: 
                                case 4: {
                                    e.doit = false;
                                    break;
                                }
                                case 16: {
                                    e.doit = false;
                                    ITableRow scoutRow = P_SwtCellEditor.this.m_editScoutRow;
                                    IColumn scoutCol = P_SwtCellEditor.this.m_editScoutCol;
                                    P_SwtCellEditor.this.fireApplyEditorValue();
                                    P_SwtCellEditor.this.deactivate();
                                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, true);
                                    break;
                                }
                                case 8: {
                                    e.doit = false;
                                    ITableRow scoutRow = P_SwtCellEditor.this.m_editScoutRow;
                                    IColumn scoutCol = P_SwtCellEditor.this.m_editScoutCol;
                                    P_SwtCellEditor.this.fireApplyEditorValue();
                                    P_SwtCellEditor.this.deactivate();
                                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, false);
                                }
                            }
                        }
                    });
                }
                SwtScoutTableCellEditor.this.getFocusLostListener().resume();
            }
        }
    }

    private class P_SwtCellModifier
    implements ICellModifier {
        private P_SwtCellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            SwtScoutTableCellEditor.this.saveEditorFromSwt();
        }

        public Object getValue(Object element, String property) {
            return SwtScoutTableCellEditor.DUMMY_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canModify(Object element, String property) {
            AtomicBoolean b;
            final ITable table = (ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject();
            final ITableRow row = (ITableRow)element;
            final IColumn<?> column = SwtScoutTableCellEditor.this.getScoutColumn(property);
            AtomicBoolean atomicBoolean = b = new AtomicBoolean();
            synchronized (atomicBoolean) {
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = b;
                        synchronized (atomicBoolean) {
                            try {
                                if (table != null && row != null && column != null) {
                                    b.set(table.isCellEditable(row, column));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            b.notifyAll();
                        }
                    }
                };
                SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().invokeScoutLater(r, 2345L);
                try {
                    b.wait(2345L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return b.get();
        }

        /* synthetic */ P_SwtCellModifier(P_SwtCellModifier p_SwtCellModifier, P_SwtCellModifier p_SwtCellModifier2) {
            this();
        }
    }
}

