/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext.table.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableRolloverSupport {
    private final Table m_table;
    private P_MouseHoverListener m_mouseHoverListener = new P_MouseHoverListener();

    public TableRolloverSupport(Table table) {
        this.m_table = table;
        this.attachUiListeners();
    }

    public Table getTable() {
        return this.m_table;
    }

    protected void attachUiListeners() {
        this.getTable().addMouseMoveListener((MouseMoveListener)this.m_mouseHoverListener);
        this.getTable().addMouseTrackListener((MouseTrackListener)this.m_mouseHoverListener);
        this.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableRolloverSupport.this.detachUiListeners();
            }
        });
    }

    protected void detachUiListeners() {
        this.getTable().removeMouseMoveListener((MouseMoveListener)this.m_mouseHoverListener);
        this.getTable().removeMouseTrackListener((MouseTrackListener)this.m_mouseHoverListener);
    }

    private class P_MouseHoverListener
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private TableItem m_mouseHoverItem;

        private P_MouseHoverListener() {
        }

        public void mouseMove(MouseEvent e) {
            Table table = TableRolloverSupport.this.getTable();
            TableItem item = table.getItem(new Point(e.x, e.y));
            if (item != this.m_mouseHoverItem && item != null) {
                Rectangle b;
                if (this.m_mouseHoverItem != null && !this.m_mouseHoverItem.isDisposed()) {
                    this.m_mouseHoverItem.setBackground(null);
                    b = this.m_mouseHoverItem.getBounds();
                    this.redraw(b, table);
                }
                this.m_mouseHoverItem = item;
                this.m_mouseHoverItem.setBackground(TableRolloverSupport.this.getTable().getDisplay().getSystemColor(19));
                b = this.m_mouseHoverItem.getBounds();
                this.redraw(b, table);
            }
        }

        public void mouseExit(MouseEvent e) {
            if (this.m_mouseHoverItem != null && !this.m_mouseHoverItem.isDisposed()) {
                this.m_mouseHoverItem.setBackground(null);
                Rectangle b = this.m_mouseHoverItem.getBounds();
                this.redraw(b, TableRolloverSupport.this.getTable());
            }
        }

        private void redraw(final Rectangle b, final Table table) {
            TableRolloverSupport.this.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (table != null && !table.isDisposed()) {
                        table.redraw(b.x, b.y, b.width, b.height, false);
                    }
                }
            });
        }
    }
}

