/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form;

import java.io.File;
import java.util.WeakHashMap;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutForm
extends SwtScoutComposite<IForm>
implements ISwtScoutForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutForm.class);
    private FormListener m_scoutFormListener;
    private WeakHashMap<FormEvent, Object> m_consumedScoutFormEvents = new WeakHashMap();

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        ISwtScoutFormField swtGroup = this.getEnvironment().createFormField(container, (IFormField)this.getScoutObject().getRootGroupBox());
        Composite swtField = swtGroup.getSwtContainer();
        this.setSwtContainer(container);
        this.setSwtField((Control)swtField);
        SwtScoutFormFieldGridData layoutData = new SwtScoutFormFieldGridData((IFormField)this.getScoutObject().getRootGroupBox());
        this.getSwtField().setLayoutData((Object)layoutData);
        container.setLayout((Layout)new LogicalGridLayout(0, 0));
        if (this.getScoutObject().getOuterForm() == null) {
            container.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(parent));
        }
    }

    @Override
    protected void attachScout() {
        IEventHistory h;
        super.attachScout();
        if (this.m_scoutFormListener == null) {
            this.m_scoutFormListener = new P_ScoutFormListener();
            this.getScoutObject().addFormListener(this.m_scoutFormListener);
        }
        if ((h = this.getScoutObject().getEventHistory()) != null) {
            for (FormEvent e : h.getRecentEvents()) {
                switch (e.getType()) {
                    case 4000: 
                    case 6000: 
                    case 6010: {
                        this.handleScoutFormEventInUi(e);
                    }
                }
            }
        }
        this.setInitialFocus();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutFormListener != null) {
            this.getScoutObject().removeFormListener(this.m_scoutFormListener);
            this.m_scoutFormListener = null;
        }
    }

    @Override
    public Composite getSwtFormPane() {
        return (Composite)this.getSwtField();
    }

    @Override
    public IForm getScoutObject() {
        return (IForm)super.getScoutObject();
    }

    @Override
    public void setInitialFocus() {
        IFormField modelField = null;
        IEventHistory h = this.getScoutObject().getEventHistory();
        if (h != null) {
            for (FormEvent e : h.getRecentEvents()) {
                if (e.getType() != 6020) continue;
                modelField = e.getFormField();
                break;
            }
        }
        if (modelField != null) {
            this.handleRequestFocusFromScout(modelField, true);
        }
    }

    private Control findUiField(IFormField modelField) {
        if (modelField == null) {
            return null;
        }
        for (Control comp : SwtUtility.findChildComponents((Widget)this.getSwtContainer(), Control.class)) {
            ISwtScoutComposite composite = SwtScoutFieldComposite.getCompositeOnWidget((Widget)comp);
            if (composite == null || composite.getScoutObject() != modelField) continue;
            return composite.getSwtField();
        }
        return null;
    }

    protected void handleScoutFormEventInUi(FormEvent e) {
        if (this.m_consumedScoutFormEvents.containsKey(e)) {
            return;
        }
        this.m_consumedScoutFormEvents.put(e, Boolean.TRUE);
        switch (e.getType()) {
            case 4000: {
                this.handlePrintFromScout(e);
                break;
            }
            case 6000: {
                Shell sh = this.getSwtFormPane().getShell();
                sh.isVisible();
                break;
            }
            case 6010: {
                Shell sh = this.getSwtFormPane().getShell();
                sh.isVisible();
                break;
            }
            case 6020: {
                this.handleRequestFocusFromScout(e.getFormField(), false);
            }
        }
    }

    protected void handlePrintFromScout(FormEvent e) {
        WidgetPrinter wp = null;
        try {
            if (this.getSwtFormPane() != null) {
                if (e.getFormField() != null) {
                    for (Control c : SwtUtility.findChildComponents((Widget)this.getSwtContainer(), Control.class)) {
                        IPropertyObserver scoutModel = (IPropertyObserver)c.getData("org.eclipse.scout.rt.object");
                        if (scoutModel != e.getFormField()) continue;
                        wp = new WidgetPrinter(c);
                        break;
                    }
                }
                if (wp == null) {
                    wp = new WidgetPrinter((Control)this.getSwtFormPane().getShell());
                }
            }
            if (wp != null) {
                try {
                    wp.print(e.getPrintDevice(), e.getPrintParameters());
                }
                catch (Throwable ex) {
                    LOG.error(null, ex);
                }
            }
        }
        catch (Throwable throwable) {
            File outputFile = null;
            if (wp != null) {
                outputFile = wp.getOutputFile();
            }
            File outputFileFinal = outputFile;
            Runnable r = new Runnable(outputFileFinal){
                private final /* synthetic */ File val$outputFileFinal;
                {
                    this.val$outputFileFinal = file;
                }

                @Override
                public void run() {
                    SwtScoutForm.this.getScoutObject().getUIFacade().fireFormPrintedFromUI(this.val$outputFileFinal);
                }
            };
            this.getEnvironment().invokeScoutLater(r, 0L);
            throw throwable;
        }
        File outputFile = null;
        if (wp != null) {
            outputFile = wp.getOutputFile();
        }
        File outputFileFinal = outputFile;
        Runnable r = new /* invalid duplicate definition of identical inner class */;
        this.getEnvironment().invokeScoutLater(r, 0L);
    }

    protected void handleRequestFocusFromScout(IFormField modelField, boolean force) {
        if (modelField == null) {
            return;
        }
        Control comp = this.findUiField(modelField);
        if (comp != null && comp.getVisible()) {
            Control[] tabList;
            Control[] controlArray = tabList = comp instanceof Composite ? ((Composite)comp).getTabList() : null;
            if (tabList != null && tabList.length > 0) {
                comp = tabList[0];
            }
            if (comp != null && comp.getVisible()) {
                if (force) {
                    comp.forceFocus();
                } else {
                    comp.setFocus();
                }
            }
        }
    }

    private class P_ScoutFormListener
    implements FormListener {
        private P_ScoutFormListener() {
        }

        public void formChanged(final FormEvent e) {
            switch (e.getType()) {
                case 5000: {
                    break;
                }
                case 4000: 
                case 6000: 
                case 6010: 
                case 6020: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            if (SwtScoutForm.this.getSwtFormPane() != null && !SwtScoutForm.this.getSwtFormPane().isDisposed()) {
                                SwtScoutForm.this.handleScoutFormEventInUi(e);
                            }
                        }
                    };
                    SwtScoutForm.this.getEnvironment().invokeSwtLater(t);
                }
            }
        }
    }
}

