/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.button;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.swt.ext.MultilineButton;
import org.eclipse.scout.rt.ui.swt.ext.MultilineRadioButton;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.button.ISwtScoutButton;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SwtScoutButton<T extends IButton>
extends SwtScoutFieldComposite<T>
implements ISwtScoutButton<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutButton.class);
    private ButtonListener m_scoutButtonListener;
    private OptimisticLock m_selectionLock = new OptimisticLock();
    private boolean m_handleActionPending;
    private SwtScoutContextMenu m_contextMenu;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment(), 0);
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutButton.this.getSwtField().setFocus();
                SwtScoutButton.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        Control swtFieldAsButton = null;
        Hyperlink swtFieldAsLink = null;
        switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
            case 2: {
                swtFieldAsButton = this.createSwtRadioButton((Composite)this.m_menuMarkerComposite, 0);
                this.m_menuMarkerComposite.setMarkerLabelTopMargin(4);
                break;
            }
            case 1: {
                Button swtButton = this.createSwtToggleButton((Composite)this.m_menuMarkerComposite, 0x1000002);
                this.m_menuMarkerComposite.setMarkerLabelTopMargin(0);
                swtFieldAsButton = swtButton;
                break;
            }
            case 3: {
                Hyperlink swtLink = this.createSwtHyperlink((Composite)this.m_menuMarkerComposite, "", 0x1000000);
                this.m_menuMarkerComposite.setMarkerLabelTopMargin(3);
                swtFieldAsLink = swtLink;
                break;
            }
            default: {
                swtFieldAsButton = this.createSwtPushButton((Composite)this.m_menuMarkerComposite, 0x1000008);
                this.m_menuMarkerComposite.setMarkerLabelTopMargin(0);
            }
        }
        this.setSwtContainer(container);
        this.setSwtLabel(null);
        LogicalGridData contextMenuMarkerData = LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData());
        if (swtFieldAsButton != null) {
            swtFieldAsButton.addListener(13, (Listener)new P_SwtSelectionListener());
            this.setSwtField(swtFieldAsButton);
            this.adaptButtonLayoutData(contextMenuMarkerData);
        } else if (swtFieldAsLink != null) {
            swtFieldAsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    SwtScoutButton.this.handleSwtAction();
                }
            });
            this.setSwtField((Control)swtFieldAsLink);
        }
        this.getSwtContainer().setTabList(new Control[]{this.m_menuMarkerComposite});
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(0, 0));
        this.m_menuMarkerComposite.setLayoutData(contextMenuMarkerData);
    }

    protected void adaptButtonLayoutData(LogicalGridData gd) {
        if (((IButton)this.getScoutObject()).isProcessButton() && !gd.useUiHeight) {
            gd.useUiHeight = true;
            IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
            gd.heightHint = deco.getProcessButtonHeight();
        }
    }

    protected Hyperlink createSwtHyperlink(Composite container, String text, int style) {
        HyperlinkEx link = this.getEnvironment().getFormToolkit().createHyperlink(container, text, style);
        link.setUnderlined(true);
        return link;
    }

    protected Control createSwtRadioButton(Composite container, int style) {
        return this.getEnvironment().getFormToolkit().createMultilineRadioButton(container);
    }

    protected Button createSwtToggleButton(Composite container, int style) {
        return this.getEnvironment().getFormToolkit().createButton(container, style);
    }

    protected Button createSwtPushButton(Composite container, int style) {
        Button swtButton = this.getEnvironment().getFormToolkit().createButton(container, style);
        return swtButton;
    }

    @Override
    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IButton)this.getScoutObject()).getContextMenu().isVisible());
        ((IButton)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IButton)SwtScoutButton.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutButton.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutButton.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IButton)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        this.getSwtField().setMenu(this.m_contextMenu.getSwtMenu());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutButtonListener == null) {
            this.m_scoutButtonListener = new P_ScoutButtonListener();
            ((IButton)this.getScoutObject()).addButtonListener(this.m_scoutButtonListener);
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutButtonListener != null) {
            ((IButton)this.getScoutObject()).removeButtonListener(this.m_scoutButtonListener);
            this.m_scoutButtonListener = null;
        }
    }

    @Override
    public Control getSwtField() {
        return super.getSwtField();
    }

    public SwtScoutContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    @Override
    protected void applyScoutProperties() {
        super.applyScoutProperties();
        IButton b = (IButton)this.getScoutObject();
        this.setIconIdFromScout(b.getIconId());
        this.setImageFromScout(b.getImage());
        this.setSelectionFromScout(b.isSelected());
        this.setLabelFromScout(b.getLabel());
    }

    protected void setIconIdFromScout(String s) {
        if (s != null) {
            Image icon = this.getEnvironment().getIcon(s);
            Control comp = this.getSwtField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage(icon);
            } else if (comp instanceof MultilineButton) {
                MultilineButton b = (MultilineButton)comp;
                b.setImage(icon);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        Control comp = this.getSwtField();
        if (comp instanceof Button) {
            Button b = (Button)comp;
            String label = s;
            b.setText(label == null ? "" : label);
        } else if (comp instanceof Hyperlink) {
            Hyperlink t = (Hyperlink)comp;
            String label = StringUtility.removeMnemonic((String)s);
            t.setText(label == null ? "" : label);
        } else if (comp instanceof MultilineRadioButton) {
            MultilineRadioButton b = (MultilineRadioButton)comp;
            b.setText(s == null ? "" : s);
        }
    }

    protected void setSelectionFromScout(boolean b) {
        block10: {
            try {
                if (!this.m_selectionLock.acquire()) break block10;
                switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
                    case 1: 
                    case 2: {
                        MultilineRadioButton but;
                        Control comp = this.getSwtField();
                        if (comp instanceof Button) {
                            Button but2 = (Button)comp;
                            if (b != but2.getSelection()) {
                                but2.setSelection(b);
                            }
                            break;
                        }
                        if (!(comp instanceof MultilineRadioButton) || b == (but = (MultilineRadioButton)comp).getSelection()) break;
                        but.setSelection(b);
                    }
                    default: {
                        break;
                    }
                }
            }
            finally {
                this.m_selectionLock.release();
            }
        }
    }

    protected void setSelectionFromSwt(final boolean b) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (((IButton)SwtScoutButton.this.getScoutObject()).isSelected() != b) {
                            ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                        }
                        ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void handleSwtAction() {
        if (SwtUtility.runSwtInputVerifier() && !this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IButton)SwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        SwtScoutButton.this.m_handleActionPending = false;
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setImageFromScout(Object img) {
        if (img instanceof Image) {
            Control comp = this.getSwtField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage((Image)img);
            } else if (comp instanceof MultilineButton) {
                MultilineButton b = (MultilineButton)comp;
                b.setImage((Image)img);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    protected void disarmButtonFromScout() {
    }

    protected void requestPopupFromScout() {
        if (this.getContextMenu() != null) {
            this.getContextMenu().getSwtMenu().setVisible(true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("image")) {
            this.setImageFromScout(newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    private class P_ScoutButtonListener
    implements ButtonListener,
    WeakEventListener {
        private P_ScoutButtonListener() {
        }

        public void buttonChanged(ButtonEvent e) {
            switch (e.getType()) {
                case 3: {
                    SwtScoutButton.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutButton.this.disarmButtonFromScout();
                        }
                    });
                    break;
                }
                case 4: {
                    SwtScoutButton.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutButton.this.requestPopupFromScout();
                        }
                    });
                }
            }
        }
    }

    private class P_SwtSelectionListener
    implements Listener {
        private P_SwtSelectionListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 13) {
                switch (((IButton)SwtScoutButton.this.getScoutObject()).getDisplayStyle()) {
                    case 1: 
                    case 2: {
                        if (SwtScoutButton.this.getSwtField() instanceof Button) {
                            SwtScoutButton.this.setSelectionFromSwt(((Button)SwtScoutButton.this.getSwtField()).getSelection());
                            break;
                        }
                        if (!(SwtScoutButton.this.getSwtField() instanceof MultilineRadioButton)) break;
                        SwtScoutButton.this.setSelectionFromSwt(((MultilineRadioButton)SwtScoutButton.this.getSwtField()).getSelection());
                        break;
                    }
                    default: {
                        SwtScoutButton.this.handleSwtAction();
                    }
                }
            }
        }
    }
}

