/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.calendar;

import java.util.Calendar;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtScoutCalendar;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.calendar.ISwtScoutCalendarField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutCalendarField
extends SwtScoutFieldComposite<ICalendarField<ICalendar>>
implements ISwtScoutCalendarField {
    protected SwtScoutCalendar m_calendar;
    protected ICalendar m_scoutCalendarModel;

    public Control getLabeledComponent() {
        return this.m_calendar;
    }

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.setSwtContainer(container);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_scoutCalendarModel = ((ICalendarField)this.getScoutObject()).getCalendar();
        this.m_calendar = new SwtScoutCalendar(container, 0, this);
        this.m_calendar.setScoutCalendarModel(this.m_scoutCalendarModel);
        LogicalGridData textData = LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData());
        this.m_calendar.setLayoutData(textData);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        final Calendar minDate = this.m_calendar.getViewDateStart();
        final Calendar maxDate = this.m_calendar.getViewDateEnd();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ((ICalendarField)SwtScoutCalendarField.this.getScoutObject()).getCalendar().getUIFacade().setVisibleRangeFromUI(minDate.getTime(), maxDate.getTime());
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(r, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_calendar.setCondensedMode(((ICalendarField)this.getScoutObject()).getCalendar().isDisplayCondensed());
        this.m_calendar.setCalendarComponentsFromScout(((ICalendarField)this.getScoutObject()).getCalendar().getComponents());
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        SwtColors.getInstance().dispose();
    }
}

