/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.StyledTextAccess;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.ISwtScoutDateField;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateChooserDialog;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.TimeChooserDialog;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutDateField
extends SwtScoutBasicFieldComposite<IDateField>
implements ISwtScoutDateField,
IPopupSupport {
    public static final int TYPE_TIME_CHOOSER = 1;
    public static final int TYPE_DATE_CHOOSER = 2;
    private Button m_dateChooserButton;
    private Button m_timeChooserButton;
    private boolean m_hasTime;
    private TextFieldEditableSupport m_editableSupport;
    private Set<IPopupSupport.IPopupSupportListener> m_popupEventListeners;
    private Object m_popupEventListenerLock;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        this.m_popupEventListeners = new HashSet<IPopupSupport.IPopupSupportListener>();
        this.m_popupEventListenerLock = new Object();
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment());
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutDateField.this.getSwtField().setFocus();
                SwtScoutDateField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText((Composite)this.m_menuMarkerComposite, 4);
        textField.setAlignment(SwtUtility.getHorizontalAlignment(((IDateField)this.getScoutObject()).getGridData().horizontalAlignment));
        textField.setWrapIndent(textField.getWrapIndent());
        textField.setMargins(2, 2, 2, 2);
        Button dateChooserButton = this.getEnvironment().getFormToolkit().createButton(container, 8);
        dateChooserButton.setImage(this.getEnvironment().getIcon("datefield_date"));
        Button timeChooserButton = this.getEnvironment().getFormToolkit().createButton(container, 8);
        timeChooserButton.setImage(this.getEnvironment().getIcon("datefield_time"));
        timeChooserButton.setVisible(((IDateField)this.getScoutObject()).isHasTime());
        container.setTabList(new Control[]{this.m_menuMarkerComposite});
        this.addModifyListenerForBasicField((Widget)textField);
        this.getEnvironment().addKeyStroke((Widget)container, new P_DateChooserOpenKeyStroke());
        this.getEnvironment().addKeyStroke((Widget)container, new P_DateTimeChooserOpenKeyStroke());
        textField.addKeyListener((KeyListener)new P_ShiftDateListener());
        dateChooserButton.addSelectionListener((SelectionListener)new P_SwtBrowseButtonListener(2));
        timeChooserButton.addSelectionListener((SelectionListener)new P_SwtBrowseButtonListener(1));
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setDateChooserButton(dateChooserButton);
        this.setTimeChooserButton(timeChooserButton);
        this.setSwtField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        dateChooserButton.setLayoutData((Object)LogicalGridDataBuilder.createButton1());
        timeChooserButton.setLayoutData((Object)LogicalGridDataBuilder.createButton2());
    }

    @Override
    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IDateField)this.getScoutObject()).getContextMenu().isVisible());
        ((IDateField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IDateField)SwtScoutDateField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutDateField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutDateField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), (IContextMenu)((IDateField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        if (this.getDateChooserButton() != null) {
            this.getDateChooserButton().setMenu(this.m_contextMenu.getSwtMenu());
        }
        if (this.getTimeChooserButton() != null) {
            this.getTimeChooserButton().setMenu(this.m_contextMenu.getSwtMenu());
        }
        SwtScoutContextMenu fieldMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), (IContextMenu)((IDateField)this.getScoutObject()).getContextMenu(), this.getEnvironment(), ((IDateField)this.getScoutObject()).isAutoAddDefaultMenus() ? new StyledTextAccess(this.getSwtField()) : null, ((IDateField)this.getScoutObject()).isAutoAddDefaultMenus() ? this.getSwtField() : null);
        this.getSwtField().setMenu(fieldMenu.getSwtMenu());
    }

    @Override
    public Button getDateChooserButton() {
        return this.m_dateChooserButton;
    }

    public void setDateChooserButton(Button dateChooserButton) {
        this.m_dateChooserButton = dateChooserButton;
    }

    @Override
    public Button getTimeChooserButton() {
        return this.m_timeChooserButton;
    }

    public void setTimeChooserButton(Button timeChooserButton) {
        this.m_timeChooserButton = timeChooserButton;
    }

    @Override
    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dateChooserButton.setEnabled(b);
        this.m_timeChooserButton.setEnabled(b);
    }

    @Override
    protected String getText() {
        return this.getSwtField().getText();
    }

    @Override
    protected void setText(String text) {
        this.getSwtField().setText(text);
    }

    @Override
    protected Point getSelection() {
        return this.getSwtField().getSelection();
    }

    @Override
    protected void setSelection(int startIndex, int endIndex) {
        this.getSwtField().setSelection(startIndex, endIndex);
    }

    @Override
    protected int getCaretOffset() {
        return this.getSwtField().getCaretOffset();
    }

    @Override
    protected void setCaretOffset(int caretPosition) {
        this.getSwtField().setCaretOffset(caretPosition);
    }

    @Override
    protected TextFieldEditableSupport createEditableSupport() {
        return new TextFieldEditableSupport(this.getSwtField());
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IDateField)this.getScoutObject()).getDisplayText()) && ((IDateField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateTimeTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.scheduleSelectAll();
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPopupEventListeners(int eventType) {
        IPopupSupport.IPopupSupportListener[] listeners;
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            listeners = this.m_popupEventListeners.toArray(new IPopupSupport.IPopupSupportListener[this.m_popupEventListeners.size()]);
        }
        IPopupSupport.IPopupSupportListener[] iPopupSupportListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupSupport.IPopupSupportListener listener = iPopupSupportListenerArray[n2];
            listener.handleEvent(eventType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.remove(listener);
        }
    }

    private void handleSwtDateChooserAction() {
        if (this.getDateChooserButton().isVisible() && this.getDateChooserButton().isEnabled()) {
            Date oldDate = (Date)((IDateField)this.getScoutObject()).getValue();
            if (oldDate == null) {
                oldDate = new Date();
            }
            this.notifyPopupEventListeners(2);
            try {
                DateChooserDialog dialog = new DateChooserDialog(this.getSwtField().getShell(), oldDate, this.getEnvironment());
                final Date newDate = dialog.openDateChooser((Control)this.getSwtField());
                if (newDate != null) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateFromUI(newDate);
                        }
                    };
                    this.getEnvironment().invokeScoutLater(t, 0L);
                }
            }
            finally {
                this.notifyPopupEventListeners(4);
                if (!this.getSwtField().isDisposed()) {
                    this.getSwtField().setFocus();
                }
            }
        }
    }

    private void handleSwtTimeChooserAction() {
        if (this.getTimeChooserButton().isVisible() && this.getTimeChooserButton().isEnabled()) {
            Date d = (Date)((IDateField)this.getScoutObject()).getValue();
            if (d == null) {
                d = new Date();
            }
            this.notifyPopupEventListeners(2);
            try {
                TimeChooserDialog dialog = new TimeChooserDialog(this.getSwtField().getShell(), d, this.getEnvironment());
                Date newDate = dialog.openDateChooser((Control)this.getSwtField());
                if (newDate != null) {
                    this.getSwtField().setText(DateFormat.getDateTimeInstance(3, 3).format(newDate));
                    this.handleSwtInputVerifier();
                }
            }
            finally {
                this.notifyPopupEventListeners(4);
                if (!this.getSwtField().isDisposed()) {
                    this.getSwtField().setFocus();
                }
            }
        }
    }

    private class P_DateChooserOpenKeyStroke
    extends SwtKeyStroke {
        public P_DateChooserOpenKeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutDateField.this.handleSwtDateChooserAction();
        }
    }

    private class P_DateTimeChooserOpenKeyStroke
    extends SwtKeyStroke {
        public P_DateTimeChooserOpenKeyStroke() {
            super(0x100000B, 131072);
        }

        @Override
        public void handleSwtAction(Event e) {
            SwtScoutDateField.this.handleSwtTimeChooserAction();
        }
    }

    private class P_ShiftDateListener
    extends KeyAdapter {
        private P_ShiftDateListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (SwtScoutDateField.this.getSwtField().isEnabled() && SwtScoutDateField.this.getSwtField().getEditable() && SwtScoutDateField.this.getSwtField().isVisible()) {
                int level = -1;
                int value = 0;
                switch (e.keyCode) {
                    case 0x1000001: {
                        if (e.stateMask == 0) {
                            level = 0;
                            value = 1;
                            break;
                        }
                        if (e.stateMask == 131072) {
                            level = 1;
                            value = 1;
                            break;
                        }
                        if (e.stateMask != 262144) break;
                        level = 2;
                        value = 1;
                        break;
                    }
                    case 0x1000002: {
                        if (e.stateMask == 0) {
                            level = 0;
                            value = -1;
                            break;
                        }
                        if (e.stateMask == 131072) {
                            level = 1;
                            value = -1;
                            break;
                        }
                        if (e.stateMask != 262144) break;
                        level = 2;
                        value = -1;
                    }
                }
                if (level >= 0) {
                    final int levelFinal = level;
                    final int valueFinal = value;
                    final String newDisplayText = SwtScoutDateField.this.getSwtField().getText();
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            if (!CompareUtility.equals((Object)newDisplayText, (Object)((IDateField)SwtScoutDateField.this.getScoutObject()).getDisplayText())) {
                                ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().setDateTimeTextFromUI(newDisplayText);
                            }
                            ((IDateField)SwtScoutDateField.this.getScoutObject()).getUIFacade().fireDateShiftActionFromUI(levelFinal, valueFinal);
                        }
                    };
                    SwtScoutDateField.this.getEnvironment().invokeScoutLater(t, 2345L);
                }
            }
        }
    }

    private class P_SwtBrowseButtonListener
    extends SelectionAdapter {
        private int m_buttonId;

        public P_SwtBrowseButtonListener(int buttonId) {
            this.m_buttonId = buttonId;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.m_buttonId == 2) {
                SwtScoutDateField.this.handleSwtDateChooserAction();
            } else if (this.m_buttonId == 1) {
                SwtScoutDateField.this.handleSwtTimeChooserAction();
            }
        }
    }
}

