/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.AbstractDateSelectionListener;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateEquality;
import org.eclipse.scout.rt.ui.swt.form.fields.datefield.chooser.DateSelectionEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TimeCell {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TimeCell.class);
    private Composite m_container = null;
    private Label m_timeLabel = null;
    private Label m_iconArea = null;
    private Date m_cellDate = null;
    private Color m_defaultBackground;
    private AbstractDateSelectionListener m_dateChangedListener = null;
    private final ISwtEnvironment m_environment;

    public TimeCell(Composite parent, AbstractDateSelectionListener listener, ISwtEnvironment environment) {
        this.m_dateChangedListener = listener;
        this.m_environment = environment;
        this.m_container = new Composite(parent, 0);
        this.m_iconArea = new Label(this.m_container, 0);
        this.m_iconArea.setBackground(this.m_iconArea.getShell().getDisplay().getSystemColor(25));
        this.m_timeLabel = new Label(this.m_container, 0x1000000);
        this.m_timeLabel.setBackground(this.getEnvironment().getDisplay().getSystemColor(25));
        P_TimeSelectionListener timeSelectionListener = new P_TimeSelectionListener();
        this.m_timeLabel.addMouseListener((MouseListener)timeSelectionListener);
        this.m_iconArea.addMouseListener((MouseListener)timeSelectionListener);
        P_MouseOverListener mouseTrackListener = new P_MouseOverListener();
        this.m_iconArea.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        this.m_timeLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
    }

    public void addListener(int type, Listener listener) {
        this.m_timeLabel.addListener(type, listener);
        this.m_iconArea.addListener(type, listener);
    }

    private void layout(int labelWith) {
        GridData containerData = new GridData();
        containerData.grabExcessVerticalSpace = true;
        containerData.grabExcessHorizontalSpace = true;
        containerData.horizontalAlignment = 4;
        containerData.verticalAlignment = 4;
        this.m_container.setLayoutData((Object)containerData);
        FormLayout containerLayout = new FormLayout();
        this.m_container.setLayout((Layout)containerLayout);
        FormData iconData = new FormData();
        iconData.left = new FormAttachment(0, 0);
        iconData.top = new FormAttachment(0, 0);
        iconData.bottom = new FormAttachment(100, 0);
        this.m_iconArea.setLayoutData((Object)iconData);
        FormData labelData = new FormData();
        labelData.width = labelWith;
        labelData.top = new FormAttachment(0, 0);
        labelData.bottom = new FormAttachment(100, 0);
        labelData.right = new FormAttachment(100, 0);
        labelData.left = new FormAttachment((Control)this.m_iconArea, 0);
        this.m_timeLabel.setLayoutData((Object)labelData);
    }

    public void setRepresentedState(Calendar c, DateEquality dateEquality) {
        this.m_cellDate = c.getTime();
        int labelWith = 30;
        this.setSelection(dateEquality);
        if (c.get(12) == 0) {
            labelWith = 50;
            this.m_iconArea.setImage(this.getEnvironment().getIcon("datefield_time"));
            this.m_timeLabel.setText(new SimpleDateFormat("HH:mm").format(this.m_cellDate));
        } else {
            this.m_timeLabel.setText(new SimpleDateFormat(":mm").format(this.m_cellDate));
        }
        this.layout(labelWith);
    }

    private void setSelection(DateEquality dateEquality) {
        if (dateEquality.equals(DateEquality.HOUR_EQUAL)) {
            this.m_timeLabel.setBackground(this.getEnvironment().getDisplay().getSystemColor(29));
        }
        if (dateEquality.equals(DateEquality.QUARTER_EQUAL)) {
            Font f = this.getEnvironment().getFont(new FontSpec(null, 1, -1), this.m_timeLabel.getFont());
            this.m_timeLabel.setFont(f);
            this.m_timeLabel.setBackground(this.m_timeLabel.getDisplay().getSystemColor(26));
            this.m_timeLabel.setForeground(this.m_timeLabel.getDisplay().getSystemColor(27));
        }
    }

    private void setStyle(boolean mouseOver) {
        if (mouseOver) {
            this.m_defaultBackground = this.m_timeLabel.getBackground();
            this.m_timeLabel.setBackground(this.m_timeLabel.getShell().getDisplay().getSystemColor(19));
        } else {
            this.m_timeLabel.setBackground(this.m_defaultBackground);
        }
    }

    public void registerTimeChangedListener(AbstractDateSelectionListener listener) {
        if (this.m_dateChangedListener != null && !this.m_dateChangedListener.equals(listener)) {
            LOG.error("already a listener registered!");
        } else {
            this.m_dateChangedListener = listener;
        }
    }

    public void removeTimeChangedListener(AbstractDateSelectionListener listener) {
        if (this.m_dateChangedListener != listener) {
            LOG.error("no authority to remove the listener!");
        } else {
            this.m_dateChangedListener = null;
        }
    }

    private void fireTimeSelected() {
        DateSelectionEvent e = new DateSelectionEvent(this.m_cellDate);
        if (this.m_dateChangedListener != null) {
            this.m_dateChangedListener.dateChanged(e);
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    private class P_MouseOverListener
    extends MouseTrackAdapter {
        private P_MouseOverListener() {
        }

        public void mouseEnter(MouseEvent e) {
            TimeCell.this.setStyle(true);
        }

        public void mouseExit(MouseEvent e) {
            TimeCell.this.setStyle(false);
        }
    }

    private class P_TimeSelectionListener
    extends MouseAdapter {
        private P_TimeSelectionListener() {
        }

        public void mouseUp(MouseEvent e) {
            TimeCell.this.fireTimeSelected();
        }
    }
}

