/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.splitbox;

import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.splitbox.ISwtScoutSplitBox;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;

public class SwtScoutSplitBox
extends SwtScoutFieldComposite<ISplitBox>
implements ISwtScoutSplitBox {
    private OptimisticLock lockSplitter = new OptimisticLock();

    @Override
    protected void initializeSwt(Composite parent) {
        SashForm container = this.getEnvironment().getFormToolkit().createSashForm(parent, ((ISplitBox)this.getScoutObject()).isSplitHorizontal() ? 256 : 512);
        container.setBackground(container.getDisplay().getSystemColor(19));
        for (IFormField scoutField : ((ISplitBox)this.getScoutObject()).getFields()) {
            this.getEnvironment().createFormField((Composite)container, scoutField);
        }
        this.setSwtContainer((Composite)container);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            this.setCachedSplitterPosition();
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    protected void setCachedSplitterPosition() {
        int[] a = ClientUIPreferences.getInstance((IClientSession)this.getEnvironment().getClientSession()).getSplitterPosition((ISplitBox)this.getScoutObject());
        if (a != null && a.length == 2) {
            this.setSplitterPosition(a[0], a[1]);
        } else {
            this.setSplitterPositionFromScout();
        }
    }

    @Override
    protected void detachScout() {
        this.setSplitterPositionFromSwt();
        super.detachScout();
    }

    @Override
    public SashForm getSwtContainer() {
        return (SashForm)super.getSwtContainer();
    }

    protected void setSplitterPositionFromSwt() {
        if (((ISplitBox)this.getScoutObject()).isCacheSplitterPosition()) {
            int[] weights = this.getSwtContainer().getWeights();
            this.cacheSplitterPosition(weights);
        } else {
            this.cacheSplitterPosition(null);
        }
    }

    protected void cacheSplitterPosition(final int[] weights) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                ClientUIPreferences.getInstance((IClientSession)SwtScoutSplitBox.this.getEnvironment().getClientSession()).setSplitterPosition((ISplitBox)SwtScoutSplitBox.this.getScoutObject(), weights);
            }
        };
        this.getEnvironment().invokeScoutLater(job, 0L);
    }

    protected void setSplitterPositionFromScout() {
        try {
            if (this.lockSplitter.acquire()) {
                int[] weights;
                double position = ((ISplitBox)this.getScoutObject()).getSplitterPosition();
                weights = new int[]{(int)(position * 100.0), 100 - weights[0]};
                this.getSwtContainer().setWeights(weights);
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    protected void setSplitterPosition(int leftWidth, int rightWidth) {
        try {
            int total;
            if (this.lockSplitter.acquire() && (total = leftWidth + rightWidth) > 0) {
                int leftPct = leftWidth * 100 / total;
                int rightPct = rightWidth * 100 / total;
                this.getSwtContainer().setWeights(new int[]{leftPct, rightPct});
            }
        }
        finally {
            this.lockSplitter.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (!"splitterEnabled".equals(name) && "splitterPosition".equals(name)) {
            this.setSplitterPositionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }
}

