/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.wrappedformfield;

import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.wrappedformfield.ISwtScoutWrappedFormField;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutWrappedFormField
extends SwtScoutFieldComposite<IWrappedFormField<? extends IForm>>
implements ISwtScoutWrappedFormField {
    private ISwtScoutForm m_formComposite;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        this.setSwtContainer(container);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 2;
        fillLayout.marginWidth = 2;
        this.getSwtContainer().setLayout((Layout)fillLayout);
    }

    @Override
    public IWrappedFormField<?> getScoutObject() {
        return (IWrappedFormField)super.getScoutObject();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setInnerFormFromScout(this.getScoutObject().getInnerForm());
    }

    protected void setInnerFormFromScout(IForm innerForm) {
        try {
            this.getSwtContainer().setRedraw(false);
            if (this.m_formComposite != null) {
                this.m_formComposite.dispose();
                this.m_formComposite = null;
                this.setSwtField(null);
            }
            if (innerForm != null) {
                this.m_formComposite = this.getEnvironment().createForm(this.getSwtContainer(), innerForm);
                this.setSwtField((Control)this.m_formComposite.getSwtContainer());
                this.m_formComposite.getSwtContainer().setLayoutData(null);
            }
            if (this.isConnectedToScout()) {
                SwtLayoutUtility.invalidateLayout((Control)this.getSwtContainer());
            }
        }
        finally {
            this.getSwtContainer().setRedraw(true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("innerForm")) {
            this.setInnerFormFromScout((IForm)newValue);
        }
    }
}

