/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.internal;

import java.util.Stack;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class StyledTextFieldUndoRedoSupport {
    private static final int MAX_STACK_SIZE = 25;
    private StyledText m_styledText;
    private volatile int m_inactiveCounter = 0;
    private volatile boolean m_clearRedo = true;
    private Stack<P_TextChange> m_undoStack;
    private Stack<P_TextChange> m_redoStack;
    private boolean disposed = true;

    public StyledTextFieldUndoRedoSupport(StyledText styledText) {
        this.m_styledText = styledText;
        this.init();
    }

    private void init() {
        this.m_undoStack = new Stack();
        this.m_redoStack = new Stack();
        this.m_styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (StyledTextFieldUndoRedoSupport.this.isActive()) {
                    if (StyledTextFieldUndoRedoSupport.this.m_clearRedo) {
                        StyledTextFieldUndoRedoSupport.this.m_redoStack.clear();
                    }
                    if (StyledTextFieldUndoRedoSupport.this.m_undoStack.size() == 25) {
                        StyledTextFieldUndoRedoSupport.this.m_undoStack.remove(0);
                    }
                    StyledTextFieldUndoRedoSupport.this.m_undoStack.push(new P_TextChange(event.start, event.length, event.replacedText));
                } else {
                    if (StyledTextFieldUndoRedoSupport.this.m_redoStack.size() == 25) {
                        StyledTextFieldUndoRedoSupport.this.m_redoStack.remove(0);
                    }
                    StyledTextFieldUndoRedoSupport.this.m_redoStack.push(new P_TextChange(event.start, event.length, event.replacedText));
                }
            }
        });
        this.m_styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == 262144) {
                    switch (e.keyCode) {
                        case 89: 
                        case 121: {
                            StyledTextFieldUndoRedoSupport.this.redo();
                            break;
                        }
                        case 90: 
                        case 122: {
                            StyledTextFieldUndoRedoSupport.this.undo();
                        }
                    }
                }
            }
        });
    }

    public StyledText getStyledText() {
        return this.m_styledText;
    }

    public boolean isActive() {
        return this.m_inactiveCounter == 0;
    }

    public boolean setActive(boolean active) {
        if (active) {
            ++this.m_inactiveCounter;
        } else if (this.m_inactiveCounter > 0) {
            --this.m_inactiveCounter;
        }
        return this.m_inactiveCounter == 0;
    }

    public boolean hasUndoChanges() {
        return !this.m_undoStack.isEmpty();
    }

    public boolean hasRedoChanges() {
        return !this.m_redoStack.isEmpty();
    }

    public void undo() {
        if (!this.m_undoStack.isEmpty()) {
            P_TextChange change = this.m_undoStack.pop();
            try {
                this.setActive(false);
                this.m_styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
                this.m_styledText.setCaretOffset(change.getStart());
                this.m_styledText.setTopIndex(this.m_styledText.getLineAtOffset(change.getStart()));
                int length = change.getLength() == 0 ? change.getReplacedText().length() : change.getLength();
                this.m_styledText.setSelectionRange(change.getStart(), length);
            }
            finally {
                this.setActive(true);
            }
        }
    }

    public void redo() {
        if (this.m_redoStack.size() > 0) {
            P_TextChange change = this.m_redoStack.pop();
            try {
                this.m_clearRedo = false;
                this.m_styledText.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
                this.m_styledText.setCaretOffset(change.getStart());
                this.m_styledText.setTopIndex(this.m_styledText.getLineAtOffset(change.getStart()));
                int length = change.getLength() == 0 ? change.getReplacedText().length() : change.getLength();
                this.m_styledText.setSelectionRange(change.getStart(), length);
            }
            finally {
                this.m_clearRedo = true;
            }
        }
    }

    class P_TextChange {
        private int start;
        private int length;
        String replacedText;

        public P_TextChange(int start, int length, String replacedText) {
            this.start = start;
            this.length = length;
            this.replacedText = replacedText;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public String getReplacedText() {
            return this.replacedText;
        }
    }
}

