/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.window.SwtScoutPartEvent;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutPopup;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class SwtScoutDropDownPopup
extends SwtScoutPopup {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutDropDownPopup.class);
    private Composite m_focusComponent;
    private FocusListener m_focusComponentListener;
    private boolean m_nonFocusable;
    private P_ScrollBarListener m_scrollbarListener;

    public SwtScoutDropDownPopup(ISwtEnvironment env, Control ownerComponent, Composite focusComponent, int style) {
        super(env, ownerComponent, ownerComponent.getBounds(), style);
        this.m_focusComponent = focusComponent;
        this.getShell().setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)this.getShell()){

            @Override
            public void validate() {
                SwtScoutDropDownPopup.this.autoAdjustBounds();
            }
        });
    }

    public void makeNonFocusable() {
        this.m_nonFocusable = true;
    }

    @Override
    protected void handleSwtWindowOpened() {
        if (this.getOwnerComponent() != null && !this.getOwnerComponent().isDisposed()) {
            if (this.m_scrollbarListener == null) {
                this.m_scrollbarListener = new P_ScrollBarListener();
            }
            this.reqAddScrollbarListener(this.m_scrollbarListener, this.getOwnerComponent());
            this.getOwnerComponent().getShell().addListener(10, (Listener)this.m_scrollbarListener);
        }
        this.installFocusListener();
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 20));
        this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 30));
        if (this.m_nonFocusable) {
            if (this.getShell().getDisplay().getActiveShell() == this.getShell()) {
                this.m_focusComponent.setFocus();
            }
            if (!this.m_focusComponent.isFocusControl()) {
                this.closePart();
                this.fireSwtScoutPartEvent(new SwtScoutPartEvent(this, 50));
            }
        }
    }

    protected void installFocusListener() {
        if (this.m_focusComponentListener != null) {
            return;
        }
        if (this.m_focusComponent == null || this.m_focusComponent.isDisposed()) {
            return;
        }
        this.m_focusComponentListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SwtScoutDropDownPopup.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutDropDownPopup.this.getShell().isDisposed()) {
                            return;
                        }
                        if (SwtScoutDropDownPopup.this.getShell() == SwtScoutDropDownPopup.this.getShell().getDisplay().getActiveShell()) {
                            Control c = SwtScoutDropDownPopup.this.getShell().getDisplay().getFocusControl();
                            if (c != null && c != SwtScoutDropDownPopup.this.getShell() && c.getShell() == SwtScoutDropDownPopup.this.getShell()) {
                                c.addMouseListener((MouseListener)new MouseAdapter(){

                                    public void mouseUp(MouseEvent event) {
                                        if (!((Control)event.getSource()).isDisposed()) {
                                            ((Control)event.getSource()).removeMouseListener((MouseListener)this);
                                        }
                                        if (!SwtScoutDropDownPopup.this.m_focusComponent.isDisposed()) {
                                            SwtScoutDropDownPopup.this.m_focusComponent.setFocus();
                                        }
                                    }
                                });
                            } else {
                                SwtScoutDropDownPopup.this.m_focusComponent.setFocus();
                            }
                        } else {
                            SwtScoutDropDownPopup.this.closePart();
                            SwtScoutDropDownPopup.this.fireSwtScoutPartEvent(new SwtScoutPartEvent(SwtScoutDropDownPopup.this, 50));
                        }
                    }
                });
            }
        };
        this.m_focusComponent.addFocusListener(this.m_focusComponentListener);
    }

    protected void uninstallFocusLostListener() {
        if (this.m_focusComponent == null || this.m_focusComponentListener == null) {
            return;
        }
        if (!this.m_focusComponent.isDisposed()) {
            this.m_focusComponent.removeFocusListener(this.m_focusComponentListener);
        }
        this.m_focusComponentListener = null;
    }

    @Override
    protected void handleSwtWindowClosed() {
        if (this.getOwnerComponent() != null && !this.getOwnerComponent().isDisposed() && this.m_scrollbarListener != null) {
            this.reqRemoveScrollbarListener(this.m_scrollbarListener, this.getOwnerComponent());
            if (this.getOwnerComponent().getShell() != null && !this.getOwnerComponent().getShell().isDisposed()) {
                this.getOwnerComponent().getShell().removeListener(10, (Listener)this.m_scrollbarListener);
            }
        }
        this.m_scrollbarListener = null;
        this.uninstallFocusLostListener();
        super.handleSwtWindowClosed();
    }

    private void reqRemoveScrollbarListener(Listener l, Control control) {
        if (!(control instanceof Composite)) {
            return;
        }
        Composite composite = (Composite)control;
        if (composite.getData("SCROLLED_FORM") != null) {
            ScrollBar vBar;
            composite.removeListener(11, l);
            composite.removeListener(10, l);
            ScrollBar hBar = composite.getHorizontalBar();
            if (hBar != null) {
                hBar.removeListener(13, l);
            }
            if ((vBar = composite.getVerticalBar()) != null) {
                vBar.removeListener(13, l);
            }
        }
        this.reqRemoveScrollbarListener(l, (Control)composite.getParent());
    }

    private void reqAddScrollbarListener(Listener l, Control control) {
        if (!(control instanceof Composite)) {
            return;
        }
        Composite composite = (Composite)control;
        if (control.getData("SCROLLED_FORM") != null) {
            ScrollBar vBar;
            control.addListener(11, l);
            control.addListener(10, l);
            ScrollBar hBar = composite.getHorizontalBar();
            if (hBar != null) {
                hBar.addListener(13, l);
            }
            if ((vBar = composite.getVerticalBar()) != null) {
                vBar.addListener(13, l);
            }
        }
        this.reqAddScrollbarListener(l, (Control)control.getParent());
    }

    private class P_ScrollBarListener
    implements Listener {
        private P_ScrollBarListener() {
        }

        public void handleEvent(Event event) {
            SwtScoutDropDownPopup.this.closePart();
        }
    }
}

