/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility.internal;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scout.sdk.compatibility.PlatformVersionUtility;
import org.eclipse.scout.sdk.compatibility.internal.ICompatibilityActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ScoutCompatibilityActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.compatibility";
    public static final String EXT_NAME = "activator";
    public static final String EXT_ATTRIB_CLASS_NAME = "class";
    public static final String EXT_ATTRIB_VERSION_NAME = "platformVersion";
    private static ScoutCompatibilityActivator instance;
    private BundleContext m_context;

    public static ScoutCompatibilityActivator getDefault() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        IExtension[] extensions;
        super.start(context);
        instance = this;
        this.m_context = context;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint(PLUGIN_ID, EXT_NAME);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String versions = element.getAttribute(EXT_ATTRIB_VERSION_NAME);
                if (ScoutCompatibilityActivator.matchesAnyVersion(versions)) {
                    ICompatibilityActivator o = (ICompatibilityActivator)element.createExecutableExtension(EXT_ATTRIB_CLASS_NAME);
                    o.start();
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static boolean matchesAnyVersion(String versions) {
        String[] compatibleVersions;
        if (versions == null || versions.length() < 1) {
            return false;
        }
        String[] stringArray = compatibleVersions = versions.split(",");
        int n = compatibleVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (ScoutCompatibilityActivator.matchesVersion(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean matchesVersion(String version) {
        if (version == null) {
            return false;
        }
        if ((version = version.trim()).length() == 0) {
            return false;
        }
        Version pv = PlatformVersionUtility.getPlatformVersion();
        String[] segments = version.split("\\.");
        if (segments.length == 0) {
            return false;
        }
        String[] platformVersion = new String[]{"" + pv.getMajor(), "" + pv.getMinor(), "" + pv.getMicro(), pv.getQualifier()};
        int i = 0;
        while (i < Math.min(segments.length, platformVersion.length)) {
            if (!platformVersion[i].equals(segments[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.m_context = null;
        super.stop(context);
    }

    public <S> S acquireService(Class<S> clazz) {
        ServiceReference reference = this.m_context.getServiceReference(clazz);
        try {
            if (reference == null) {
                return null;
            }
            Object object = this.m_context.getService(reference);
            return (S)object;
        }
        finally {
            this.m_context.ungetService(reference);
        }
    }

    public <T> T acquireCompatibilityService(Class<T> type) {
        Collection references = null;
        try {
            references = this.m_context.getServiceReferences(type, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (references == null || references.size() < 1) {
            return null;
        }
        if (references.size() != 1) {
            throw new RuntimeException("more than one service found for " + type.getName());
        }
        ServiceReference reference = (ServiceReference)references.iterator().next();
        try {
            Object object = this.m_context.getService(reference);
            return (T)object;
        }
        finally {
            this.m_context.ungetService(reference);
        }
    }

    public <T> void registerService(Class<T> type, T service) {
        this.m_context.registerService(type.getName(), service, new Hashtable(0));
    }
}

