/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.dto;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.dto.pagedata.PageDataAnnotation;
import org.eclipse.scout.sdk.workspace.dto.pagedata.PageDataDtoUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PageDataUpdateAction
extends AbstractScoutHandler {
    private IType m_pageDataOwner;

    public PageDataUpdateAction() {
        super(Texts.get((String)"UpdatePageData"), ScoutSdkUi.getImageDescriptor("tool_loading.gif"), null, false, IScoutHandler.Category.UDPATE);
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.getPageDataOwner()) && this.getPageDataOwner().getDeclaringType() == null;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        try {
            PageDataAnnotation pageDataAnnotation = ScoutTypeUtility.findPageDataAnnotation((IType)this.getPageDataOwner(), (ITypeHierarchy)TypeUtility.getSuperTypeHierarchy((IType)this.getPageDataOwner()));
            if (pageDataAnnotation != null && !StringUtility.isNullOrEmpty((String)pageDataAnnotation.getPageDataTypeSignature())) {
                OperationJob job = new OperationJob(new IOperation[]{new PageDataDtoUpdateOperation(this.getPageDataOwner(), pageDataAnnotation)});
                job.schedule();
            } else {
                MessageBox box = new MessageBox(shell, 34);
                box.setMessage(Texts.get((String)"CheckPageData"));
                box.open();
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("unable to calculate page data type for update of element '" + this.getPageDataOwner().getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    private IType getPageDataOwner() {
        return this.m_pageDataOwner;
    }

    public void setPageDataOwner(IType pageDataOwner) {
        this.m_pageDataOwner = pageDataOwner;
    }
}

