/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.technology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.compatibility.P2Utility;
import org.eclipse.scout.sdk.compatibility.TargetPlatformUtility;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.extensions.technology.ScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.LicenseDialog;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public abstract class AbstractScoutTechnologyHandler
implements IScoutTechnologyHandler {
    protected AbstractScoutTechnologyHandler() {
    }

    @Override
    public List<IScoutTechnologyResource> getModifactionResourceCandidates(IScoutBundle project) throws CoreException {
        ArrayList<IScoutTechnologyResource> ret = new ArrayList<IScoutTechnologyResource>();
        this.contributeResources(project, ret);
        return ret;
    }

    protected abstract void contributeResources(IScoutBundle var1, List<IScoutTechnologyResource> var2) throws CoreException;

    protected boolean showLicenseDialog(boolean selected, IProgressMonitor monitor, String[] featureIds, String[] featureUrls) throws CoreException {
        if (!selected) {
            return true;
        }
        try {
            final AtomicBoolean licAccepted = new AtomicBoolean(false);
            URI[] uris = new URI[featureUrls.length];
            int i = 0;
            while (i < uris.length) {
                uris[i] = URIUtil.fromString((String)featureUrls[i]);
                ++i;
            }
            final Map lic = P2Utility.getLicenses((String[])featureIds, (URI[])uris, (IProgressMonitor)monitor);
            ScoutSdkUi.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LicenseDialog licDialog = new LicenseDialog(ScoutSdkUi.getShell(), lic);
                    if (licDialog.open() == 0) {
                        licAccepted.set(true);
                    }
                }
            });
            return licAccepted.get();
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
    }

    protected void contributeProductFiles(List<IScoutTechnologyResource> list, String ... bundleFilter) throws CoreException {
        this.contributeProductFiles(list, true, bundleFilter);
    }

    protected void contributeProductFiles(List<IScoutTechnologyResource> list, boolean defaultSelection, String ... bundleFilter) throws CoreException {
        for (P_TechProductFile prodFile : this.getFilteredProductFiles(bundleFilter)) {
            list.add(new ScoutTechnologyResource(prodFile.bundle, prodFile.productFile, defaultSelection));
        }
    }

    protected void contributeManifestFiles(IScoutBundle[] bundles, List<IScoutTechnologyResource> list) {
        IScoutBundle[] iScoutBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle bundle = iScoutBundleArray[n2];
            this.contributeManifestFile(bundle, list);
            ++n2;
        }
    }

    protected void contributeManifestFile(IScoutBundle bundle, List<IScoutTechnologyResource> list) {
        IScoutTechnologyResource res;
        if (bundle != null && !bundle.isBinary() && (res = this.getManifestResource(bundle)).getResource() != null) {
            list.add(res);
        }
    }

    protected TriState getSelectionManifestsImportPackage(IScoutBundle[] projects, String ... importPackages) {
        if (projects == null || projects.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = this.getSelectionManifestsImportPackage(projects[0], importPackages);
        int i = 1;
        while (i < projects.length) {
            TriState tmp = this.getSelectionManifestsImportPackage(projects[i], importPackages);
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifestsImportPackage(IScoutBundle project, String ... importPackages) {
        if (importPackages == null || importPackages.length == 0) {
            return TriState.FALSE;
        }
        PluginModelHelper pluginModel = new PluginModelHelper(project.getSymbolicName());
        TriState ret = TriState.parseTriState((Object)pluginModel.Manifest.existsImportPackage(importPackages[0]));
        int i = 1;
        while (i < importPackages.length) {
            TriState tmp = TriState.parseTriState((Object)pluginModel.Manifest.existsImportPackage(importPackages[i]));
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifests(IScoutBundle[] projects, String ... pluginIds) {
        if (projects == null || projects.length == 0) {
            return TriState.FALSE;
        }
        TriState ret = this.getSelectionManifest(projects[0], pluginIds);
        int i = 1;
        while (i < projects.length) {
            TriState tmp = this.getSelectionManifest(projects[i], pluginIds);
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionManifest(IScoutBundle project, String ... pluginIds) {
        if (pluginIds == null || pluginIds.length == 0) {
            return TriState.FALSE;
        }
        PluginModelHelper pluginModel = new PluginModelHelper(project.getSymbolicName());
        TriState ret = TriState.parseTriState((Object)pluginModel.Manifest.existsDependency(pluginIds[0]));
        int i = 1;
        while (i < pluginIds.length) {
            TriState tmp = TriState.parseTriState((Object)pluginModel.Manifest.existsDependency(pluginIds[i]));
            if (tmp != ret) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionProductFiles(String[] filterPluginIds, String[] ... pluginIds) throws CoreException {
        List<P_TechProductFile> productFiles = this.getFilteredProductFiles(filterPluginIds);
        if (productFiles.size() == 0) {
            return null;
        }
        TriState ret = TriState.parseTriState((Object)this.containsProductDependencies(productFiles.get((int)0).productFile, pluginIds));
        int i = 1;
        while (i < productFiles.size()) {
            TriState tmp = TriState.parseTriState((Object)this.containsProductDependencies(productFiles.get((int)i).productFile, pluginIds));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    protected TriState getSelectionTargetFileContainsFeature(List<ScoutTechnologyResource> files, String ... featureIds) throws CoreException {
        if (files.size() < 1) {
            return null;
        }
        TriState ret = TriState.parseTriState((Object)this.isTargetContainingFeature(files.get(0).getResource(), featureIds));
        int i = 1;
        while (i < files.size()) {
            TriState tmp = TriState.parseTriState((Object)this.isTargetContainingFeature(files.get(i).getResource(), featureIds));
            if (ret != tmp) {
                return TriState.UNDEFINED;
            }
            ++i;
        }
        return ret;
    }

    private boolean isTargetContainingFeature(IFile targetFile, String ... featureIds) throws CoreException {
        String content = ResourceUtility.getContent((IFile)targetFile);
        String[] stringArray = featureIds;
        int n = featureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!content.contains(id)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean preSelectionChanged(Set<IScoutTechnologyResource> resources, boolean selected, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    @Override
    public void postSelectionChanged(boolean selected, IProgressMonitor monitor) throws CoreException {
    }

    protected void selectionChangedProductFiles(Set<IScoutTechnologyResource> resources, boolean selected, String[] ... pluginIds) throws CoreException {
        for (IScoutTechnologyResource r : resources) {
            this.selectionChangedProductFile(r, selected, pluginIds);
        }
    }

    protected void selectionChangedProductFile(IScoutTechnologyResource r, boolean selected, String[] ... pluginIds) throws CoreException {
        ProductFileModelHelper h = new ProductFileModelHelper(r.getResource());
        if (pluginIds != null) {
            String[][] stringArray = pluginIds;
            int n = pluginIds.length;
            int n2 = 0;
            while (n2 < n) {
                String[] list = stringArray[n2];
                if (list != null) {
                    String[] stringArray2 = list;
                    int n3 = list.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String pluginId = stringArray2[n4];
                        if (selected) {
                            h.ProductFile.addDependency(pluginId);
                        } else {
                            h.ProductFile.removeDependency(pluginId);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        h.save();
    }

    protected boolean closeTargetEditors(Set<IScoutTechnologyResource> resources) {
        final AtomicBoolean success = new AtomicBoolean(false);
        final HashSet<IFile> files = new HashSet<IFile>(resources.size());
        for (IScoutTechnologyResource r : resources) {
            files.add(r.getResource());
        }
        ScoutSdkUi.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                success.set(UiUtility.closeEditors("org.eclipse.pde.ui.targetEditor", files));
            }
        });
        return success.get();
    }

    protected void selectionChangedTargetFiles(Set<IScoutTechnologyResource> resources, boolean selected, IProgressMonitor monitor, String[] featureIds, String[] featureVersions, String[] featureUrls) throws CoreException {
        for (IScoutTechnologyResource r : resources) {
            if (selected) {
                int i = 0;
                while (i < featureIds.length) {
                    TargetPlatformUtility.addInstallableUnitToTarget((IFile)r.getResource(), (String)featureIds[i], (String)featureVersions[i], (String)featureUrls[i], (IProgressMonitor)monitor);
                    ++i;
                }
                continue;
            }
            TargetPlatformUtility.removeInstallableUnitsFromTarget((IFile)r.getResource(), (String[])featureIds);
        }
        if (resources.size() == 1) {
            IFile file = ((IScoutTechnologyResource)CollectionUtility.firstElement(resources)).getResource();
            try {
                TargetPlatformUtility.resolveTargetPlatform((IFile)file, (boolean)true, (IProgressMonitor)monitor);
            }
            catch (IllegalStateException e) {
                ScoutSdkUi.logError("Unable to resolve target file '" + file.getFullPath().toOSString() + "'.", e);
            }
        }
    }

    protected void selectionChangedManifest(Set<IScoutTechnologyResource> resources, boolean selected, String ... pluginsToHandle) throws CoreException {
        for (IScoutTechnologyResource r : resources) {
            this.selectionChangedManifest(r, selected, pluginsToHandle);
        }
    }

    protected void selectionChangedManifest(IScoutTechnologyResource r, boolean selected, String ... pluginsToHandle) throws CoreException {
        PluginModelHelper pluginModel = new PluginModelHelper(r.getBundle().getSymbolicName());
        String[] stringArray = pluginsToHandle;
        int n = pluginsToHandle.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId = stringArray[n2];
            if (selected) {
                pluginModel.Manifest.addDependency(pluginId);
            } else {
                pluginModel.Manifest.removeDependency(pluginId);
            }
            ++n2;
        }
        pluginModel.save();
    }

    protected void selectionChangedManifestImportPackage(Set<IScoutTechnologyResource> resources, boolean selected, String[] packages, String[] versions) throws CoreException {
        for (IScoutTechnologyResource r : resources) {
            PluginModelHelper pluginModel = new PluginModelHelper(r.getBundle().getSymbolicName());
            int i = 0;
            while (i < Math.min(packages.length, versions.length)) {
                if (selected) {
                    pluginModel.Manifest.addImportPackage(packages[i], versions[i]);
                } else {
                    pluginModel.Manifest.removeImportPackage(packages[i]);
                }
                ++i;
            }
            pluginModel.save();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean containsProductDependencies(IFile productFile, String[] ... pluginFilters) {
        try {
            ProductFileModelHelper h = new ProductFileModelHelper(productFile);
            if (pluginFilters != null) {
                String[][] stringArray = pluginFilters;
                int n = pluginFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] list = stringArray[n2];
                    if (list != null) {
                        String[] stringArray2 = list;
                        int n3 = list.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String pluginId = stringArray2[n4];
                            if (!h.ProductFile.existsDependency(pluginId)) {
                                return false;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return true;
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("cannot parse product file: " + productFile, e);
            return false;
        }
    }

    protected List<ScoutTechnologyResource> getTargetFiles() throws CoreException {
        ArrayList<ScoutTechnologyResource> ret = new ArrayList<ScoutTechnologyResource>();
        IResource[] iResourceArray = ResourceUtility.getAllResources((IResourceFilter)ResourceFilters.getTargetFileFilter());
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            IProject p = r.getProject();
            IScoutBundle sb = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle(p);
            boolean checked = p.getName().endsWith(".target");
            ret.add(new ScoutTechnologyResource(sb, (IFile)r, checked));
            ++n2;
        }
        return ret;
    }

    protected List<P_TechProductFile> getProductFiles() throws CoreException {
        ArrayList<P_TechProductFile> list = new ArrayList<P_TechProductFile>();
        IResource[] iResourceArray = ResourceUtility.getAllResources((IResourceFilter)ResourceFilters.getProductFileFilter());
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            IProject p = r.getProject();
            IScoutBundle sb = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle(p);
            P_TechProductFile tpf = new P_TechProductFile();
            tpf.bundle = sb;
            tpf.productFile = (IFile)r;
            list.add(tpf);
            ++n2;
        }
        return list;
    }

    protected IScoutTechnologyResource getManifestResource(IScoutBundle bundle) {
        return new ScoutTechnologyResource(bundle, bundle.getProject().getFile("META-INF/MANIFEST.MF"));
    }

    protected List<P_TechProductFile> getFilteredProductFiles(String ... pluginFilter) throws CoreException {
        List<P_TechProductFile> candidates = this.getProductFiles();
        ArrayList<P_TechProductFile> ret = new ArrayList<P_TechProductFile>(candidates.size());
        for (P_TechProductFile candidate : candidates) {
            if (!this.containsProductDependencies(candidate.productFile, new String[][]{pluginFilter})) continue;
            ret.add(candidate);
        }
        return ret;
    }

    protected FeatureInstallResult ensureFeatureInstalled(String featureId, String featureUrl, IProgressMonitor monitor, String ... definingPlugins) throws CoreException {
        return this.ensureFeaturesInstalled(new String[]{featureId}, new String[]{featureUrl}, monitor, new String[][]{definingPlugins});
    }

    protected FeatureInstallResult ensureFeaturesInstalled(String[] featureIds, String[] featureUrls, IProgressMonitor monitor, String[] ... definingPlugins) throws CoreException {
        ArrayList<URI> repos = new ArrayList<URI>();
        ArrayList<String> featureIdsToInstall = new ArrayList<String>();
        try {
            int maxNum = Math.min(Math.min(featureIds.length, featureUrls.length), definingPlugins.length);
            int i = 0;
            while (i < maxNum) {
                if (!JdtUtility.areAllPluginsInstalled((String[])definingPlugins[i])) {
                    repos.add(URIUtil.fromString((String)featureUrls[i]));
                    featureIdsToInstall.add(featureIds[i]);
                }
                ++i;
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
        }
        if (featureIdsToInstall.size() == 0) {
            return FeatureInstallResult.InstallationNotNecessary;
        }
        URI[] repoURIs = repos.toArray(new URI[repos.size()]);
        String[] ius = featureIdsToInstall.toArray(new String[featureIdsToInstall.size()]);
        final AtomicBoolean licAccepted = new AtomicBoolean(false);
        final Map licenses = P2Utility.getLicenses((String[])ius, (URI[])repoURIs, (IProgressMonitor)monitor);
        ScoutSdkUi.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LicenseDialog licDialog = new LicenseDialog(ScoutSdkUi.getShell(), licenses);
                if (licDialog.open() == 0) {
                    licAccepted.set(true);
                }
            }
        });
        if (licAccepted.get()) {
            P2Utility.installUnits((String[])ius, (URI[])repoURIs, (IProgressMonitor)monitor);
            return FeatureInstallResult.InstallationSuccessful;
        }
        return FeatureInstallResult.LicenseNotAccepted;
    }

    protected void refreshScoutExplorerPageAsync(final Class<? extends IPage> pageToRefresh) {
        ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IPage root;
                    IScoutExplorerPart explorer = ScoutSdkUi.getExplorer(false);
                    if (explorer != null && (root = explorer.getRootPage()) != null) {
                        INodeVisitor visitor = new INodeVisitor(){

                            @Override
                            public int visit(IPage page) {
                                if (pageToRefresh.isAssignableFrom(page.getClass())) {
                                    page.markStructureDirty();
                                    return 3;
                                }
                                return 1;
                            }
                        };
                        JdtUtility.waitForSilentWorkspace();
                        root.accept(visitor);
                    }
                }
                catch (Exception e) {
                    ScoutSdkUi.logWarning("Unable to refresh explorer page '" + pageToRefresh.getName() + "'.", e);
                }
            }
        });
    }

    protected static enum FeatureInstallResult {
        InstallationNotNecessary,
        InstallationSuccessful,
        LicenseNotAccepted;

    }

    protected static class P_TechProductFile {
        public IFile productFile;
        public IScoutBundle bundle;

        protected P_TechProductFile() {
        }
    }
}

