/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.javaelement;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;

public class JavaElementAbstractTypeContentProvider
extends AbstractJavaElementContentProvider {
    private final IType m_superType;
    private final IJavaProject m_project;
    private final IType[] m_mostlyUsed;
    private ITypeFilter m_filter;

    public JavaElementAbstractTypeContentProvider(IType superType, IJavaProject project, IType ... mostlyUsed) {
        this(superType, project, (ITypeFilter)null, mostlyUsed);
    }

    public JavaElementAbstractTypeContentProvider(IType superType, IJavaProject project, ITypeFilter filter, IType ... mostlyUsed) {
        this.m_superType = superType;
        this.m_project = project;
        this.m_mostlyUsed = mostlyUsed;
        this.m_filter = filter;
    }

    @Override
    protected Object[][] computeProposals() {
        IPrimaryTypeTypeHierarchy typeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.m_superType);
        ITypeFilter filter = null;
        IType[] mostlyUsed = null;
        if (this.getFilter() == null) {
            filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getNotInTypes((IType[])this.m_mostlyUsed), TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_project)});
            mostlyUsed = this.m_mostlyUsed;
        } else {
            filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getNotInTypes((IType[])this.m_mostlyUsed), TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_project), this.getFilter()});
            if (this.m_mostlyUsed != null) {
                ArrayList<IType> mu = new ArrayList<IType>(this.m_mostlyUsed.length);
                IType[] iTypeArray = this.m_mostlyUsed;
                int n = this.m_mostlyUsed.length;
                int n2 = 0;
                while (n2 < n) {
                    IType o = iTypeArray[n2];
                    if (TypeUtility.exists((IJavaElement)o) && this.getFilter().accept(o)) {
                        mu.add(o);
                    }
                    ++n2;
                }
                mostlyUsed = mu.toArray(new IType[mu.size()]);
            }
        }
        IType[] abstractTypes = typeHierarchy.getAllSubtypes(this.m_superType, filter, TypeComparators.getTypeNameComparator());
        return new Object[][]{mostlyUsed, abstractTypes};
    }

    public ITypeFilter getFilter() {
        return this.m_filter;
    }

    public void setFilter(ITypeFilter filter) {
        this.m_filter = filter;
        this.invalidateCache();
    }
}

