/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IDialogSettingsProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.MoreElementsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public class NlsTextContentProvider
extends ContentProposalProvider
implements IDialogSettingsProvider {
    private final NlsTextLabelProvider m_labelProvider;

    public NlsTextContentProvider(NlsTextLabelProvider labelProvider) {
        this.m_labelProvider = labelProvider;
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        HashSet<NlsTextProposal> firstGroup = new HashSet<NlsTextProposal>();
        HashSet<NlsTextProposal> secondGroup = new HashSet<NlsTextProposal>();
        if (this.getLabelProvider().getNlsProject() != null) {
            searchPattern = !StringUtility.hasText((String)searchPattern) ? "*" : searchPattern.trim();
            this.getLabelProvider().startRecordMatchRegions();
            ContentProposalProvider.NormalizedPattern pattern = NlsTextContentProvider.createNormalizedSearchPattern(searchPattern);
            Language developmentLanguage = this.getLabelProvider().getNlsProject().getDevelopmentLanguage();
            INlsEntry[] iNlsEntryArray = this.getLabelProvider().getNlsProject().getAllEntries();
            int n = iNlsEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                INlsEntry entry = iNlsEntryArray[n2];
                if (monitor.isCanceled()) break;
                NlsTextProposal candidate = new NlsTextProposal(entry, developmentLanguage);
                if (candidate.matches(pattern)) {
                    int[] matchingRegions = candidate.getMatchingRegions(pattern);
                    if (candidate.getMatchKind() == 1) {
                        firstGroup.add(candidate);
                    } else {
                        secondGroup.add(candidate);
                    }
                    this.getLabelProvider().addMatchRegions(candidate, matchingRegions);
                }
                ++n2;
            }
            boolean hasSecondGroupItems = secondGroup.size() > 0;
            int numAdditionalElements = hasSecondGroupItems ? 2 : 1;
            Object[] nlsEntryResult = new Object[firstGroup.size() + secondGroup.size() + numAdditionalElements];
            if (firstGroup.size() > 0) {
                Object[] firstPart = firstGroup.toArray(new Object[firstGroup.size()]);
                Arrays.sort(firstPart);
                System.arraycopy(firstPart, 0, nlsEntryResult, 0, firstPart.length);
            }
            nlsEntryResult[firstGroup.size()] = NlsTextProposal.NEW_NLS_TEXT_PROPOSAL;
            if (hasSecondGroupItems) {
                nlsEntryResult[firstGroup.size() + 1] = MoreElementsProposal.INSTANCE;
                Object[] secondPart = secondGroup.toArray(new Object[secondGroup.size()]);
                Arrays.sort(secondPart);
                System.arraycopy(secondPart, 0, nlsEntryResult, firstGroup.size() + numAdditionalElements, secondPart.length);
            }
            return nlsEntryResult;
        }
        return new Object[0];
    }

    public NlsTextLabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }

    @Override
    public IDialogSettings getDialogSettings() {
        return ScoutSdkUi.getDefault().getDialogSettingsSection(NlsTextLabelProvider.class.getName(), true);
    }

    public int hashCode() {
        NlsTextLabelProvider labelProvider = this.getLabelProvider();
        if (labelProvider != null) {
            return labelProvider.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsTextContentProvider)) {
            return false;
        }
        NlsTextContentProvider ref = (NlsTextContentProvider)obj;
        return CompareUtility.equals((Object)this.getLabelProvider(), (Object)ref.getLabelProvider());
    }
}

