/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.bundle.IProductLauncherContributor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.AbstractLink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;

public class ServerProductLauncherContributor
implements IProductLauncherContributor {
    public static final String JETTY_PORT_CONFIG_KEY = "org.eclipse.equinox.http.jetty.http.port";
    public static final String JETTY_PATH_CONFIG_KEY = "org.eclipse.equinox.http.jetty.context.path";
    private JettyProductUrlOpenLink m_startPageLink;
    private JettyProductUrlOpenLink m_processServletLink;

    @Override
    public void contributeLinks(IFile productFile, LinksPresenterModel model) throws CoreException {
        boolean isJettyConfigured;
        boolean bl = isJettyConfigured = ServerProductLauncherContributor.getJettyBaseUrl(productFile) != null;
        if (isJettyConfigured) {
            this.m_startPageLink = new JettyProductUrlOpenLink("Start Page", productFile, "", 30);
            this.m_processServletLink = new JettyProductUrlOpenLink("Process Servlet", productFile, "process", 40);
            model.addGlobalLink(this.m_startPageLink);
            model.addGlobalLink(this.m_processServletLink);
        }
    }

    public static String getJettyBaseUrl(IFile productFile) throws CoreException {
        ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
        String port = StringUtility.trim((String)pfmh.ConfigurationFile.getEntry(JETTY_PORT_CONFIG_KEY));
        String path = StringUtility.trim((String)pfmh.ConfigurationFile.getEntry(JETTY_PATH_CONFIG_KEY));
        String URL_DELIM = "/";
        if (StringUtility.hasText((String)port)) {
            if (path == null || !StringUtility.hasText((String)path)) {
                path = "/";
            } else {
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
            }
            return "http://localhost:" + port + path;
        }
        return null;
    }

    @Override
    public void refreshLaunchState(String mode) {
        if (this.m_startPageLink != null && this.m_processServletLink != null) {
            boolean running = !"terminated".equals(mode);
            this.m_startPageLink.setEnabled(running);
            this.m_processServletLink.setEnabled(running);
        }
    }

    public static class JettyProductUrlOpenLink
    extends AbstractLink {
        private final String m_suffix;
        private final IFile m_productFile;
        private boolean m_enabled;

        public JettyProductUrlOpenLink(String name, IFile productFile, String suffix, int order) {
            super(name, ScoutSdkUi.getImage("web.gif"), order);
            this.m_suffix = suffix;
            this.m_productFile = productFile;
            this.setEnabled(true);
        }

        @Override
        public void execute() {
            if (this.isEnabled()) {
                try {
                    String baseUrl = ServerProductLauncherContributor.getJettyBaseUrl(this.m_productFile);
                    ResourceUtility.showUrlInBrowser((String)(String.valueOf(baseUrl) + this.m_suffix));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("Unable to parse Jetty URL.", e);
                }
            }
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public void setEnabled(boolean enabled) {
            this.m_enabled = enabled;
            if (this.isEnabled()) {
                this.setImage(ScoutSdkUi.getImage("web.gif"));
            } else {
                this.setImage(ScoutSdkUi.getImage("web_disabled"));
            }
        }
    }
}

