/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodBodySourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecMethodPresenter;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class ExecResetSearchFilterMethodPresenter
extends ExecMethodPresenter {
    public ExecResetSearchFilterMethodPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void overrideMethod() {
        if (!this.getMethod().isImplemented()) {
            try {
                P_OverrideExecResetSearchFilterMethod methodOverrideOperation = new P_OverrideExecResetSearchFilterMethod(this.getMethod().getMethodName(), this.getMethod().getType());
                OperationJob job = new OperationJob(new IOperation[]{methodOverrideOperation});
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (methodOverrideOperation.getCreatedMethod() != null) {
                    this.showJavaElementInEditor((IJavaElement)methodOverrideOperation.getCreatedMethod());
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("could not override the method '" + this.getMethod().getMethodName() + "' on '" + this.getMethod().getType() + "'", e);
            }
        }
    }

    private class P_OverrideExecResetSearchFilterMethod
    extends MethodOverrideOperation {
        private final IType iForm;
        private final IType iSearchForm;
        private IType m_formDataType;
        private IType m_formType;

        public P_OverrideExecResetSearchFilterMethod(String methodName, IType declaringType) throws CoreException {
            super(methodName, declaringType);
            this.iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
            this.iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
            this.setFormatSource(true);
            this.m_formDataType = null;
            this.m_formType = declaringType;
            IPrimaryTypeTypeHierarchy formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iForm);
            if (TypeUtility.exists((IJavaElement)this.m_formType) && formHierarchy.isSubtype(this.iSearchForm, this.m_formType)) {
                String formDataSimpleName = this.m_formType.getElementName().replaceAll("Form$", "FormData");
                IScoutBundle clientBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.getDeclaringType());
                IScoutBundle[] iScoutBundleArray = clientBundle.getParentBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
                int n = iScoutBundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle shared = iScoutBundleArray[n2];
                    String formDataFqn = String.valueOf(DefaultTargetPackage.get((IScoutBundle)shared, (String)"server.services")) + "." + formDataSimpleName;
                    if (TypeUtility.existsType((String)formDataFqn)) {
                        this.m_formDataType = TypeUtility.getType((String)formDataFqn);
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            if (this.m_formDataType != null && this.m_formType != null) {
                this.setMethodBodySourceBuilder(new IMethodBodySourceBuilder(){

                    public void createSource(IMethodSourceBuilder methodBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                        source.append("super.execResetSearchFilter(searchFilter);").append(lineDelimiter);
                        String simpleFormDataName = validator.getTypeName(SignatureCache.createTypeSignature((String)P_OverrideExecResetSearchFilterMethod.this.m_formDataType.getFullyQualifiedName()));
                        source.append(simpleFormDataName).append(" formData = new ").append(simpleFormDataName).append("();").append(lineDelimiter);
                        source.append("exportFormData(formData);").append(lineDelimiter);
                        source.append("searchFilter.setFormData(formData);");
                    }
                });
            }
            super.run(monitor, workingCopyManager);
        }
    }
}

