/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.ui.dialog.JavaElementSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractJavaElementListPresenter;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.OutlinesParser;
import org.eclipse.swt.widgets.Composite;

public class OutlinesPresenter
extends AbstractJavaElementListPresenter {
    private IPropertySourceParser<IType[]> m_parser = new OutlinesParser();

    public OutlinesPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    public IPropertySourceParser<IType[]> getParser() {
        return this.m_parser;
    }

    @Override
    public IJavaElement[] readSource() throws CoreException {
        return (IJavaElement[])this.getParser().parseSourceValue(this.getMethod().getSource(), this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected void handleAddComponent() {
        IJavaElement[] newOutlines;
        IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
        HashSet<IJavaElement> sourceProposals = new HashSet<IJavaElement>(Arrays.asList(this.getSourceProps()));
        ArrayList<IType> candidates = new ArrayList<IType>();
        IPrimaryTypeTypeHierarchy outlineHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iOutline);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getMethod().getType().getJavaProject()), TypeFilters.getClassFilter()});
        IType[] iTypeArray = outlineHierarchy.getAllSubtypes(iOutline, filter, TypeComparators.getTypeNameComparator());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (!sourceProposals.contains(t)) {
                candidates.add(t);
            }
            ++n2;
        }
        JavaElementSelectionDialog dialog = new JavaElementSelectionDialog(this.getContainer().getShell(), Texts.get((String)"AddOutline"));
        dialog.addPropertyChangeListener(new P_OutlineDialogPropertyListener(dialog));
        dialog.setMultiSelect(true);
        dialog.setJavaElements(candidates.toArray(new IJavaElement[candidates.size()]));
        dialog.create();
        dialog.getOkButton().setEnabled(false);
        if (dialog.open() == 0 && (newOutlines = dialog.getSelectedElements()).length > 0) {
            ArrayList<IJavaElement> outlines = new ArrayList<IJavaElement>(Arrays.asList(this.getSourceProps()));
            outlines.addAll(Arrays.asList(newOutlines));
            this.store(outlines.toArray(new IJavaElement[outlines.size()]));
        }
    }

    @Override
    public synchronized void store(IJavaElement[] proposals) {
        IType[] types = null;
        if (proposals != null) {
            types = new IType[proposals.length];
            int i = 0;
            while (i < proposals.length) {
                types[i] = (IType)proposals[i];
                ++i;
            }
        }
        try {
            ConfigPropertyUpdateOperation<IType[]> updateOp = new ConfigPropertyUpdateOperation<IType[]>(this.getMethod(), this.getParser()){

                protected void createSource(IMethodSourceBuilder methodBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                    source.append(super.getParser().formatSourceValue((Object)((IType[])super.getValue()), lineDelimiter, validator));
                }
            };
            updateOp.setValue((Object)types);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    private static final class P_OutlineDialogPropertyListener
    implements PropertyChangeListener {
        private final JavaElementSelectionDialog m_dialog;

        private P_OutlineDialogPropertyListener(JavaElementSelectionDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedElements")) {
                IJavaElement[] selection = (IJavaElement[])evt.getNewValue();
                this.m_dialog.getOkButton().setEnabled(selection.length > 0);
            }
        }
    }
}

