/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.util.proposal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.scout.sdk.ui.util.proposal.ChangeCorrectionProposal;
import org.eclipse.scout.sdk.ui.util.proposal.EditAnnotator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private ICompilationUnit fCompilationUnit;
    private boolean fSwitchedEditor;

    public CUCorrectionProposal(String name, ICompilationUnit cu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
    }

    public CUCorrectionProposal(String name, ICompilationUnit cu, TextChange change, int relevance) {
        this(name, cu, change, relevance, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
    }

    protected CUCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image) {
        this(name, cu, null, relevance, image);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    @Override
    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        StringBuilder buf = new StringBuilder();
        try {
            TextChange change = this.getTextChange();
            change.setKeepPreviewEdits(true);
            IDocument previewDocument = change.getPreviewDocument(monitor);
            TextEdit rootEdit = change.getPreviewEdit(change.getEdit());
            EditAnnotator ea = new EditAnnotator(buf, previewDocument);
            rootEdit.accept((TextEditVisitor)ea);
            ea.unchangedUntil(previewDocument.getLength());
        }
        catch (CoreException e) {
            JavaPlugin.log((Throwable)e);
        }
        return buf.toString();
    }

    @Override
    public void apply(IDocument document) {
        try {
            ICompilationUnit unit = this.getCompilationUnit();
            IEditorPart part = null;
            if (unit.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(unit);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor((Object)unit);
                if (part == null && (part = JavaUI.openInEditor((IJavaElement)unit)) != null) {
                    this.fSwitchedEditor = true;
                    document = JavaUI.getDocumentProvider().getDocument((Object)part.getEditorInput());
                }
                if ((page = JavaPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (String)CorrectionMessages.CUCorrectionProposal_error_title, (String)CorrectionMessages.CUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(ICompilationUnit unit) {
        IStatus status = Resources.makeCommittable((IResource)unit.getResource(), (Object)JavaPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.CUCorrectionProposal_error_title;
            String message = CorrectionMessages.CUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    protected TextChange createTextChange() throws CoreException {
        CompilationUnitChange change;
        Document document;
        ICompilationUnit cu = this.getCompilationUnit();
        String name = this.getName();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaElement)cu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            CompilationUnitChange cuChange = new CompilationUnitChange(name, cu);
            cuChange.setSaveMode(4);
            change = cuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    @Override
    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }

    protected boolean didOpenEditor() {
        return this.fSwitchedEditor;
    }
}

