/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.singlepage;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyViewConfig {
    private static final String TAG_TYPE = "type";
    private static final String TAG_CONFIG = "config";
    private static final String PROP_TYPE_NAME = "name";
    private static final String PROP_CONFIG_NAME = "name";
    private static final String PROP_CONFIG_TYPE = "type";
    private static final String PROP_CONFIG_CATEGORY = "category";
    private static final String PROP_CONFIG_ORDER = "order";
    private final HashMap<String, HashMap<String, Config>> m_typeConfigs = new HashMap(100);
    public static final ConfigTypes DEFAULT_CONFIG_TYPE = ConfigTypes.Advanced;
    public static final ConfigCategory DEFAULT_CONFIG_CATEGORY = ConfigCategory.Misc;

    public PropertyViewConfig() {
        this.load();
    }

    private void load() {
        try {
            URL url = FileLocator.find((Bundle)ScoutSdkUi.getDefault().getBundle(), (IPath)new Path("resources/sdkPropertyViewConfig.xml"), null);
            InputStream is = null;
            try {
                is = url.openStream();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document xmlDoc = docBuilder.parse(is);
                NodeList childNodes = xmlDoc.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    if ("type".equals(item.getNodeName()) && item instanceof Element) {
                        this.loadType((Element)item);
                    }
                    ++i;
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError("unable to load property view configuration. ", e);
        }
    }

    public Config getConfiguration(ConfigurationMethod m) {
        IType[] superTypes;
        IType[] iTypeArray = superTypes = m.getSuperTypeHierarchy().getAllSupertypes(m.getType());
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Config c;
            IType superType = iTypeArray[n2];
            HashMap<String, Config> tc = this.m_typeConfigs.get(superType.getFullyQualifiedName());
            if (tc != null && (c = tc.get(m.getMethodName())) != null) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private void loadType(Element type) {
        if (type == null) {
            return;
        }
        String name = type.getAttribute("name");
        if (name == null || name.trim().length() < 1) {
            return;
        }
        HashMap<String, Config> c = new HashMap<String, Config>(20);
        this.m_typeConfigs.put(name, c);
        NodeList childNodes = type.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (TAG_CONFIG.equals(item.getNodeName()) && item instanceof Element) {
                this.loadConfig(c, (Element)item);
            }
            ++i;
        }
    }

    private ConfigTypes parseConfigType(String type) {
        try {
            return ConfigTypes.valueOf(type);
        }
        catch (Exception e) {
            return DEFAULT_CONFIG_TYPE;
        }
    }

    private ConfigCategory parseConfigCategory(String cat) {
        try {
            return ConfigCategory.valueOf(cat);
        }
        catch (Exception e) {
            return DEFAULT_CONFIG_CATEGORY;
        }
    }

    private Double parseOrder(String order) {
        block3: {
            try {
                if (order != null && order.trim().length() >= 1) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return Double.parseDouble(order);
    }

    private void loadConfig(HashMap<String, Config> tc, Element config) {
        if (config == null) {
            return;
        }
        String name = config.getAttribute("name");
        if (StringUtility.hasText((String)name)) {
            String order;
            String category;
            String type = config.getAttribute("type");
            if (!StringUtility.hasText((String)type)) {
                type = ConfigTypes.Advanced.toString();
            }
            if (!StringUtility.hasText((String)(category = config.getAttribute(PROP_CONFIG_CATEGORY)))) {
                category = ConfigCategory.Misc.toString();
            }
            if (!StringUtility.hasText((String)(order = config.getAttribute(PROP_CONFIG_ORDER)))) {
                order = null;
            }
            Config c = new Config();
            c.category = this.parseConfigCategory(category);
            c.type = this.parseConfigType(type);
            c.order = this.parseOrder(order);
            tc.put(name, c);
        }
    }

    public static class Config {
        private ConfigTypes type;
        private ConfigCategory category;
        private Double order;

        public Double getOrder() {
            return this.order;
        }

        public ConfigTypes getType() {
            return this.type;
        }

        public ConfigCategory getCategory() {
            return this.category;
        }
    }

    public static enum ConfigCategory {
        Appearance(100),
        Layout(200),
        Behavior(300),
        Data(400),
        BusinessLogic(500),
        Misc(Integer.MAX_VALUE);

        private final int m_order;
        private final String m_name;

        private ConfigCategory(int order) {
            this.m_order = order;
            this.m_name = Texts.get((String)("PropertyViewConfig.Categories." + this.toString()));
        }

        public int getOrder() {
            return this.m_order;
        }

        public String getLabel() {
            return this.m_name;
        }
    }

    public static enum ConfigTypes {
        Normal,
        Advanced;

    }
}

