/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.code;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.codeid.CodeIdExtensionPoint;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.CodeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.fields.code.CodeIdField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iCode = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
    private String m_nextCodeId;
    private String m_nextCodeIdSource;
    private INlsEntry m_nlsName;
    private String m_typeName;
    private IType m_superType;
    private String m_genericSignature;
    private SiblingProposal m_sibling;
    private CodeIdField m_nextCodeIdField;
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_genericTypeField;
    private ProposalTextField m_siblingField;
    private final IType m_declaringType;
    private final IScoutBundle m_bundle;
    private IType m_createdCode;

    public CodeNewWizardPage(IType declaringType) {
        super(CodeNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewCode"));
        this.setDescription(Texts.get((String)"CreateANewCode"));
        this.m_declaringType = declaringType;
        this.m_bundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_declaringType.getJavaProject());
        this.m_genericSignature = null;
        this.m_sibling = SiblingProposal.SIBLING_END;
    }

    @Override
    public void postActivate() {
        this.m_nlsNameField.setFocus();
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        this.m_nextCodeIdField = new CodeIdField(parent, this.m_bundle, labelColWidthPercent);
        this.m_nextCodeIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeNewWizardPage.this.m_nextCodeId = CodeNewWizardPage.this.m_nextCodeIdField.getValue();
                CodeNewWizardPage.this.m_nextCodeIdSource = CodeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField(parent, ScoutTypeUtility.findNlsProject((IJavaElement)this.m_declaringType), Texts.get((String)"PropText"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.m_nlsName);
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = CodeNewWizardPage.this.getNlsName();
                    CodeNewWizardPage.this.m_nlsName = (INlsEntry)event.proposal;
                    if (CodeNewWizardPage.this.m_nlsName != null && (oldEntry == null || oldEntry.getKey().equals(CodeNewWizardPage.this.m_typeNameField.getModifiableText()) || StringUtility.isNullOrEmpty((String)CodeNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        CodeNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)CodeNewWizardPage.this.m_nlsName.getKey(), (boolean)false));
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("Code");
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CodeNewWizardPage.this.m_typeName = CodeNewWizardPage.this.m_typeNameField.getText();
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField.setText(this.m_typeName);
        ITypeFilter filter = null;
        String codeIdSignatureFromCodeType = null;
        try {
            IType codeType = TypeUtility.getPrimaryType((IJavaElement)this.m_declaringType);
            codeIdSignatureFromCodeType = ScoutTypeUtility.getCodeIdGenericTypeSignature((IType)codeType);
            String codeSignature = ScoutTypeUtility.getCodeSignature((IType)codeType, (ITypeHierarchy)codeType.newSupertypeHierarchy(null));
            if (codeSignature != null) {
                filter = codeIdSignatureFromCodeType != null ? TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getSubtypeFilter((IType)TypeUtility.getTypeBySignature((String)codeSignature)), TypeFilters.getTypeParamSubTypeFilter((String)codeIdSignatureFromCodeType, (String)"org.eclipse.scout.rt.shared.services.common.code.ICode", (String)"T")}) : TypeFilters.getSubtypeFilter((IType)TypeUtility.getTypeBySignature((String)codeSignature));
            }
        }
        catch (CoreException e1) {
            ScoutSdkUi.logWarning("Cannot resolve CodeType generic type.", e1);
        }
        IType defaultSuperType = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode", (IJavaProject)this.m_declaringType.getJavaProject());
        if (filter == null || filter.accept(defaultSuperType)) {
            this.m_superType = defaultSuperType;
            if (codeIdSignatureFromCodeType != null) {
                this.setGenericSignature(codeIdSignatureFromCodeType);
            }
        }
        final SignatureSubTypeProposalProvider proposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass(), this.m_bundle.getJavaProject());
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iCode, this.m_declaringType.getJavaProject(), filter, this.m_superType), labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    CodeNewWizardPage.this.m_superType = (IType)event.proposal;
                    if (TypeUtility.isGenericType((IType)CodeNewWizardPage.this.getSuperType())) {
                        CodeNewWizardPage.this.m_genericTypeField.setEnabled(true);
                    } else {
                        CodeNewWizardPage.this.m_genericTypeField.setEnabled(false);
                    }
                    IType genericTypeOfSuperClass = CodeNewWizardPage.this.getGenericTypeOfSuperClass();
                    try {
                        if (TypeUtility.exists((IJavaElement)genericTypeOfSuperClass) && (CodeNewWizardPage.this.getGenericSignature() == null || !TypeUtility.getTypeBySignature((String)CodeNewWizardPage.this.getGenericSignature()).newSupertypeHierarchy(null).contains(genericTypeOfSuperClass))) {
                            CodeNewWizardPage.this.m_genericTypeField.acceptProposal(SignatureCache.createTypeSignature((String)genericTypeOfSuperClass.getFullyQualifiedName()));
                        }
                        proposalProvider.setBaseType(genericTypeOfSuperClass);
                    }
                    catch (JavaModelException e) {
                        ScoutSdkUi.logError(e);
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_genericTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"GenericType"), 1, labelColWidthPercent);
        this.m_genericTypeField.setContentProvider(proposalProvider);
        this.m_genericTypeField.setLabelProvider((IBaseLabelProvider)proposalProvider.getLabelProvider());
        this.m_genericTypeField.acceptProposal(this.getGenericSignature());
        this.m_genericTypeField.setEnabled(TypeUtility.isGenericType((IType)this.getSuperType()));
        this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    CodeNewWizardPage.this.setStateChanging(true);
                    CodeNewWizardPage.this.setGenericSignature((String)event.proposal);
                    if (CodeNewWizardPage.this.getGenericSignature() != null) {
                        if (CodeNewWizardPage.this.getNextCodeId() == null) {
                            CodeNewWizardPage.this.setNextCodeId(CodeIdExtensionPoint.getNextCodeId((IScoutBundle)CodeNewWizardPage.this.m_bundle, (String)CodeNewWizardPage.this.getGenericSignature()));
                        } else {
                            CodeNewWizardPage.this.m_nextCodeIdSource = CodeNewWizardPage.this.m_nextCodeIdField.getValueSource();
                        }
                    }
                }
                finally {
                    CodeNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_siblingField = this.getFieldToolkit().createSiblingProposalField(parent, this.m_declaringType, this.iCode, labelColWidthPercent);
        this.m_siblingField.acceptProposal(this.m_sibling);
        this.m_siblingField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                CodeNewWizardPage.this.m_sibling = (SiblingProposal)event.proposal;
                CodeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_nextCodeIdField.setGenericTypeField(this.m_genericTypeField);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_nextCodeIdField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_genericTypeField.setLayoutData(new GridData(768));
        this.m_siblingField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        CodeNewOperation op = new CodeNewOperation(this.m_declaringType, true);
        op.setNlsEntry(this.getNlsName());
        op.setTypeName(this.getTypeName());
        String sig = null;
        sig = this.getGenericSignature() != null && TypeUtility.isGenericType((IType)this.getSuperType()) ? SignatureCache.createTypeSignature((String)(String.valueOf(this.getSuperType().getFullyQualifiedName()) + "<" + Signature.toString((String)this.getGenericSignature()) + ">")) : SignatureCache.createTypeSignature((String)this.getSuperType().getFullyQualifiedName());
        op.setSuperTypeSignature(sig);
        if (this.getSibling() == SiblingProposal.SIBLING_END) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredCodeType((IType)this.m_declaringType);
            op.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_CODE));
        } else {
            op.setSibling(this.getSibling().getElement());
        }
        op.setNextCodeId(this.getNextCodeIdSource());
        op.run(monitor, workingCopyManager);
        this.m_createdCode = op.getCreatedCode();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusCodeIdField());
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusGenericType());
            multiStatus.add(this.getStatusGenericTypeToSuperClass());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusGenericTypeToSuperClass() {
        IType generic;
        IType superType;
        if (this.getGenericSignature() != null && TypeUtility.exists((IJavaElement)(superType = this.getGenericTypeOfSuperClass())) && TypeUtility.exists((IJavaElement)(generic = TypeUtility.getTypeBySignature((String)this.getGenericSignature()))) && !TypeUtility.getSuperTypeHierarchy((IType)generic).contains(superType)) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
        }
        return Status.OK_STATUS;
    }

    protected IType getGenericTypeOfSuperClass() {
        if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
            try {
                String typeParamSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.getSuperType(), (ITypeHierarchy)this.getSuperType().newSupertypeHierarchy(null), (String)"org.eclipse.scout.rt.shared.services.common.code.ICode", (String)"T");
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    protected IStatus getStatusCodeIdField() {
        if (this.isControlCreated() && this.m_nextCodeIdField.getEnabled()) {
            return this.m_nextCodeIdField.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Code");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IType[] iTypeArray = this.m_declaringType.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (t.getElementName().equals(this.getTypeName())) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
            }
            ++n2;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGenericType() {
        if (TypeUtility.isGenericType((IType)this.getSuperType()) && this.getGenericSignature() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public void setNextCodeId(String nextCodeId) {
        try {
            this.setStateChanging(true);
            this.m_nextCodeId = nextCodeId;
            if (this.isControlCreated()) {
                this.m_nextCodeIdField.setValue(nextCodeId);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getNextCodeId() {
        return this.m_nextCodeId;
    }

    public String getNextCodeIdSource() {
        return this.m_nextCodeIdSource;
    }

    public IType getCreatedCode() {
        return this.m_createdCode;
    }

    public INlsEntry getNlsName() {
        return this.m_nlsName;
    }

    public void setNlsName(INlsEntry nlsName) {
        try {
            this.setStateChanging(true);
            this.m_nlsName = nlsName;
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(nlsName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
            this.m_typeName = typeName;
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setGenericSignature(String genericType) {
        try {
            this.setStateChanging(true);
            this.m_genericSignature = genericType;
            if (this.isControlCreated()) {
                this.m_genericTypeField.acceptProposal(genericType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getGenericSignature() {
        return this.m_genericSignature;
    }

    public SiblingProposal getSibling() {
        return this.m_sibling;
    }

    public void setSibling(SiblingProposal sibling) {
        try {
            this.setStateChanging(true);
            this.m_sibling = sibling;
            if (this.isControlCreated()) {
                this.m_siblingField.acceptProposal(sibling);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

