/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.annotations.ScoutSdkIgnore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.AbstractFormFieldWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.fields.table.ISeparator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtensionPoint;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormFieldSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iFormField = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
    private final IType m_declaringType;
    private AbstractScoutWizardPage m_nextPage;
    private Object m_currentSelection;
    private HashSet<IType> m_modelTypeShortList;
    private FilteredTable m_table;

    public FormFieldSelectionWizardPage(IType declaringType) {
        super(FormFieldSelectionWizardPage.class.getName());
        this.m_declaringType = declaringType;
        this.setTitle(Texts.get((String)"FormField"));
        this.setDescription(Texts.get((String)"FormFieldDesc"));
    }

    @Override
    protected void createContent(Composite parent) {
        IType[] abstractFormFields;
        this.m_modelTypeShortList = new HashSet();
        ArrayList<1> elements = new ArrayList<1>();
        elements.add(new ISeparator(){});
        IPrimaryTypeTypeHierarchy formFieldHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iFormField);
        IType[] iTypeArray = abstractFormFields = formFieldHierarchy.getAllSubtypes(this.iFormField, TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_declaringType.getJavaProject()));
        int n = abstractFormFields.length;
        int n2 = 0;
        while (n2 < n) {
            IType formField = iTypeArray[n2];
            if (!TypeUtility.exists((IJavaElement)JdtUtility.getAnnotation((IAnnotatable)formField, (String)ScoutSdkIgnore.class.getName()))) {
                IFormFieldExtension formFieldExtension = FormFieldExtensionPoint.findExtension(formField, 1);
                if (formFieldExtension != null && formFieldExtension.isInShortList()) {
                    this.m_modelTypeShortList.add(formField);
                }
                elements.add(formField);
            }
            ++n2;
        }
        this.m_table = new FilteredTable(parent, 68100);
        this.m_table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FormFieldSelectionWizardPage.this.m_currentSelection != null) {
                    FormFieldSelectionWizardPage.this.m_table.getViewer().update(FormFieldSelectionWizardPage.this.m_currentSelection, new String[]{"label"});
                }
                FormFieldSelectionWizardPage.this.m_currentSelection = null;
                if (!event.getSelection().isEmpty()) {
                    FormFieldSelectionWizardPage.this.m_currentSelection = ((StructuredSelection)event.getSelection()).getFirstElement();
                }
                if (FormFieldSelectionWizardPage.this.m_currentSelection != null) {
                    FormFieldSelectionWizardPage.this.m_table.getViewer().update(FormFieldSelectionWizardPage.this.m_currentSelection, new String[]{"label"});
                }
                FormFieldSelectionWizardPage.this.handleSelection(FormFieldSelectionWizardPage.this.m_currentSelection);
            }
        });
        this.m_table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = selection.getFirstElement();
                }
                FormFieldSelectionWizardPage.this.handleSelection(selectedItem);
                IWizardPage page = FormFieldSelectionWizardPage.this.getNextPage();
                if (page == null) {
                    return;
                }
                IWizardContainer container = FormFieldSelectionWizardPage.this.getWizard().getContainer();
                if (container != null) {
                    container.showPage(page);
                }
            }
        });
        P_ContentProvider provider = new P_ContentProvider(elements.toArray());
        this.m_table.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_table.getViewer().setContentProvider((IContentProvider)provider);
        this.m_table.getViewer().setInput((Object)provider);
        this.m_table.getViewer().setSorter((ViewerSorter)new P_TableSorter());
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData tableData = new GridData(1808);
        tableData.heightHint = 150;
        this.m_table.setLayoutData(tableData);
    }

    private void handleSelection(Object selectedItem) {
        IType formField;
        AbstractFormFieldWizard wizard = null;
        if (selectedItem instanceof IType && (wizard = (AbstractFormFieldWizard)FormFieldExtensionPoint.createNewWizard(formField = (IType)selectedItem)) != null) {
            wizard.initWizard(this.m_declaringType);
            wizard.setSuperType(formField);
        }
        this.m_nextPage = wizard != null ? (AbstractScoutWizardPage)wizard.getPages()[0] : null;
        this.revalidate();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusFieldList());
    }

    private IStatus getStatusFieldList() {
        if (this.m_nextPage == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoFieldSelected"));
        }
        return Status.OK_STATUS;
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    private class P_ContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private Object[] m_elements;

        public P_ContentProvider(Object[] elements) {
            this.m_elements = elements;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_elements;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof ISeparator) {
                    return ScoutSdkUi.getImage("type_separator.gif");
                }
                return ScoutSdkUi.getImage("formField.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                StringBuilder label = new StringBuilder();
                if (element instanceof ISeparator) {
                    return "------------------ more fields ------------------";
                }
                StructuredSelection selection = (StructuredSelection)FormFieldSelectionWizardPage.this.m_table.getViewer().getSelection();
                IType t = (IType)element;
                String typeName = t.getElementName();
                if (typeName.toLowerCase().startsWith("abstract")) {
                    typeName = typeName.substring("abstract".length());
                }
                label.append(typeName);
                if (selection.toList().contains(element)) {
                    label.append(" - ").append(t.getFullyQualifiedName());
                }
                return label.toString();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return "label".equals(property);
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class P_TableSorter
    extends ViewerSorter {
        private P_TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            CompositeObject comp2;
            CompositeObject comp1;
            if (e1 instanceof ISeparator) {
                comp1 = new CompositeObject(new Object[]{2});
            } else {
                IType modelType = (IType)e1;
                comp1 = FormFieldSelectionWizardPage.this.m_modelTypeShortList.contains(modelType) ? new CompositeObject(new Object[]{1, modelType.getElementName(), modelType.getFullyQualifiedName()}) : new CompositeObject(new Object[]{3, modelType.getElementName(), modelType.getFullyQualifiedName()});
            }
            if (e2 instanceof ISeparator) {
                comp2 = new CompositeObject(new Object[]{2});
            } else {
                IType modelType = (IType)e2;
                comp2 = FormFieldSelectionWizardPage.this.m_modelTypeShortList.contains(modelType) ? new CompositeObject(new Object[]{1, modelType.getElementName(), modelType.getFullyQualifiedName()}) : new CompositeObject(new Object[]{3, modelType.getElementName(), modelType.getFullyQualifiedName()});
            }
            return comp1.compareTo(comp2);
        }
    }
}

