/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.util.SourceFormatOperation;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.text.edits.ReplaceEdit;

public class MissingPortTypeInheritanceCommand
extends AbstractExecutableMarkerCommand {
    private IType m_type;
    private IType m_portTypeInterfaceType;
    private String m_markerGroupUUID;

    public MissingPortTypeInheritanceCommand(String markerGroupUUID, IType type, IType portTypeInterfaceType) {
        super("Port type must implement service interface");
        this.m_type = type;
        this.m_portTypeInterfaceType = portTypeInterfaceType;
        this.m_markerGroupUUID = markerGroupUUID;
        this.setSolutionDescription("By using this task, the port type '" + this.m_type.getElementName() + "' is changed to inherit from the service interface '" + this.m_portTypeInterfaceType.getElementName() + "'.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        boolean superInterfaceAvailable = false;
        ISourceRange classNameRange = this.m_type.getNameRange();
        int positionAfterClassName = classNameRange.getOffset() + classNameRange.getLength();
        String source = this.m_type.getCompilationUnit().getBuffer().getContents();
        String sourceAfterClassName = source.substring(positionAfterClassName);
        int insertPosition = -1;
        Pattern pattern = Pattern.compile("(implements)\\s+(.*?)\\s+\\{");
        Matcher matcher = pattern.matcher(sourceAfterClassName);
        if (matcher.find()) {
            insertPosition = matcher.end(1);
            superInterfaceAvailable = true;
        } else {
            pattern = Pattern.compile("\\s+\\{");
            matcher = pattern.matcher(sourceAfterClassName);
            if (matcher.find()) {
                insertPosition = matcher.end() - 1;
            }
        }
        if (insertPosition == -1) {
            throw new CoreException((IStatus)new ScoutStatus("Could not determine insert position for interface declaration in type '" + this.m_type.getElementName() + "'"));
        }
        insertPosition = positionAfterClassName + insertPosition;
        SourceRange interfaceInsertionRange = new SourceRange(insertPosition, 0);
        Document icuDoc = new Document(source);
        String implementsKeyword = null;
        if (!superInterfaceAvailable) {
            implementsKeyword = "implements";
        }
        String replacement = StringUtility.join((String)" ", (Object[])new Object[]{implementsKeyword, this.m_portTypeInterfaceType.getElementName()});
        if (superInterfaceAvailable) {
            replacement = String.valueOf(replacement) + ", ";
        }
        replacement = " " + replacement + " ";
        ReplaceEdit edit = new ReplaceEdit(interfaceInsertionRange.getOffset(), interfaceInsertionRange.getLength(), replacement);
        try {
            edit.apply((IDocument)icuDoc);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new ScoutStatus("Failed to update interface declaration in type '" + this.m_type.getElementName() + "'", (Throwable)e));
        }
        ICompilationUnit icu = this.m_type.getCompilationUnit();
        workingCopyManager.register(icu, monitor);
        SourceFormatOperation sourceFormatOp = new SourceFormatOperation(this.m_type.getJavaProject(), icuDoc, null);
        sourceFormatOp.run(monitor, workingCopyManager);
        icu.getBuffer().setContents(ScoutUtility.cleanLineSeparator((String)icuDoc.get(), (Document)icuDoc));
        JaxWsSdkUtility.createImportDirective(this.m_type, this.m_portTypeInterfaceType);
        workingCopyManager.reconcile(this.m_type.getCompilationUnit(), monitor);
        workingCopyManager.unregister(icu, monitor);
        JaxWsSdkUtility.overrideUnimplementedMethodsAsync(this.m_type);
        JaxWsSdk.getDefault().notifyPageReload(WebServiceProviderNodePage.class, this.m_markerGroupUUID, 1);
    }
}

