/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.part;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.AbstractSinglePageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.scout.sdk.util.IScoutSeverityListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.TypeOpenAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.AuthenticationHandlerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.part.AnnotationProperty;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.ActionPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AnnotationPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AnnotationPropertyTypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.TypePresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPageLoadedListener;
import org.eclipse.scout.sdk.ws.jaxws.util.listener.IPresenterValueChangedListener;
import org.eclipse.swt.layout.GridData;

public class AuthenticationHandlerNodePagePropertyViewPart
extends AbstractSinglePageSectionBasedViewPart {
    public static final String SECTION_ID_LINKS = "section.jaxws.links";
    public static final String SECTION_ID_PROPERTIES = "section.jaxws.properties";
    public static final int PRESENTER_ID_SESSION_FACTORY = 2;
    private IPresenterValueChangedListener m_presenterListener;
    private AnnotationPresenter m_transactionalPresenter;
    private AnnotationPropertyTypePresenter m_sessionFactoryPresenter;
    private P_ScoutSeverityListener m_severityListener;
    private IPageLoadedListener m_pageLoadedListener;
    private IScoutBundle m_bundle;

    protected void init() {
        this.m_bundle = this.getPage().getScoutBundle();
        this.m_presenterListener = new P_PresenterListener();
        this.m_pageLoadedListener = new P_PageLoadedListener();
        this.m_severityListener = new P_ScoutSeverityListener();
        this.getPage().addPageLoadedListener(this.m_pageLoadedListener);
    }

    protected void cleanup() {
        this.getPage().removePageLoadedListener(this.m_pageLoadedListener);
        ScoutSeverityManager.getInstance().removeQualityManagerListener((IScoutSeverityListener)this.m_severityListener);
        super.cleanup();
    }

    public AuthenticationHandlerNodePage getPage() {
        return (AuthenticationHandlerNodePage)super.getPage();
    }

    protected void createSections() {
        this.getForm().setRedraw(true);
        try {
            this.createSection(SECTION_ID_LINKS, Texts.get("ConsiderLinks"));
            this.createSection(SECTION_ID_PROPERTIES, Texts.get("Properties"));
            if (this.getPage().getType().isBinary()) {
                this.getSection(SECTION_ID_PROPERTIES).setText(String.valueOf(Texts.get("Properties")) + " (" + Texts.get("readOnlyBecauseBinaryFile") + ")");
            }
            TypeOpenAction action = new TypeOpenAction();
            action.init(this.getPage().getType());
            ActionPresenter actionPresenter = new ActionPresenter(this.getSection(SECTION_ID_LINKS).getSectionClient(), action, this.getFormToolkit());
            this.applyLayoutData(actionPresenter);
            this.m_transactionalPresenter = new AnnotationPresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit(), this.getPage().getType(), TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction"));
            this.m_transactionalPresenter.setLabel(Texts.get("Transactional"));
            this.applyLayoutData(this.m_transactionalPresenter);
            this.m_sessionFactoryPresenter = new AnnotationPropertyTypePresenter(this.getSection(SECTION_ID_PROPERTIES).getSectionClient(), this.getFormToolkit());
            this.m_sessionFactoryPresenter.setPresenterId(2);
            this.m_sessionFactoryPresenter.setLinkAlwaysEnabled(true);
            this.m_sessionFactoryPresenter.setLabel(Texts.get("SessionFactory"));
            this.m_sessionFactoryPresenter.setAcceptNullValue(true);
            this.m_sessionFactoryPresenter.setBundle(this.m_bundle);
            this.m_sessionFactoryPresenter.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction"));
            this.m_sessionFactoryPresenter.setProperty("sessionFactory");
            this.m_sessionFactoryPresenter.setDefaultPackageNameNewType(JaxWsSdkUtility.getRecommendedSessionPackageName(this.m_bundle));
            this.m_sessionFactoryPresenter.setSearchScopeFactory(this.createSubClassesSearchScopeFactory(TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")));
            this.m_sessionFactoryPresenter.setAllowChangeOfInterfaceType(true);
            this.m_sessionFactoryPresenter.setInterfaceTypes(new IType[]{TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory")});
            this.m_sessionFactoryPresenter.addValueChangedListener(this.m_presenterListener);
            this.applyLayoutData(this.m_sessionFactoryPresenter);
            this.updatePresenterValues();
        }
        finally {
            this.getForm().setRedraw(true);
        }
        super.createSections();
    }

    private void updatePresenterValues() {
        this.m_transactionalPresenter.updatePresenter();
        IAnnotation scoutTransactionAnnotation = (IAnnotation)this.m_transactionalPresenter.getValue();
        boolean transactional = scoutTransactionAnnotation != null;
        GridData gd = (GridData)this.m_sessionFactoryPresenter.getContainer().getLayoutData();
        gd.exclude = !transactional;
        this.m_sessionFactoryPresenter.getContainer().setVisible(transactional);
        JaxWsSdkUtility.doLayout(this.m_sessionFactoryPresenter.getContainer());
        JaxWsSdkUtility.doLayoutSection(this.getSection(SECTION_ID_PROPERTIES));
        if (scoutTransactionAnnotation != null) {
            AnnotationProperty propertyValue = JaxWsSdkUtility.parseAnnotationTypeValue(this.getPage().getType(), scoutTransactionAnnotation, "sessionFactory");
            this.m_sessionFactoryPresenter.setInput(propertyValue.getFullyQualifiedName());
            this.m_sessionFactoryPresenter.setDeclaringType(this.getPage().getType());
            this.m_sessionFactoryPresenter.setResetLinkVisible(!propertyValue.isInherited());
            this.m_sessionFactoryPresenter.setBoldLabelText(!propertyValue.isInherited());
            this.m_sessionFactoryPresenter.updateInfo();
        }
        if (this.getPage().getType().isBinary()) {
            this.m_transactionalPresenter.setEnabled(false);
            this.m_sessionFactoryPresenter.setEnabled(false);
        }
    }

    private void applyLayoutData(AbstractPresenter presenter) {
        GridData layoutData = new GridData(768);
        presenter.getContainer().setLayoutData((Object)layoutData);
    }

    private TypePresenter.ISearchJavaSearchScopeFactory createSubClassesSearchScopeFactory(final IType superType) {
        return new TypePresenter.ISearchJavaSearchScopeFactory(){

            @Override
            public IJavaSearchScope create() {
                IType[] subTypes = JaxWsSdkUtility.getJdtSubTypes(AuthenticationHandlerNodePagePropertyViewPart.this.m_bundle, superType.getFullyQualifiedName(), false, false, true, false);
                return SearchEngine.createJavaSearchScope((IJavaElement[])subTypes);
            }
        };
    }

    private class P_PageLoadedListener
    implements IPageLoadedListener {
        private P_PageLoadedListener() {
        }

        @Override
        public void pageLoaded() {
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AuthenticationHandlerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                        return;
                    }
                    AuthenticationHandlerNodePagePropertyViewPart.this.updatePresenterValues();
                }
            });
        }
    }

    private final class P_PresenterListener
    implements IPresenterValueChangedListener {
        private P_PresenterListener() {
        }

        @Override
        public void propertyChanged(int presenterId, Object value) {
            switch (presenterId) {
                case 2: {
                    IType type = AuthenticationHandlerNodePagePropertyViewPart.this.getPage().getType();
                    if (!TypeUtility.exists((IJavaElement)type)) {
                        return;
                    }
                    String factoryFullyQualifiedName = (String)value;
                    if (!TypeUtility.existsType((String)factoryFullyQualifiedName)) {
                        return;
                    }
                    IType factoryType = TypeUtility.getType((String)factoryFullyQualifiedName);
                    AnnotationUpdateOperation op = new AnnotationUpdateOperation();
                    op.setDeclaringType(type);
                    op.setAnnotationType(TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction"));
                    op.addTypeProperty("sessionFactory", factoryType);
                    new OperationJob(new IOperation[]{op}).schedule();
                }
            }
        }
    }

    private class P_ScoutSeverityListener
    implements IScoutSeverityListener {
        private P_ScoutSeverityListener() {
        }

        public void severityChanged(IResource resource) {
            if (AuthenticationHandlerNodePagePropertyViewPart.this.getPage().getType() != null && resource == AuthenticationHandlerNodePagePropertyViewPart.this.getPage().getType().getResource()) {
                ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AuthenticationHandlerNodePagePropertyViewPart.this.getForm().isDisposed()) {
                            return;
                        }
                        AuthenticationHandlerNodePagePropertyViewPart.this.m_sessionFactoryPresenter.updateInfo();
                    }
                });
            }
        }
    }
}

