/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.ide;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionProcessor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionProposal;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.DynamicAcceleoModule;
import org.eclipse.sirius.common.acceleo.mtl.ide.AcceleoContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;

public class AcceleoCompletionService {
    private final Collection<URI> dependencies;
    private final Set<String> ignoreList;
    private final ResourceSet resourceSet;
    private final String moduleContent;

    public AcceleoCompletionService(String moduleContent, DynamicAcceleoModule module, Collection<URI> dependencies) {
        this.moduleContent = moduleContent;
        this.ignoreList = module.getGeneratedQueryNames();
        this.resourceSet = module.getResourceSet();
        this.dependencies = dependencies;
    }

    public synchronized List<ContentProposal> getProposals(String contextText, int cursorPosition, String moduleElementName) {
        ArrayList proposals = Lists.newArrayList();
        AcceleoSourceContent src = new AcceleoSourceContent(){
            {
                this.syntaxHelpResourceSet = new ResourceSetImpl();
                this.syntaxHelpResourceSet.setResourceFactoryRegistry(AcceleoCompletionService.this.resourceSet.getResourceFactoryRegistry());
                for (Resource res : AcceleoCompletionService.this.resourceSet.getResources()) {
                    Resource copy = this.syntaxHelpResourceSet.createResource(res.getURI());
                    for (EObject root : res.getContents()) {
                        copy.getContents().add((Object)EcoreUtil.copy((EObject)root));
                    }
                    this.syntaxHelpResourceSet.getResources().add((Object)copy);
                }
            }

            public List<URI> getAccessibleOutputFiles() {
                return AcceleoCompletionService.this.getDeclaredImports();
            }
        };
        src.init(new StringBuffer(this.moduleContent));
        String expression = contextText.substring(1);
        int position = -1;
        int queryIndex = this.moduleContent.indexOf(String.valueOf(moduleElementName) + '(');
        if (queryIndex > 0) {
            position = this.moduleContent.indexOf(expression, queryIndex);
        }
        if (position > 0) {
            ICompletionProposal[] props;
            AcceleoCompletionProcessor processor = new AcceleoCompletionProcessor(src);
            ICompletionProposal[] iCompletionProposalArray = props = processor.computeCompletionProposals(null, position += cursorPosition - 1);
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal prop = iCompletionProposalArray[n2];
                String displayString = prop.getDisplayString();
                if (!displayString.contains("(") || !this.ignoreList.contains(displayString.substring(0, displayString.indexOf("(")))) {
                    if (prop instanceof AcceleoCompletionProposal) {
                        proposals.add(new AcceleoContentProposal(this.getCleanedProposalText(((AcceleoCompletionProposal)prop).getReplacementString()), prop.getDisplayString(), this.getCleanedAdditionalText(prop.getAdditionalProposalInfo()), prop));
                    } else {
                        Document doc = new Document(this.moduleContent);
                        String end = doc.get().substring(position, this.moduleContent.indexOf(93, position) + 1);
                        prop.apply((IDocument)doc);
                        String completedText = doc.get();
                        String proposal = completedText.substring(position, completedText.indexOf(end, position));
                        AcceleoContentProposal cp = new AcceleoContentProposal(this.getCleanedProposalText(proposal), displayString, this.getCleanedAdditionalText(prop.getAdditionalProposalInfo()), prop);
                        proposals.add(cp);
                    }
                }
                ++n2;
            }
        }
        return proposals;
    }

    private String getCleanedProposalText(String s) {
        return s.replaceAll("\\$\\{[^\\}]+\\}", "");
    }

    private String getCleanedAdditionalText(String s) {
        return s.replaceAll("<br/>", "\n").replaceAll("<[^>]+>", "");
    }

    private List<URI> getDeclaredImports() {
        ArrayList accessibleOutputFiles = Lists.newArrayList();
        if (this.dependencies != null) {
            Iterables.addAll((Collection)accessibleOutputFiles, (Iterable)Iterables.filter(this.dependencies, (Predicate)Predicates.notNull()));
        }
        return accessibleOutputFiles;
    }
}

