/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.navigator;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingItem;

public class GroupingContentProvider
implements ITreeContentProvider {
    private final ITreeContentProvider delegateTreeContentProvider;

    public GroupingContentProvider(ITreeContentProvider delegateTreeContentProvider) {
        this.delegateTreeContentProvider = delegateTreeContentProvider;
    }

    public int getGroupSize() {
        return SiriusTransPlugin.getPlugin().getPreferenceStore().getInt("GROUP_SIZE");
    }

    public boolean isGroupEnabled() {
        return SiriusTransPlugin.getPlugin().getPreferenceStore().getBoolean("GROUP_ENABLE");
    }

    public boolean isGroupByContainingFeature() {
        return SiriusTransPlugin.getPlugin().getPreferenceStore().getBoolean("GROUP_BY_CONTAINING_FEATURE");
    }

    public int getTriggerSize() {
        int groupSize = SiriusTransPlugin.getPlugin().getPreferenceStore().getInt("GROUP_SIZE");
        int groupTrigger = SiriusTransPlugin.getPlugin().getPreferenceStore().getInt("GROUP_TRIGGER");
        if (groupTrigger >= groupSize) {
            return groupTrigger;
        }
        return groupSize;
    }

    public void dispose() {
        this.delegateTreeContentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.delegateTreeContentProvider.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object parentElement) {
        if (parentElement instanceof GroupingItem) {
            return this.getChildren(parentElement);
        }
        Object[] elements = this.delegateTreeContentProvider.getElements(parentElement);
        return this.groupChildren(parentElement, elements);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GroupingItem) {
            return ((GroupingItem)parentElement).getChildren().toArray();
        }
        Object[] children = this.delegateTreeContentProvider.getChildren(parentElement);
        return this.groupChildren(parentElement, children);
    }

    public Object getParent(Object element) {
        if (element instanceof GroupingItem) {
            GroupingItem groupItem = (GroupingItem)element;
            return groupItem.getParent();
        }
        return this.delegateTreeContentProvider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return element instanceof GroupingItem || this.delegateTreeContentProvider.hasChildren(element);
    }

    protected Object[] groupChildren(Object parent, Object[] children) {
        Object[] result = children;
        if (this.isGroupEnabled()) {
            result = this.isGroupByContainingFeature() ? this.groupChildrenByContainingFeature(parent, children) : this.defaultGroupChildren(parent, children);
        }
        return result;
    }

    private Object[] groupChildrenByContainingFeature(Object parent, Object[] children) {
        LinkedListMultimap<Object, Object> childrenContainingMapping = this.buildChildrenContainerMapping(children);
        int groupSize = this.getGroupSize();
        ArrayList<GroupingItem> result = new ArrayList<GroupingItem>();
        for (Object structuralFeature : childrenContainingMapping.keySet()) {
            int currentOffset = 0;
            List indexedChildren = childrenContainingMapping.get(structuralFeature);
            if (indexedChildren.size() > this.getTriggerSize()) {
                List partition = Lists.partition((List)indexedChildren, (int)groupSize);
                if (partition.size() <= 0) continue;
                if (partition.size() > 1) {
                    for (List partItem : partition) {
                        GroupingItem currentGroup = structuralFeature instanceof EStructuralFeature ? new GroupingItem(currentOffset, parent, new ArrayList<Object>(partItem), " " + ((EStructuralFeature)structuralFeature).getName()) : new GroupingItem(currentOffset, parent, new ArrayList<Object>(partItem));
                        result.add(currentGroup);
                        currentOffset += partItem.size();
                    }
                    continue;
                }
                for (List partItem : partition) {
                    result.addAll(partItem);
                }
                continue;
            }
            result.addAll(indexedChildren);
        }
        return result.toArray();
    }

    private LinkedListMultimap<Object, Object> buildChildrenContainerMapping(Object[] children) {
        LinkedListMultimap childrenContainingMapping = LinkedListMultimap.create();
        Object noContainingFeature = new Object();
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object wrappedObject;
            Object child = objectArray[n2];
            Object containingFeature = child instanceof EObject ? ((EObject)child).eContainingFeature() : (child instanceof TreeItemWrapper ? ((wrappedObject = ((TreeItemWrapper)child).getWrappedObject()) instanceof EObject ? ((EObject)wrappedObject).eContainingFeature() : noContainingFeature) : noContainingFeature);
            childrenContainingMapping.put(containingFeature, child);
            ++n2;
        }
        return childrenContainingMapping;
    }

    private Object[] defaultGroupChildren(Object parent, Object[] children) {
        if (children.length > this.getTriggerSize()) {
            int groupSize = this.getGroupSize();
            List partition = Lists.partition(Arrays.asList(children), (int)groupSize);
            Object[] result = new Object[partition.size()];
            int indexOfResult = 0;
            for (List indexedChildren : partition) {
                int currentOffset = indexOfResult * groupSize;
                GroupingItem currentGroup = new GroupingItem(currentOffset, parent, indexedChildren);
                result[indexOfResult] = currentGroup;
                ++indexOfResult;
            }
            return result;
        }
        return children;
    }

    public ITreeContentProvider getDelegateTreeContentProvider() {
        return this.delegateTreeContentProvider;
    }
}

