/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.business.internal.diagramtype;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.sequence.description.EventMapping;
import org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.sequence.description.tool.util.ToolSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;

public class SequenceToolInterpretedExpressionSwitch
extends ToolSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;
    private IInterpretedExpressionTargetSwitch globalSwitch;

    public SequenceToolInterpretedExpressionSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultInterpretedExpressionTargetSwitch) {
        this.feature = feature;
        this.globalSwitch = defaultInterpretedExpressionTargetSwitch;
    }

    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        Set targets = Collections.emptySet();
        return Options.newSome(targets);
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    private int getFeatureId(EClass eClass) {
        int featureID = -1;
        if (this.considerFeature && this.feature != null) {
            featureID = eClass.getFeatureID(this.feature);
        }
        return featureID;
    }

    protected EObject getFirstContextChangingContainer(EObject element) {
        EObject container = element.eContainer();
        while (!(container instanceof RepresentationDescription || container instanceof ChangeContext || container instanceof AbstractToolDescription || container instanceof RepresentationElementMapping)) {
            container = container.eContainer();
        }
        return container;
    }

    public Option<Collection<String>> caseMessageCreationTool(MessageCreationTool object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getMessageCreationTool())) {
            case -1: 
            case 3: 
            case 15: {
                LinkedHashSet targets = Sets.newLinkedHashSet();
                for (RepresentationElementMapping correspondingMapping : Iterables.concat((Iterable)object.getEdgeMappings(), (Iterable)object.getExtraSourceMappings())) {
                    Option targetsFromMapping = this.globalSwitch.doSwitch((EObject)correspondingMapping, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseReorderTool(ReorderTool object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getReorderTool())) {
            case -1: 
            case 3: {
                LinkedHashSet targets = Sets.newLinkedHashSet();
                for (EventMapping correspondingMapping : object.getMappings()) {
                    Option targetsFromMapping = this.globalSwitch.doSwitch((EObject)correspondingMapping, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseInstanceRoleReorderTool(InstanceRoleReorderTool object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getInstanceRoleReorderTool())) {
            case -1: 
            case 3: {
                LinkedHashSet targets = Sets.newLinkedHashSet();
                for (InstanceRoleMapping correspondingMapping : object.getMappings()) {
                    Option targetsFromMapping = this.globalSwitch.doSwitch((EObject)correspondingMapping, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }
}

