/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractBorderedDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramContainerEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode4EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.NonResizableAndNonDuplicableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AlphaDropShadowBorder;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleAwareClippingStrategy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.OneLineMarginBorder;

public abstract class AbstractDiagramElementContainerEditPart
extends AbstractBorderedDiagramElementEditPart
implements IAbstractDiagramNodeEditPart {
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private IFigure backgroundFigure;
    private Dimension intialDefaultSize;

    public AbstractDiagramElementContainerEditPart(View view) {
        super(view);
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null && (element = ((IGraphicalEditPart)styleEditPart).resolveSemanticElement()) != null && element.eResource() != null) {
            styleEditPart.refresh();
        }
        if ((element = this.resolveSemanticElement()) != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        super.handleNotificationEvent(notification);
        AbstractDiagramNodeEditPartOperation.handleNotificationEvent(this, notification);
        this.handleDefaultSizeNotification(notification);
    }

    private void handleDefaultSizeNotification(Notification notification) {
        IFigure figure;
        Object feature;
        if (!notification.isTouch() && ((feature = notification.getFeature()).equals(DiagramPackage.eINSTANCE.getDDiagramElementContainer_Width()) || feature.equals(DiagramPackage.eINSTANCE.getDDiagramElementContainer_Height())) && (figure = this.getMainFigure()) instanceof DefaultSizeNodeFigure && !this.isRegion()) {
            this.setFigureDefaultSize((DefaultSizeNodeFigure)figure);
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        AbstractDiagramNodeEditPartOperation.createDefaultEditPolicies(this);
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SiriusGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public void refresh() {
        EObject element = this.resolveSemanticElement();
        if (element != null && this.getMetamodelType().isInstance(element)) {
            super.refresh();
            List children = this.getChildren();
            int i = 0;
            while (i < children.size()) {
                EditPart editPart = (EditPart)children.get(i);
                editPart.refresh();
                ++i;
            }
        }
    }

    protected List getModelChildren() {
        ArrayList modelChildren = Lists.newArrayList((Iterable)super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        return modelChildren;
    }

    public IFigure getBackgroundFigure() {
        return this.backgroundFigure;
    }

    public void createBackgroundFigure() {
        this.backgroundFigure = DiagramContainerEditPartOperation.createBackgroundFigure(this);
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        if (figure instanceof DefaultSizeNodeFigure && this.isRegion()) {
            DefaultSizeNodeFigure dsnf = (DefaultSizeNodeFigure)figure;
            Dimension d = new Dimension(100, 60);
            dsnf.setDefaultSize(d);
            dsnf.setMinimumSize(d);
        } else if (figure instanceof DefaultSizeNodeFigure) {
            this.setFigureDefaultSize((DefaultSizeNodeFigure)figure);
        }
        figure.setLayoutManager((LayoutManager)new StackLayout());
        this.createBackgroundFigure();
        if (this.getBackgroundFigure() != null) {
            figure.add(this.getBackgroundFigure());
        }
        this.primaryShape = this.createNodeShape();
        this.addDropShadow(figure, this.primaryShape);
        this.configureBorder(this.primaryShape);
        figure.add(this.primaryShape);
        this.contentPane = this.setupContentPane(this.primaryShape);
        return figure;
    }

    private void setFigureDefaultSize(DefaultSizeNodeFigure figure) {
        EObject element;
        Object model;
        if (this.intialDefaultSize == null) {
            this.intialDefaultSize = figure.getDefaultSize().getCopy();
        }
        if ((model = this.getModel()) instanceof Node && (element = ((Node)model).getElement()) instanceof DDiagramElementContainer) {
            Integer dDiagramElementContainerWidth = ((DDiagramElementContainer)element).getWidth();
            Integer dDiagramElementContainerHeight = ((DDiagramElementContainer)element).getHeight();
            int widthToApplied = this.intialDefaultSize.width;
            int heightToApplied = this.intialDefaultSize.height;
            if (dDiagramElementContainerWidth != null && dDiagramElementContainerWidth > 0) {
                int tempWidthToApplied;
                widthToApplied = tempWidthToApplied = dDiagramElementContainerWidth * 10;
            }
            if (dDiagramElementContainerHeight != null && dDiagramElementContainerHeight > 0) {
                int tempHeightToApplied;
                heightToApplied = tempHeightToApplied = dDiagramElementContainerHeight * 10;
            }
            DefaultSizeNodeFigure dsnf = figure;
            Dimension d = new Dimension(widthToApplied, heightToApplied);
            dsnf.setDefaultSize(d);
        }
    }

    protected void configureBorder(IFigure shapeFigure) {
        if (this.isRegion() && shapeFigure != null) {
            if (shapeFigure instanceof Shape) {
                ((Shape)shapeFigure).setOutline(false);
            }
            if (this.isFirstRegionPart()) {
                shapeFigure.setBorder((Border)new MarginBorder(5, 0, 0, 0));
            } else {
                OneLineMarginBorder oneLineBorder = new OneLineMarginBorder(8);
                shapeFigure.setBorder((Border)oneLineBorder);
                oneLineBorder.setMargin(5, 0, 0, 0);
                if (this.getParentStackDirection() == 24) {
                    oneLineBorder.setPosition(1);
                }
            }
        }
    }

    private boolean isFirstRegionPart() {
        EditPart parent = this.getParent();
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart) {
            Iterable regionParts = Iterables.filter((Iterable)parent.getChildren(), AbstractDiagramElementContainerEditPart.class);
            return !Iterables.isEmpty((Iterable)regionParts) && regionParts.iterator().next() == this;
        }
        return false;
    }

    private int getParentStackDirection() {
        EObject element;
        int direction = 0;
        EditPart parent = this.getParent();
        if (parent instanceof AbstractDNodeContainerCompartmentEditPart && (element = ((AbstractDNodeContainerCompartmentEditPart)parent).resolveSemanticElement()) instanceof DNodeContainer) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery((DNodeContainer)element);
            if (query.isVerticalStackContainer()) {
                direction = 5;
            } else if (query.isHorizontaltackContainer()) {
                direction = 24;
            }
        }
        return direction;
    }

    public boolean isRegion() {
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        if (ddiagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)ddiagramElement;
            return new DDiagramElementContainerExperimentalQuery(ddec).isRegion();
        }
        return false;
    }

    protected void refreshVisuals() {
        boolean firstRegion;
        if (this.primaryShape != null && ((firstRegion = this.isFirstRegionPart()) && this.primaryShape.getBorder() instanceof LineBorder || !firstRegion && this.primaryShape.getBorder() instanceof MarginBorder)) {
            this.configureBorder(this.primaryShape);
        }
        super.refreshVisuals();
    }

    protected abstract NodeFigure createNodePlate();

    protected abstract IFigure createNodeShape();

    protected NodeFigure createNodeFigure() {
        BorderedNodeFigure nodeFigure = new BorderedNodeFigure((IFigure)this.createMainFigure());
        nodeFigure.getBorderItemContainer().add((IFigure)new FoldingToggleImageFigure(this));
        nodeFigure.getBorderItemContainer().setClippingStrategy((IClippingStrategy)new FoldingToggleAwareClippingStrategy());
        return nodeFigure;
    }

    protected void addDropShadow(NodeFigure figure, IFigure shape) {
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        boolean needShadowBorder = true;
        if (ddiagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)ddiagramElement;
            boolean bl = needShadowBorder = !new DDiagramElementContainerExperimentalQuery(ddec).isRegion() && !(ddec.getOwnedStyle() instanceof WorkspaceImage);
        }
        if (needShadowBorder) {
            AlphaDropShadowBorder shadowBorder = new AlphaDropShadowBorder(shape);
            figure.setBorder((Border)shadowBorder);
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("sourceConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("sourceConnectionAnchorLocation");
                return this.getNodeFigure().getSourceConnectionAnchorAt(realLocation);
            }
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("targetConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("targetConnectionAnchorLocation");
                return this.getNodeFigure().getTargetConnectionAnchorAt(realLocation);
            }
        }
        return super.getTargetConnectionAnchor(request);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        IFigure pane = this.getContentPaneFor((IGraphicalEditPart)child);
        if (childFigure.getParent() != pane) {
            return;
        }
        super.setLayoutConstraint(child, childFigure, constraint);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof DNode4EditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((DNode4EditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof DNode4EditPart && ((DNode4EditPart)childEditPart).resolveSemanticElement() instanceof DDiagramElement) {
            IBorderItemLocator locator = this.createBorderItemLocator(this.getMainFigure(), (DDiagramElement)((DNode4EditPart)childEditPart).resolveSemanticElement());
            Point parentOrigin = this.getBorderedFigure().getHandleBounds().getTopLeft().getCopy();
            Point negateParentOrigin = parentOrigin.getNegated();
            Rectangle constraint = ((DNode4EditPart)childEditPart).getFigure().getBounds().getCopy();
            Point newTopLeft = constraint.getTopLeft().getCopy().translate(negateParentOrigin);
            locator.setConstraint(new Rectangle(newTopLeft.x, newTopLeft.y, constraint.width, constraint.height));
            this.getBorderedFigure().getBorderItemContainer().add(((DNode4EditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    public void forceFigureAutosize() {
        Dimension size = new Dimension(-1, -1);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public Rectangle getAutosizedDimensions() {
        ((GraphicalEditPart)this.getParent()).getFigure().validate();
        return this.getFigure().getBounds();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.sirius.diagram.ui.tools.api.policies.LayoutEditPolicy lep = new org.eclipse.sirius.diagram.ui.tools.api.policies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof AbstractBorderItemEditPart) {
                    return ((AbstractBorderItemEditPart)child).getPrimaryDragEditPolicy();
                }
                Object result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableAndNonDuplicableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            public Command getCommand(Request request) {
                Command command;
                if ("resize children".equals(request.getType()) && request instanceof ChangeBoundsRequest && (command = AbstractDiagramElementContainerEditPart.this.getResizeBorderItemCommand((ChangeBoundsRequest)request)) != null) {
                    return command;
                }
                return super.getCommand(request);
            }
        };
        return lep;
    }

    protected Command getResizeBorderItemCommand(ChangeBoundsRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid && this.getMetamodelType().isInstance(this.resolveSemanticElement())) {
            for (Object next : request.getEditParts()) {
                DNode viewNode;
                boolean collapsed;
                IGraphicalEditPart graphicalEditPart;
                EObject semantic;
                if (!(next instanceof IGraphicalEditPart) || !((semantic = (graphicalEditPart = (IGraphicalEditPart)next).resolveSemanticElement()) instanceof DNode)) continue;
                Dimension dimension = new Dimension();
                Point position = new Point();
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Size) {
                    Size size = (Size)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    dimension.width = size.getWidth();
                    dimension.height = size.getHeight();
                }
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Location) {
                    Location location = (Location)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    position.x = location.getX();
                    position.y = location.getY();
                }
                if (!((collapsed = new DDiagramElementQuery((DDiagramElement)(viewNode = (DNode)semantic)).isIndirectlyCollapsed()) || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.NORTH_SOUTH_LITERAL)) {
                    dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 1: 
                        case 9: 
                        case 17: {
                            position.y = (int)((double)position.y - (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                if (!(collapsed || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.EAST_WEST_LITERAL)) {
                    dimension.width = (int)((double)dimension.width + (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 8: 
                        case 9: 
                        case 12: {
                            position.x = (int)((double)position.x - (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "Resize", (IAdaptable)new EObjectAdapter((EObject)graphicalEditPart.getNotationView()), new Rectangle(position, dimension));
                cmd = new ICommandProxy((ICommand)setBoundsCommand);
            }
        }
        return cmd;
    }
}

