/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramContainerEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramListEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;

public abstract class AbstractDiagramListEditPart
extends AbstractDiagramElementContainerEditPart
implements IDiagramListEditPart {
    public AbstractDiagramListEditPart(View view) {
        super(view);
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNodeList.class;
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        DiagramListEditPartOperation.handleNotificationEvent(this, notification);
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        DiagramListEditPartOperation.refreshForegroundColor(this);
    }

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
        DiagramListEditPartOperation.refreshBackgroundColor(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramListEditPartOperation.refreshFont(this);
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramListEditPartOperation.refreshVisuals(this);
    }

    public Command getCommand(Request request) {
        UnexecutableCommand result = null;
        RequestQuery requestQuery = new RequestQuery(request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            result = UnexecutableCommand.INSTANCE;
        } else if ("paste".equals(request.getType())) {
            for (ListCompartmentEditPart lcep : Iterables.filter((Iterable)this.children, ListCompartmentEditPart.class)) {
                result = lcep.getCommand(request);
            }
        } else {
            Command cmd = CommonEditPartOperation.appendSelectionCommand(super.getCommand(request), (GraphicalEditPart)this);
            return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        if (result == null) {
            result = super.getCommand(request);
        }
        return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, (Command)result);
    }

    public void reInitFigure() {
        IFigure mainFigure = ((BorderedNodeFigure)this.getFigure()).getMainFigure();
        ArrayList prevChildren = new ArrayList(mainFigure.getChildren());
        ResizableCompartmentFigure compartment = null;
        SiriusWrapLabel wrapLabel = null;
        NodeFigure tmpFigure = this.createMainFigure();
        for (IFigure object : prevChildren) {
            if (object instanceof ViewNodeContainerFigureDesc) {
                for (Object object2 : ((ViewNodeContainerFigureDesc)object).getChildren()) {
                    if (object2 instanceof SiriusWrapLabel) {
                        wrapLabel = (SiriusWrapLabel)((Object)object2);
                        continue;
                    }
                    if (!(object2 instanceof ResizableCompartmentFigure)) continue;
                    compartment = (ResizableCompartmentFigure)object2;
                }
            }
            mainFigure.remove(object);
        }
        Object[] tmpChildren = tmpFigure.getChildren().toArray();
        int i = 0;
        while (i < tmpChildren.length) {
            if (tmpChildren[i] instanceof ViewNodeContainerFigureDesc) {
                ViewNodeContainerFigureDesc figure = (ViewNodeContainerFigureDesc)tmpChildren[i];
                if (wrapLabel != null) {
                    for (IFigure child : new ArrayList(figure.getChildren())) {
                        if (!(child instanceof SiriusWrapLabel)) continue;
                        figure.remove(child);
                    }
                    figure.add((IFigure)wrapLabel);
                }
                figure.add((IFigure)compartment);
            }
            mainFigure.add((IFigure)tmpChildren[i], i);
            ++i;
        }
    }

    public DragTracker getDragTracker(Request request) {
        return new NoCopyDragEditPartsTrackerEx((EditPart)this);
    }

    public ViewNodeContainerFigureDesc getPrimaryFigure() {
        return this.getPrimaryShape();
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListItemSemanticEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    @Override
    public ViewNodeContainerFigureDesc getPrimaryShape() {
        return (ViewNodeContainerFigureDesc)this.primaryShape;
    }

    @Override
    protected IFigure createNodeShape() {
        return new GradientRoundedRectangle(DiagramContainerEditPartOperation.getCornerDimension(this), DiagramContainerEditPartOperation.getBackgroundStyle(this));
    }

    @Override
    protected NodeFigure createNodePlate() {
        return new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
    }
}

