/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.Direction;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.DirectionUtil;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.handles.BendpointMoveHandle;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.handles.BendpointRotateHandle;
import org.eclipse.sirius.diagram.ui.graphical.edit.part.specific.BracketEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;

public class BracketBendpointEditPolicy
extends BendpointEditPolicy {
    public static final String MOVE_COMMAND_LABEL = "Move bracket connection";
    public static final String ROTATE_COMMAND_LABEL = "Rotate bracket connection";
    private static final Color GRAY = new Color(null, 200, 200, 200);
    private IFigure feedbackFigure;
    private BracketEdgeEditPart bracketEdgeEditPart;

    public BracketBendpointEditPolicy(BracketEdgeEditPart bracketEdgeEditPart) {
        this.bracketEdgeEditPart = bracketEdgeEditPart;
    }

    protected List createSelectionHandles() {
        ArrayList<Object> selectionHandles = new ArrayList<Object>();
        selectionHandles.add((Object)new BendpointMoveHandle(this.bracketEdgeEditPart, this.getCursor()));
        selectionHandles.add((Object)new BendpointRotateHandle(this.bracketEdgeEditPart, 2));
        selectionHandles.add((Object)new BendpointRotateHandle(this.bracketEdgeEditPart, 3));
        return selectionHandles;
    }

    private Cursor getCursor() {
        Cursor cursor = null;
        Direction currentDirection = DirectionUtil.getDirection(this.getConnection());
        switch (currentDirection) {
            case LEFT: 
            case RIGHT: {
                cursor = Cursors.SIZEWE;
                break;
            }
            default: {
                cursor = Cursors.SIZENS;
            }
        }
        PointList points = this.getConnection().getPoints();
        if (points.size() == 2) {
            if (cursor == Cursors.SIZEWE) {
                cursor = Cursors.SIZENS;
            } else if (cursor == Cursors.SIZENS) {
                cursor = Cursors.SIZEWE;
            }
        }
        return cursor;
    }

    public org.eclipse.gef.commands.Command getCommand(Request request) {
        org.eclipse.gef.commands.Command command = null;
        if (request instanceof BendpointRequest) {
            BendpointRequest bendpointRequest = (BendpointRequest)request;
            if ("move bendpoint".equals(request.getType())) {
                command = this.getMoveBendpointCommand(bendpointRequest);
            } else if ("rotateBendpoint".equals(request.getType())) {
                command = this.getRotateBendpointCommand(bendpointRequest);
            }
        } else {
            command = super.getCommand(request);
        }
        return command;
    }

    protected org.eclipse.gef.commands.Command getMoveBendpointCommand(BendpointRequest request) {
        Command result = this.getUpdateGMFBendpointsCommand(request);
        CompoundCommand compoundCommand = new CompoundCommand(MOVE_COMMAND_LABEL);
        compoundCommand.append(result);
        return new ICommandProxy((ICommand)new GMFCommandWrapper(this.bracketEdgeEditPart.getEditingDomain(), (Command)compoundCommand));
    }

    protected org.eclipse.gef.commands.Command getRotateBendpointCommand(BendpointRequest request) {
        Command result = this.getUpdateGMFBendpointsCommand(request);
        CompoundCommand compoundCommand = new CompoundCommand(ROTATE_COMMAND_LABEL);
        compoundCommand.append(result);
        return new ICommandProxy((ICommand)new GMFCommandWrapper(this.bracketEdgeEditPart.getEditingDomain(), (Command)compoundCommand));
    }

    private Command getUpdateGMFBendpointsCommand(BendpointRequest request) {
        BracketConnectionQuery bracketFigureQuery = new BracketConnectionQuery(request, this.getConnection());
        PointList newPointList = bracketFigureQuery.getNewPointList();
        TransactionalEditingDomain domain = this.bracketEdgeEditPart.getEditingDomain();
        Edge edge = (Edge)this.bracketEdgeEditPart.getModel();
        List<RelativeBendpoint> gmfRelativeBendpointsFromPointList = bracketFigureQuery.getGMFRelativeBendpoints(newPointList);
        Command updateGMFBendpointsCmd = SetCommand.create((EditingDomain)domain, (Object)edge.getBendpoints(), (Object)NotationPackage.Literals.RELATIVE_BENDPOINTS__POINTS, gmfRelativeBendpointsFromPointList);
        return updateGMFBendpointsCmd;
    }

    protected org.eclipse.gef.commands.Command getCreateBendpointCommand(BendpointRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    protected org.eclipse.gef.commands.Command getDeleteBendpointCommand(BendpointRequest request) {
        return UnexecutableCommand.INSTANCE;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof BendpointRequest) {
            BendpointRequest bendpointRequest = (BendpointRequest)request;
            if ("move bendpoint".equals(request.getType())) {
                this.showMoveLineSegFeedback(bendpointRequest);
            } else if ("rotateBendpoint".equals(request.getType())) {
                this.showRotateLineSegFeedback(bendpointRequest);
            }
        }
    }

    private void showMoveLineSegFeedback(BendpointRequest request) {
        this.showLineSegFeedback(request);
    }

    private void showRotateLineSegFeedback(BendpointRequest request) {
        this.showLineSegFeedback(request);
    }

    public void showLineSegFeedback(BendpointRequest request) {
        BracketConnectionQuery bracketConnectionQuery = new BracketConnectionQuery(request, this.getConnection());
        PointList newPointList = bracketConnectionQuery.getNewPointList();
        PointList feedbackScreenList = new PointList(newPointList.size());
        double zoom = GraphicalHelper.getZoom((IGraphicalEditPart)this.bracketEdgeEditPart);
        int i = 0;
        while (i < newPointList.size()) {
            Point point = newPointList.getPoint(i);
            point.performScale(zoom);
            feedbackScreenList.addPoint(point);
            ++i;
        }
        PolylineConnection connectionFeedback = new PolylineConnection();
        connectionFeedback.setForegroundColor(FigureUtilities.mixColors((Color)GRAY, (Color)ColorConstants.black));
        connectionFeedback.setLineStyle(3);
        connectionFeedback.setPoints(feedbackScreenList);
        this.removeFeedbackFigure();
        this.addFeedbackFigure((IFigure)connectionFeedback);
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "rotateBendpoint".equals(request.getType())) {
            this.removeFeedbackFigure();
        }
    }

    private void addFeedbackFigure(IFigure figure) {
        this.feedbackFigure = figure;
        this.addFeedback(this.feedbackFigure);
    }

    private void removeFeedbackFigure() {
        if (this.feedbackFigure != null) {
            this.removeFeedback(this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }
}

