/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusBaseItemSemanticEditPolicy;

public class DEdgeReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public DEdgeReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof DEdge)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof EdgeTarget) || !(this.newEnd instanceof EdgeTarget)) {
            return false;
        }
        EdgeTarget target = this.getLink().getTargetNode();
        if (!(this.getLink().eContainer() instanceof DDiagram)) {
            return false;
        }
        DDiagram container = (DDiagram)this.getLink().eContainer();
        return SiriusBaseItemSemanticEditPolicy.LinkConstraints.canExistDEdge_4001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof EdgeTarget) || !(this.newEnd instanceof EdgeTarget)) {
            return false;
        }
        EdgeTarget source = this.getLink().getSourceNode();
        if (!(this.getLink().eContainer() instanceof DDiagram)) {
            return false;
        }
        DDiagram container = (DDiagram)this.getLink().eContainer();
        return SiriusBaseItemSemanticEditPolicy.LinkConstraints.canExistDEdge_4001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSourceNode(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTargetNode(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected DEdge getLink() {
        return (DEdge)this.getElementToEdit();
    }

    protected EdgeTarget getOldSource() {
        return (EdgeTarget)this.oldEnd;
    }

    protected EdgeTarget getNewSource() {
        return (EdgeTarget)this.newEnd;
    }

    protected EdgeTarget getOldTarget() {
        return (EdgeTarget)this.oldEnd;
    }

    protected EdgeTarget getNewTarget() {
        return (EdgeTarget)this.newEnd;
    }
}

