/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.BorderedNodeLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNode4ItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.DBorderedNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleAwareClippingStrategy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.swt.graphics.Color;

public class DNode4EditPart
extends AbstractDiagramBorderNodeEditPart {
    public static final int VISUAL_ID = 3012;
    protected DefaultSizeNodeFigure nodePlate = null;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_BACK = new Color(null, 25, 22, 123);

    public DNode4EditPart(View view) {
        super(view);
    }

    public IFigure getNodePlate() {
        return this.nodePlate;
    }

    @Override
    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", this.getPrimaryDragEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNode4ItemSemanticEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BorderedNodeLayoutEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
    }

    protected NodeFigure createNodeFigure() {
        DBorderedNodeFigure nodeFigure = new DBorderedNodeFigure((IFigure)this.createMainFigure());
        nodeFigure.getBorderItemContainer().add((IFigure)new FoldingToggleImageFigure(this));
        nodeFigure.getBorderItemContainer().setClippingStrategy((IClippingStrategy)new FoldingToggleAwareClippingStrategy());
        return nodeFigure;
    }

    protected IFigure createNodeShape() {
        ViewNodePortFigureDesc figure = new ViewNodePortFigureDesc();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public ViewNodePortFigureDesc getPrimaryShape() {
        return (ViewNodePortFigureDesc)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof DNodeNameEditPart) {
            if (this.resolveSemanticElement() instanceof DNode) {
                DNode node = (DNode)this.resolveSemanticElement();
                StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(node.getDiagramElementMapping(), node.getStyle());
                IBorderItemLocator locator = styleConfiguration.getNameBorderItemLocator(node, this.getMainFigure());
                borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
            } else {
                BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 4);
                locator.setBorderItemOffset(IBorderItemOffsets.NO_OFFSET);
                borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
            }
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        AirDefaultSizeNodeFigure result = null;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DStylizable && eObj instanceof DDiagramElement) {
            DStylizable viewNode = (DStylizable)eObj;
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(((DDiagramElement)eObj).getDiagramElementMapping(), viewNode.getStyle());
            AnchorProvider anchorProvider = styleConfiguration.getAnchorProvider();
            result = new AirDefaultSizeNodeFigure(this.getMapMode().DPtoLP(5), this.getMapMode().DPtoLP(5), anchorProvider);
            this.nodePlate = result;
        }
        return result;
    }

    @Override
    public void activate() {
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(this.getZoomManager());
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.nodePlate instanceof AirDefaultSizeNodeFigure) {
            ((AirDefaultSizeNodeFigure)this.nodePlate).setZoomManager(null);
        }
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(SiriusVisualIDRegistry.getType(5010));
    }

    @Override
    public SiriusWrapLabel getNodeLabel() {
        return this.getPrimaryShape().getNodeLabel();
    }

    @Override
    public IFigure getPrimaryFigure() {
        return this.getPrimaryShape();
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNode.class;
    }

    public class ViewNodePortFigureDesc
    extends RectangleFigure {
        private final SiriusWrapLabel nodeLabel = new SiriusWrapLabel();
        private boolean myUseLocalCoordinates = false;

        public ViewNodePortFigureDesc() {
            FlowLayout layoutThis = new FlowLayout();
            layoutThis.setStretchMinorAxis(false);
            layoutThis.setMinorAlignment(1);
            layoutThis.setMajorAlignment(1);
            layoutThis.setMajorSpacing(5);
            layoutThis.setMinorSpacing(5);
            layoutThis.setHorizontal(true);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setFill(false);
            this.setOutline(false);
            this.setLineWidth(0);
            this.nodeLabel.setTextWrap(true);
            this.nodeLabel.setForegroundColor(ColorConstants.black);
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public SiriusWrapLabel getNodeLabel() {
            return this.nodeLabel;
        }
    }
}

